/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.geography.names.GeographicMapper;
import org.eclipse.stem.ui.Utility;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.ModelParameters;
import org.eclipse.stem.util.analysis.ParameterEstimator;
import org.eclipse.stem.util.analysis.ParameterEstimatorFactory;
import org.eclipse.stem.util.analysis.ParameterEstimatorMethod;
import org.eclipse.stem.util.analysis.views.EstimatorControl;
import org.eclipse.stem.util.analysis.views.Messages;

public class ScenarioParameterEstimator {
    ReferenceScenarioDataMapImpl referenceScenarioDataMap = null;
    ParameterEstimatorMethod parameterEstimatorMethod = null;
    Set<String> referenceLocations;
    Map<String, Double> referenceAreaDataMap;
    Map<String, Double> referencePopulationDataMap;
    Map<String, Double> maxInfectiousMap = new HashMap<String, Double>();
    ParameterEstimator estimator;
    private static final String AREA_URI_PREFIX = "label/area";
    private static final String POPULATION_URI_PREFIX = "label/population";
    private static final String SPECIES = "human";
    public static final int ALL_MODE = 0;
    public static final int NON_ZERO_DATA_MODE = 1;
    public static final String LEVEL_STRING = "level";
    private static final double FITTING_FRACTION = 0.05;
    protected EstimatorControl control = null;

    public ScenarioParameterEstimator(ReferenceScenarioDataMapImpl scenarioDataMap, ParameterEstimatorMethod parameterEstimatorMethod) {
        this.referenceScenarioDataMap = scenarioDataMap;
        this.parameterEstimatorMethod = parameterEstimatorMethod;
        this.referenceLocations = this.getReferenceLocations();
        this.getAreaDataMap();
        this.getPopulationDataMap();
    }

    public Map<String, ModelParameters> estimateParameters(Map<String, Object> controlParamtersMap, IRunnableContext runnableContext) {
        final Map<String, Object> finalParameterMap = controlParamtersMap;
        final ParameterEstimatorMethod method = this.parameterEstimatorMethod;
        IScenarioParameterEstimatorRunnableWithProgress analysisTask = new IScenarioParameterEstimatorRunnableWithProgress(){
            public Map<String, ModelParameters> fittedParameters = new HashMap<String, ModelParameters>();

            public void run(IProgressMonitor progress) {
                Iterator<String> iter = ScenarioParameterEstimator.this.referenceLocations.iterator();
                progress.beginTask("Estimating parameters", ScenarioParameterEstimator.this.referenceLocations.size());
                while (iter.hasNext()) {
                    String id = iter.next();
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance locationDataMap = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(id);
                    ScenarioParameterEstimator.this.estimator = ParameterEstimatorFactory.createEstimator(method, locationDataMap);
                    ScenarioParameterEstimator.this.estimator.setAllParameters(finalParameterMap);
                    double localArea = ScenarioParameterEstimator.this.getArea(id);
                    if (!$assertionsDisabled && !(localArea > 0.0)) {
                        throw new AssertionError();
                    }
                    if (localArea == 0.0) {
                        localArea = 1.0;
                    }
                    double localPopulation = ScenarioParameterEstimator.this.getPopulation(id);
                    double localDensity = localPopulation / localArea;
                    ModelParameters parameters = ScenarioParameterEstimator.this.estimator.estimate(localDensity, localPopulation, id);
                    this.fittedParameters.put(id, parameters);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progress.worked(1);
                }
                progress.done();
            }

            @Override
            public Map<String, ModelParameters> getFittedParameters() {
                return this.fittedParameters;
            }
        };
        try {
            runnableContext.run(true, true, (IRunnableWithProgress)analysisTask);
        }
        catch (InterruptedException ie) {
            Activator.logError("", ie);
            return null;
        }
        catch (InvocationTargetException ite) {
            Activator.logError("", ite);
            return null;
        }
        return analysisTask.getFittedParameters();
    }

    public ModelParameters averageThenEstimateParameters(Map<String, Object> controlParamtersMap, IRunnableContext runnableContext) {
        final Map<String, Object> finalParameterMap = controlParamtersMap;
        final ParameterEstimatorMethod method = this.parameterEstimatorMethod;
        IAveragedParameterEstimatorRunnableWithProgress analysisTask = new IAveragedParameterEstimatorRunnableWithProgress(){
            ModelParameters modelParameters = null;

            public void run(IProgressMonitor progress) {
                Iterator<String> iter = ScenarioParameterEstimator.this.referenceLocations.iterator();
                progress.beginTask("Averaging data", ScenarioParameterEstimator.this.referenceLocations.size());
                ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance averagedDataMap = null;
                double localArea = 0.0;
                double localPopulation = 0.0;
                ScenarioParameterEstimator.this.referenceScenarioDataMap.findMaxIncidence();
                String idMax = ScenarioParameterEstimator.this.referenceScenarioDataMap.getMaxIncidenceLocation();
                localArea += ScenarioParameterEstimator.this.getArea(idMax).doubleValue();
                localPopulation += ScenarioParameterEstimator.this.getPopulation(idMax).doubleValue();
                ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance maxlocationDataMap = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(idMax);
                averagedDataMap = maxlocationDataMap.clone();
                while (iter.hasNext()) {
                    String id = iter.next();
                    if (id.equalsIgnoreCase(idMax)) continue;
                    localArea += ScenarioParameterEstimator.this.getArea(id).doubleValue();
                    localPopulation += ScenarioParameterEstimator.this.getPopulation(id).doubleValue();
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance locationDataMap = ScenarioParameterEstimator.this.referenceScenarioDataMap.getLocation(id);
                    averagedDataMap.integrateData(locationDataMap.instance);
                }
                ScenarioParameterEstimator.this.estimator = ParameterEstimatorFactory.createEstimator(method, averagedDataMap);
                ScenarioParameterEstimator.this.estimator.setAllParameters(finalParameterMap);
                if (!$assertionsDisabled && !(localArea > 0.0)) {
                    throw new AssertionError();
                }
                if (localArea == 0.0) {
                    localArea = 1.0;
                }
                double localDensity = localPopulation / localArea;
                this.modelParameters = ScenarioParameterEstimator.this.estimator.estimate(localDensity, localPopulation, Messages.getString("EST.AVERAGE"));
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                progress.worked(1);
                progress.done();
            }

            @Override
            public ModelParameters getModelParameters() {
                return this.modelParameters;
            }
        };
        try {
            runnableContext.run(true, true, (IRunnableWithProgress)analysisTask);
        }
        catch (InterruptedException ie) {
            Activator.logError("", ie);
            return null;
        }
        catch (InvocationTargetException ite) {
            Activator.logError("", ite);
            return null;
        }
        return analysisTask.getModelParameters();
    }

    private Set<String> getReferenceLocations() {
        HashSet<String> locationsToFit = new HashSet<String>();
        Set allLocations = this.referenceScenarioDataMap.getLocations();
        double globalMaxI = 0.0;
        Iterator iter = allLocations.iterator();
        while (iter != null && iter.hasNext()) {
            String id = (String)iter.next();
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance locationDataMap = this.referenceScenarioDataMap.getLocation(id);
            List iData = locationDataMap.getItotals();
            double localMax = 0.0;
            int i = 0;
            while (i < iData.size()) {
                double infectious = (Double)iData.get(i);
                if (localMax < infectious) {
                    localMax = infectious;
                }
                if (globalMaxI < localMax) {
                    globalMaxI = localMax;
                }
                ++i;
            }
            this.maxInfectiousMap.put(id, new Double(localMax));
        }
        Iterator<String> iter2 = this.maxInfectiousMap.keySet().iterator();
        while (iter2 != null && iter2.hasNext()) {
            String id = iter2.next();
            double localMaxI = this.maxInfectiousMap.get(id);
            if (!(localMaxI >= 0.05 * globalMaxI)) continue;
            locationsToFit.add(id);
        }
        return locationsToFit;
    }

    Double getArea(String id) {
        double area = 0.0;
        URI uri = this.getAreaURI(id);
        AreaLabel areaLabel = (AreaLabel)Utility.getLabel((URI)uri);
        if (areaLabel == null) {
            Activator.logError("area label is null", new NumberFormatException("null area"));
        }
        area = areaLabel.getCurrentAreaValue().getArea();
        return new Double(area);
    }

    Double getPopulation(String id) {
        double pop = 0.0;
        URI uri = this.getPopulationURI(id);
        PopulationLabel popLabel = (PopulationLabel)Utility.getLabel((URI)uri);
        if (popLabel == null) {
            Activator.logError("Population label is null", new NumberFormatException("null population"));
        }
        pop = popLabel.getCurrentPopulationValue().getCount();
        return new Double(pop);
    }

    Map<String, Double> getAreaDataMap() {
        HashMap<String, Double> areaMap = new HashMap<String, Double>();
        for (String id : this.referenceLocations) {
            Double area = this.getArea(id);
            areaMap.put(id, area);
        }
        return areaMap;
    }

    Map<String, Double> getPopulationDataMap() {
        HashMap<String, Double> popMap = new HashMap<String, Double>();
        for (String id : this.referenceLocations) {
            Double population = this.getPopulation(id);
            popMap.put(id, population);
        }
        return popMap;
    }

    public static double[] getDoubleValues(List<String> dataList) {
        double[] retValue = new double[dataList.size()];
        try {
            int i = 0;
            while (i < dataList.size()) {
                Double dbleObj = new Double(dataList.get(i));
                retValue[i] = dbleObj;
                ++i;
            }
        }
        catch (Exception e) {
            Activator.logError("String Data not valid. Expecting Double values", e);
        }
        return retValue;
    }

    public ParameterEstimator getEstimator() {
        return this.estimator;
    }

    URI getAreaURI(String id) {
        String countryCode;
        int level = this.getLevel(id);
        if (level == 0) {
            countryCode = id;
        } else {
            String twoLetterCode = id.substring(0, 2);
            countryCode = GeographicMapper.getAlpha3((String)twoLetterCode);
        }
        String composite = "stem://org.eclipse.stem/label/area/" + countryCode + "/" + this.getLevel(id) + "/" + id;
        URI uri = URI.createURI((String)composite);
        return uri;
    }

    URI getPopulationURI(String id) {
        String countryCode;
        int level = this.getLevel(id);
        if (level == 0) {
            countryCode = id;
        } else {
            String twoLetterCode = id.substring(0, 2);
            countryCode = GeographicMapper.getAlpha3((String)twoLetterCode);
        }
        String composite = null;
        int year = 2000;
        while (year < 2020) {
            composite = "stem://org.eclipse.stem/label/population/" + countryCode + "/" + this.getLevel(id) + "/" + SPECIES + "/" + year + "/" + id;
            try {
                URI populationGraphURI = Utility.createPopulationGraphURI((URI)URI.createURI((String)composite));
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
                resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", new XMIResourceFactoryImpl());
                Resource resource = resourceSet.getResource(populationGraphURI, true);
                Identifiable ident = (Identifiable)resource.getContents().get(0);
                Graph populationGraph = (Graph)ident;
                if (populationGraph != null) {
                    break;
                }
            }
            catch (Exception exception) {}
            ++year;
        }
        URI uri = URI.createURI(composite);
        return uri;
    }

    private int getLevel(String id) {
        if (id.indexOf("-") == -1) {
            return 0;
        }
        int idx1 = id.indexOf("-");
        String firstPart = id.substring(idx1 + 1, id.length());
        if (firstPart.indexOf("-") == -1) {
            return 1;
        }
        int idx2 = firstPart.indexOf("-");
        String secondPart = firstPart.substring(idx2 + 1, firstPart.length());
        if (secondPart.indexOf("-") == -1) {
            return 2;
        }
        int idx3 = secondPart.indexOf("-");
        String thirdPart = secondPart.substring(idx3 + 1, secondPart.length());
        if (thirdPart.indexOf("-") == -1) {
            return 3;
        }
        return 4;
    }

    public double[] getValues(int chartIndex, int state) {
        return this.estimator.getValues(chartIndex, state);
    }

    private static interface IAveragedParameterEstimatorRunnableWithProgress
    extends IRunnableWithProgress {
        public ModelParameters getModelParameters();
    }

    private static interface IScenarioParameterEstimatorRunnableWithProgress
    extends IRunnableWithProgress {
        public Map<String, ModelParameters> getFittedParameters();
    }
}

