/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.util.analysis.MonitorPreferences;
import org.eclipse.stem.util.analysis.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AnalysisControl
extends Composite {
    MonitorPreferences prefs = new MonitorPreferences();
    protected Label simulationNameLabel;
    static final String ROOT_PATH = Platform.getLocation().toOSString();
    protected static Map<String, Object> controlParametersMap = new HashMap<String, Object>();
    protected String userMessage = "";
    public static final String INCIDENCE = "Incidence";
    public static final String DELTABIRTHS = "deltaBirths";
    public static final String DELTADEATHS = "deltaDeaths";
    public static final String TIME = "time";
    public static final String ITERATION = "#iteration";
    protected Label userMessageLabel = null;
    protected Button analyzeButton = null;
    protected Button selectEstimatorButton = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    protected Label identifiableTitle;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public AnalysisControl(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AnalysisControl.this.dispose();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
    }

    protected Composite createTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        FillLayout topCompositeLayout = new FillLayout(512);
        topComposite.setLayout((Layout)topCompositeLayout);
        this.simulationNameLabel = new Label(topComposite, 0x1000000);
        this.simulationNameLabel.setText("");
        return topComposite;
    }

    Composite getAnalyzeButtonComposite(AnalysisControl control, String label) {
        Composite analyzeComposite = new Composite((Composite)control, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        analyzeComposite.setLayout((Layout)fillLayout);
        Label leftLabel = new Label(analyzeComposite, 0);
        leftLabel.setText(" ");
        this.analyzeButton = new Button(analyzeComposite, 0);
        this.analyzeButton.setText(label);
        Label rightLabel = new Label(analyzeComposite, 0);
        rightLabel.setText(" ");
        return analyzeComposite;
    }

    protected abstract void initializeHeader(String var1);

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener listener) {
        this.removeListeners.add(listener);
    }

    public void removeIRemoveListener(IRemoveListener listener) {
        this.removeListeners.remove(listener);
    }

    public void fireRemoveEvent(Set<Identifiable> identifiablesToFit) {
        for (IRemoveListener listener : this.removeListeners) {
            Iterator<Identifiable> iter = identifiablesToFit.iterator();
            while (iter != null && iter.hasNext()) {
                Identifiable ident = iter.next();
                listener.identifiableRemoved(ident);
            }
        }
    }

    public abstract double[] getValues(int var1, int var2);

    public void updateMessage() {
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public void updateMessage(String message) {
        this.userMessage = message;
        if (this.userMessageLabel != null) {
            this.userMessageLabel.setText(this.userMessage);
        }
    }

    public abstract String getProperty(int var1, int var2);

    public abstract int getNumProperties(int var1);

    public abstract Map<String, Object> getControlParametersMap();

    protected Font getLargerFont(int size, Display display) {
        FontData[] fontData = this.identifiableTitle.getFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(size);
            ++i;
        }
        return new Font((Device)display, fontData);
    }
}

