/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.AggregateDataWriter;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class TimeSeriesCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private AnalysisControl control = null;
    private int chartIndex = 0;
    private static String defaultKey = AggregateDataWriter.getKeyS();
    protected static final ColorDefinition[] colorDefault = new ColorDefinition[]{ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.BLACK(), ColorDefinitionImpl.GREY(), ColorDefinitionImpl.CYAN(), ColorDefinitionImpl.ORANGE()};
    private boolean overlayMode = false;
    private int seriesCount = 0;
    Menu popUpMenu = null;
    private LinearScaleAction linearTimeAction;
    private LogScaleAction logTimeAction;
    protected boolean useLinearTimeScale = true;
    private LegendViewAction viewLegend;
    private LegendHideAction hideLegend;
    protected boolean showLegend = true;
    protected Legend legend = null;
    protected final Map<String, DataSeries> dataSeriesMap = new HashMap<String, DataSeries>();
    protected Map<String, Boolean> visibleMap = new HashMap<String, Boolean>();
    private final List<Double> cycleNumbers = new ArrayList<Double>();
    Generator gr;
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxY = -1.0;
    private double minYscale = 1.0;
    public String Ordinate_LEGEND = "Y";
    public String Ordinate_AXIS = "Y";
    private ColorDefinition foreGround = ColorDefinitionImpl.WHITE();
    private ColorDefinition backgroundGround = ColorDefinitionImpl.BLACK();
    private ColorDefinition frameColor = ColorDefinitionImpl.create((int)180, (int)180, (int)200);
    Image imgChart = null;

    public TimeSeriesCanvas(AnalysisControl analysisControl, Composite parent, String ordinateString, String yAxisLabel, String defaultYDataType, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex, boolean overlayMode) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        defaultKey = defaultYDataType;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.overlayMode = overlayMode;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError(Messages.getString("COMMON.ERRORINIT"), pex);
            return;
        }
        this.control = analysisControl;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(TimeSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError(Messages.getString("COMMON.ERRORINIT"), ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public TimeSeriesCanvas(Composite parent, String ordinateString, String yAxisLabel, String defaultYDataType, ColorDefinition foreground, ColorDefinition background, ColorDefinition framecolor, int chartIndex) {
        super(parent, 0x20000800);
        this.Ordinate_LEGEND = ordinateString;
        this.Ordinate_AXIS = yAxisLabel;
        defaultKey = defaultYDataType;
        this.foreGround = foreground;
        this.backgroundGround = background;
        this.frameColor = framecolor;
        this.chartIndex = chartIndex;
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError(Messages.getString("COMMON.ERRORINIT"), pex);
            return;
        }
        this.control = (AnalysisControl)parent;
        this.cm = this.createSimpleLineChart(this.dataSeriesMap, this.cycleNumbers, Messages.getString("CC.title"));
        this.resetData();
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (TimeSeriesCanvas.this.imgChart != null) {
                    TimeSeriesCanvas.this.imgChart.dispose();
                }
                TimeSeriesCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                TimeSeriesCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)TimeSeriesCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)TimeSeriesCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    TimeSeriesCanvas.this.gr.render(TimeSeriesCanvas.this.idr, TimeSeriesCanvas.this.gr.build(TimeSeriesCanvas.this.idr.getDisplayServer(), TimeSeriesCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(TimeSeriesCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
        this.createContextMenu((Composite)this);
    }

    public double[] draw() {
        this.resetData();
        this.yAxisPrimary.getSeriesDefinitions().clear();
        int maxLines = this.control.getNumProperties(this.chartIndex);
        int i = 0;
        while (i < maxLines) {
            DataSeries series;
            String property = this.control.getProperty(this.chartIndex, i);
            if (!this.dataSeriesMap.containsKey(property)) {
                series = new DataSeries(property, this.seriesCount, this.overlayMode);
                if (this.visibleMap.containsKey(property)) {
                    series.setVisible(this.visibleMap.get(property));
                } else {
                    series.setVisible(true);
                    this.visibleMap.put(property, Boolean.TRUE);
                }
                ++this.seriesCount;
                this.dataSeriesMap.put(property, series);
            }
            if ((series = this.dataSeriesMap.get(property)).isVisible()) {
                series.show();
            } else {
                series.hide();
            }
            ++i;
        }
        this.updateContextMenu((Composite)this);
        double[] integratedDifference = new double[maxLines];
        int i2 = 0;
        while (i2 < maxLines) {
            integratedDifference[i2] = 0.0;
            ++i2;
        }
        this.maxY = -1.0;
        boolean setCycles = false;
        int maxPoints = 0;
        int i3 = 0;
        while (i3 < maxLines) {
            String property = this.control.getProperty(this.chartIndex, i3);
            double[] doubleValues = this.control.getValues(this.chartIndex, i3);
            DataSeries series = this.dataSeriesMap.get(property);
            if (this.dataSeriesMap.get(property).isVisible()) {
                int j = 0;
                while (j < doubleValues.length) {
                    int n = i3;
                    integratedDifference[n] = integratedDifference[n] + doubleValues[j];
                    if (doubleValues[j] <= this.minYscale && doubleValues[j] > 0.0) {
                        this.minYscale = doubleValues[j];
                    }
                    if (doubleValues[j] >= this.maxY) {
                        this.maxY = doubleValues[j];
                        double log = Math.floor(Math.log10(this.maxY));
                        double adjustedMax = Math.ceil(this.maxY / Math.pow(10.0, log)) * Math.pow(10.0, log);
                        if (adjustedMax <= 1.0) {
                            adjustedMax = 1.0;
                        }
                        if (this.useLinearTimeScale) {
                            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)adjustedMax));
                            double step = adjustedMax / 10.0;
                            this.yAxisPrimary.getScale().setStep(step);
                        } else {
                            double ymax = Math.log(adjustedMax);
                            if (adjustedMax > 1.0) {
                                long imax = Math.round(ymax += 0.499);
                                ymax = imax;
                            }
                            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)ymax));
                            double step = ymax / 10.0;
                            this.yAxisPrimary.getScale().setStep(step);
                        }
                    }
                    ++j;
                }
            }
            int n = i3;
            integratedDifference[n] = integratedDifference[n] / (double)doubleValues.length;
            if (doubleValues.length > 0) {
                if (maxPoints < doubleValues.length) {
                    maxPoints = doubleValues.length;
                }
                int cycleNumber = 0;
                while (cycleNumber < doubleValues.length) {
                    double displayValue = doubleValues[cycleNumber];
                    if (displayValue <= this.minYscale) {
                        displayValue = this.minYscale;
                    }
                    Double value = this.useLinearTimeScale ? new Double(displayValue) : new Double(Math.log(displayValue));
                    series.addValue(value);
                    if (!setCycles) {
                        this.cycleNumbers.add(new Double(cycleNumber));
                    }
                    ++cycleNumber;
                }
                if (((SeriesDefinition)this.xAxisPrimary.getSeriesDefinitions().get(0)).getSeries().size() != this.cycleNumbers.size()) {
                    this.xAxisPrimary.getSeriesDefinitions().clear();
                    Series xAxisSeries = SeriesImpl.create();
                    NumberDataSet xValues = NumberDataSetImpl.create(this.cycleNumbers);
                    xAxisSeries.setDataSet((DataSet)xValues);
                    SeriesDefinition sdX = SeriesDefinitionImpl.create();
                    this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
                    sdX.getSeries().add((Object)xAxisSeries);
                }
                setCycles = true;
            }
            ++i3;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
        if (this.chartIndex == 1) {
            this.control.updateMessage(ScenarioAnalysisSuite.READY_MSG);
        } else {
            this.control.updateMessage(ScenarioAnalysisSuite.WORKING_MSG);
        }
        return integratedDifference;
    }

    public final Chart createSimpleLineChart(Map<String, DataSeries> dataSeriesMap, List<Double> cycleNumbers, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        retValue.getBlock().setBackground((Fill)this.frameColor);
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)this.backgroundGround);
        retValue.getTitle().setVisible(false);
        this.legend = retValue.getLegend();
        LineAttributes lia = this.legend.getOutline();
        this.legend.getText().getFont().setSize(8.0f);
        lia.setStyle(LineStyle.SOLID_LITERAL);
        this.legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        this.legend.getOutline().setVisible(false);
        this.legend.setAnchor(Anchor.NORTH_LITERAL);
        this.legend.setPosition(Position.BELOW_LITERAL);
        this.legend.getText().setColor(this.foreGround);
        this.legend.getOutline().setColor(this.foreGround);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.TEXT_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().setVisible(false);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getTitle().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        Series xAxisSeries = SeriesImpl.create();
        xAxisSeries.getLabel().getCaption().setColor(this.foreGround);
        xAxisSeries.getLabel().getOutline().setColor(this.foreGround);
        NumberDataSet xValues = NumberDataSetImpl.create(cycleNumbers);
        xAxisSeries.setDataSet((DataSet)xValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
        this.xAxisPrimary.setCategoryAxis(false);
        sdX.getSeries().add((Object)xAxisSeries);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.xAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.xAxisPrimary.getTitle().getCaption().setValue(Messages.getString("TS.TIMELABEL"));
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getLabel().getCaption().setColor(this.foreGround);
        this.yAxisPrimary.getTitle().getCaption().setValue(this.Ordinate_AXIS);
        this.yAxisPrimary.getTitle().setVisible(true);
        if (!dataSeriesMap.containsKey(defaultKey)) {
            DataSeries series = new DataSeries(defaultKey, this.seriesCount, this.overlayMode);
            ++this.seriesCount;
            dataSeriesMap.put(defaultKey, series);
        }
        return retValue;
    }

    protected void createContextMenu(Composite parent) {
        MenuManager contextMenuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        contextMenuManager.add((IAction)this.linearTimeAction);
        contextMenuManager.add((IAction)this.logTimeAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        contextMenuManager.add((IAction)this.viewLegend);
        contextMenuManager.add((IAction)this.hideLegend);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(this.popUpMenu);
    }

    private void updateContextMenu(Composite parent) {
        this.popUpMenu.dispose();
        MenuManager contextMenuManager = new MenuManager();
        this.linearTimeAction = new LinearScaleAction();
        this.logTimeAction = new LogScaleAction();
        contextMenuManager.add((IAction)this.linearTimeAction);
        contextMenuManager.add((IAction)this.logTimeAction);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        this.viewLegend = new LegendViewAction();
        this.hideLegend = new LegendHideAction();
        contextMenuManager.add((IAction)this.viewLegend);
        contextMenuManager.add((IAction)this.hideLegend);
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        int i = 0;
        while (i < this.control.getNumProperties(this.chartIndex)) {
            String nextProp = this.control.getProperty(this.chartIndex, i);
            DataSeries series = this.dataSeriesMap.get(nextProp);
            DisplayableProperty property = new DisplayableProperty(nextProp, series.isVisible());
            contextMenuManager.add((IAction)property);
            ++i;
        }
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public static void setColorDefs(List<String> propertiesToPlot, List<LineSeries> lsList) {
        Map colorMap = VisualizationPreferencePage.getColorMapping();
        int i = 0;
        while (i < lsList.size()) {
            ColorDefinition color = ColorDefinitionImpl.BLUE();
            if (propertiesToPlot != null && propertiesToPlot.size() > i) {
                String propertyName = propertiesToPlot.get(i);
                for (String key : colorMap.keySet()) {
                    if (!propertyName.startsWith(key) || key.length() < 1) continue;
                    String tail = propertyName.substring(key.length(), propertyName.length());
                    if (tail == null || tail.length() == 0) {
                        STEMColor c = (STEMColor)colorMap.get(key);
                        color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                        break;
                    }
                    boolean hit = true;
                    char[] cArray = tail.toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (!Character.isDigit(c)) {
                            hit = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!hit) continue;
                    STEMColor c = (STEMColor)colorMap.get(key);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                    break;
                }
                lsList.get(i).setSeriesIdentifier((Object)propertyName);
                lsList.get(i).getLineAttributes().setColor(color);
            } else if (lsList.get(i) != null) {
                lsList.get(i).setSeriesIdentifier((Object)" ");
                lsList.get(i).getLineAttributes().setColor(color);
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        this.seriesCount = 0;
        this.cycleNumbers.add(new Double(0.0));
    }

    private void clearData() {
        this.dataSeriesMap.clear();
        this.cycleNumbers.clear();
    }

    void toggleAxisScale() {
        if (this.useLinearTimeScale) {
            this.logTimeAction.setChecked(true);
            this.linearTimeAction.setChecked(false);
            this.yAxisPrimary.getScale().setMin(null);
            this.yAxisPrimary.getScale().setMax(null);
            this.yAxisPrimary.getScale().unsetStep();
            this.yAxisPrimary.getScale().unsetStepNumber();
        } else {
            this.logTimeAction.setChecked(false);
            this.linearTimeAction.setChecked(true);
            this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
            this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
            this.yAxisPrimary.getScale().setStep(0.25);
        }
        this.useLinearTimeScale = !this.useLinearTimeScale;
        this.draw();
    }

    void toggleLegend() {
        if (this.showLegend) {
            this.viewLegend.setChecked(false);
            this.hideLegend.setChecked(true);
            this.legend.setVisible(false);
        } else {
            this.viewLegend.setChecked(true);
            this.hideLegend.setChecked(false);
            this.legend.setVisible(true);
        }
        this.showLegend = !this.showLegend;
        this.draw();
    }

    protected class DataSeries {
        public String propertyName = "";
        public List<Double> relativeValues = new ArrayList<Double>();
        public LineSeries lineSeries = null;
        private boolean visible = true;
        private SeriesDefinition sdY = null;
        private int seriesIndex = 0;
        private boolean overlayMode = false;

        public boolean isVisible() {
            return this.visible;
        }

        public void setVisible(boolean state) {
            this.visible = state;
        }

        public void toggleVisible() {
            this.visible = !this.visible;
        }

        public DataSeries(String propertyName, int index, boolean overlay) {
            this.propertyName = propertyName;
            this.seriesIndex = index;
            this.overlayMode = overlay;
            this.relativeValues = new ArrayList<Double>();
            this.relativeValues.add(new Double(0.0));
            this.addLineSeries(propertyName);
        }

        public void addValue(Double val) {
            if (this.relativeValues == null) {
                this.relativeValues = new ArrayList<Double>();
            }
            this.relativeValues.add(val);
        }

        public void addLineSeries(String propertyName) {
            NumberDataSet orthoValues = NumberDataSetImpl.create(this.relativeValues);
            if (this.lineSeries == null) {
                this.lineSeries = (ScatterSeries)ScatterSeriesImpl.create();
            }
            this.lineSeries.setDataSet((DataSet)orthoValues);
            this.lineSeries.getLineAttributes().setVisible(true);
            this.lineSeries.getMarkers().clear();
            this.setColorDefs(propertyName);
            this.sdY = SeriesDefinitionImpl.create();
            this.sdY.getSeriesPalette().update(-2);
            this.sdY.getSeries().add((Object)this.lineSeries);
            TimeSeriesCanvas.this.yAxisPrimary.getSeriesDefinitions().add((Object)this.sdY);
        }

        public void hide() {
            this.lineSeries.setVisible(false);
            this.visible = false;
        }

        public void show() {
            this.lineSeries.setVisible(true);
            this.visible = true;
        }

        public void setColorDefs(String propertyName) {
            ColorDefinition color;
            this.lineSeries.setSeriesIdentifier((Object)propertyName);
            this.lineSeries.setPaletteLineColor(false);
            Map colorMap = VisualizationPreferencePage.getColorMapping();
            boolean colorSet = false;
            if (colorMap != null && colorMap.size() >= 1 && propertyName != null && propertyName.length() >= 1) {
                if (colorMap.containsKey(propertyName)) {
                    STEMColor c = (STEMColor)colorMap.get(propertyName);
                    color = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                    this.lineSeries.getLineAttributes().setColor(color);
                    colorSet = true;
                } else {
                    for (String key : colorMap.keySet()) {
                        if (key.length() < 1 || !propertyName.substring(0, 1).equalsIgnoreCase(key.substring(0, 1))) continue;
                        STEMColor c = (STEMColor)colorMap.get(key);
                        ColorDefinition color2 = ColorDefinitionImpl.create((int)((int)((double)c.getRed() * 255.0)), (int)((int)((double)c.getGreen() * 255.0)), (int)((int)((double)c.getBlue() * 255.0)));
                        this.lineSeries.getLineAttributes().setColor(color2);
                        colorSet = true;
                        break;
                    }
                }
            }
            this.lineSeries.setSeriesIdentifier((Object)propertyName);
            if (this.overlayMode && propertyName.indexOf("*") == 0) {
                this.lineSeries.getLineAttributes().setColor(ColorDefinitionImpl.GREY());
                this.lineSeries.getLineAttributes().setStyle(LineStyle.DOTTED_LITERAL);
                colorSet = true;
            }
            if (!colorSet) {
                int colorIndex = this.seriesIndex % colorDefault.length;
                color = colorDefault[colorIndex];
                this.lineSeries.getLineAttributes().setColor(color);
            }
        }

        public int getDataSize() {
            return this.relativeValues.size();
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        public List<Double> getRelativeValues() {
            return this.relativeValues;
        }

        public void setRelativeValues(List<Double> relativeValues) {
            this.relativeValues = relativeValues;
        }

        public void setLineSeries(LineSeries lineSeries) {
            this.lineSeries = lineSeries;
        }
    }

    protected class DisplayableProperty
    extends Action {
        String property;

        public DisplayableProperty(String property, boolean visibility) {
            super(property, 2);
            this.property = null;
            this.property = property;
            this.setChecked(visibility);
        }

        public String getText() {
            return this.property;
        }

        public void run() {
            DataSeries series = TimeSeriesCanvas.this.dataSeriesMap.get(this.property);
            series.toggleVisible();
            TimeSeriesCanvas.this.dataSeriesMap.put(this.property, series);
            this.setChecked(series.isVisible());
            TimeSeriesCanvas.this.visibleMap.put(this.property, series.isVisible());
            TimeSeriesCanvas.this.draw();
        }
    }

    class LegendHideAction
    extends Action {
        public LegendHideAction() {
            super(Messages.getString("ContextMenu.HideLegend"), 2);
            this.setChecked(!TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.HideLegend");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    protected class LegendViewAction
    extends Action {
        public LegendViewAction() {
            super(Messages.getString("ContextMenu.ShowLegend"), 2);
            this.setChecked(TimeSeriesCanvas.this.showLegend);
        }

        public String getText() {
            return Messages.getString("ContextMenu.ShowLegend");
        }

        public void run() {
            if (TimeSeriesCanvas.this.showLegend) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleLegend();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    protected class LinearScaleAction
    extends Action {
        public LinearScaleAction() {
            super(Messages.getString("ContextMenu.LinearTimeScale"), 2);
            this.setChecked(TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LinearTimeScale");
        }

        public void run() {
            if (TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
            TimeSeriesCanvas.this.draw();
        }
    }

    class LogScaleAction
    extends Action {
        public LogScaleAction() {
            super(Messages.getString("ContextMenu.LogTimeScale"), 2);
            this.setChecked(!TimeSeriesCanvas.this.useLinearTimeScale);
        }

        public String getText() {
            return Messages.getString("ContextMenu.LogTimeScale");
        }

        public void run() {
            if (!TimeSeriesCanvas.this.useLinearTimeScale) {
                this.setChecked(true);
            } else {
                TimeSeriesCanvas.this.toggleAxisScale();
            }
            TimeSeriesCanvas.this.draw();
        }
    }
}

