/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.impl.DefaultReferenceDescription;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultReferenceFinder
implements IReferenceFinder {
    private static final Logger LOG = Logger.getLogger(DefaultReferenceFinder.class);
    private IResourceDescriptions indexData;
    private IResourceServiceProvider.Registry serviceProviderRegistry;

    @Inject
    public DefaultReferenceFinder(IResourceDescriptions indexData, IResourceServiceProvider.Registry serviceProviderRegistry) {
        this.indexData = indexData;
        this.serviceProviderRegistry = serviceProviderRegistry;
    }

    @Override
    public void findReferences(Iterable<URI> targetURIs, final Iterable<URI> sourceResourceURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!Iterables.isEmpty(targetURIs) && !Iterables.isEmpty(sourceResourceURIs)) {
            if (localResourceAccess != null) {
                Iterable localTargetURIs = Iterables.filter(targetURIs, (Predicate)new Predicate<URI>(){

                    public boolean apply(URI input) {
                        return Iterables.contains((Iterable)sourceResourceURIs, (Object)input.trimFragment());
                    }
                });
                this.findLocalReferences(localTargetURIs, localResourceAccess, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
            }
            LinkedHashSet targetURIsAsSet = Sets.newLinkedHashSet(targetURIs);
            subMonitor.setWorkRemaining(targetURIsAsSet.size());
            for (URI sourceResourceURI : sourceResourceURIs) {
                IResourceDescription resourceDescription = this.indexData.getResourceDescription(sourceResourceURI);
                if (resourceDescription == null) continue;
                this.findIndexedReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
    }

    @Override
    public void findAllReferences(Iterable<URI> targetURIs, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> referenceAcceptor, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (!Iterables.isEmpty(targetURIs)) {
            if (localResourceAccess != null) {
                this.findLocalReferences(targetURIs, localResourceAccess, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
            }
            LinkedHashSet targetURIsAsSet = Sets.newLinkedHashSet(targetURIs);
            this.findAllIndexedReferences(referenceAcceptor, subMonitor, targetURIsAsSet);
        }
    }

    protected void findAllIndexedReferences(IAcceptor<IReferenceDescription> referenceAcceptor, SubMonitor subMonitor, Set<URI> targetURIsAsSet) {
        subMonitor.setWorkRemaining(Iterables.size((Iterable)this.indexData.getAllResourceDescriptions()));
        for (IResourceDescription resourceDescription : this.indexData.getAllResourceDescriptions()) {
            this.findIndexedReferences(targetURIsAsSet, resourceDescription, referenceAcceptor, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    protected void findLocalReferences(Iterable<URI> localTargets, IReferenceFinder.ILocalResourceAccess localResourceAccess, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        LinkedHashMultimap resource2target = LinkedHashMultimap.create();
        for (URI targetURI : localTargets) {
            resource2target.put((Object)targetURI.trimFragment(), (Object)targetURI);
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)resource2target.keySet().size());
        for (final URI resourceURI : resource2target.keySet()) {
            if (subMonitor.isCanceled()) {
                return;
            }
            localResourceAccess.readOnly(resourceURI, new IUnitOfWork.Void<ResourceSet>((Multimap)resource2target, acceptor){
                private final /* synthetic */ Multimap val$resource2target;
                private final /* synthetic */ IAcceptor val$acceptor;
                {
                    this.val$resource2target = multimap;
                    this.val$acceptor = iAcceptor;
                }

                public void process(ResourceSet resourceSet) throws Exception {
                    Resource resource = resourceSet.getResource(resourceURI, true);
                    DefaultReferenceFinder.this.findLocalReferencesInResource(this.val$resource2target.get((Object)resourceURI), resource, (IAcceptor<IReferenceDescription>)this.val$acceptor);
                }
            });
            subMonitor.worked(1);
        }
    }

    protected void findLocalReferencesInResource(Iterable<URI> targetURIs, Resource resource, IAcceptor<IReferenceDescription> acceptor) {
        Map localCrossRefs = EcoreUtil.CrossReferencer.find(Collections.singleton(resource));
        Map<EObject, URI> exportedElementsMap = null;
        for (URI targetURI : targetURIs) {
            try {
                Collection crossRefSettings;
                EObject target = resource.getEObject(targetURI.fragment());
                if (target == null || (crossRefSettings = (Collection)localCrossRefs.get(target)) == null) continue;
                for (EStructuralFeature.Setting crossRefSetting : crossRefSettings) {
                    EObject source = crossRefSetting.getEObject();
                    if (!(crossRefSetting.getEStructuralFeature() instanceof EReference)) continue;
                    EReference reference = (EReference)crossRefSetting.getEStructuralFeature();
                    int index = -1;
                    if (reference.isMany()) {
                        List values = (List)source.eGet((EStructuralFeature)reference);
                        int i = 0;
                        while (i < values.size()) {
                            if (target == values.get(i)) {
                                index = i;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (exportedElementsMap == null) {
                        exportedElementsMap = this.createExportedElementsMap(resource);
                    }
                    DefaultReferenceDescription localReferenceDescription = new DefaultReferenceDescription(source, target, reference, index, this.findClosestExportedContainerURI(source, exportedElementsMap));
                    acceptor.accept((Object)localReferenceDescription);
                }
            }
            catch (Exception exc) {
                LOG.error((Object)("Error finding reference to " + Strings.notNull((Object)targetURI)), (Throwable)exc);
            }
        }
    }

    protected Map<EObject, URI> createExportedElementsMap(Resource resource) {
        URI uri = EcoreUtil2.getNormalizedURI((Resource)resource);
        IResourceServiceProvider resourceServiceProvider = this.serviceProviderRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider == null) {
            return Collections.emptyMap();
        }
        IResourceDescription.Manager resourceDescriptionManager = resourceServiceProvider.getResourceDescriptionManager();
        if (resourceDescriptionManager == null) {
            return Collections.emptyMap();
        }
        IResourceDescription resourceDescription = resourceDescriptionManager.getResourceDescription(resource);
        IdentityHashMap exportedElementMap = Maps.newIdentityHashMap();
        if (resourceDescription != null) {
            for (IEObjectDescription exportedEObjectDescription : resourceDescription.getExportedObjects()) {
                EObject eObject = resource.getEObject(exportedEObjectDescription.getEObjectURI().fragment());
                if (eObject == null) continue;
                exportedElementMap.put(eObject, exportedEObjectDescription.getEObjectURI());
            }
        }
        return exportedElementMap;
    }

    protected URI findClosestExportedContainerURI(EObject element, Map<EObject, URI> exportedElementsMap) {
        EObject current = element;
        while (current != null) {
            URI uri = exportedElementsMap.get(current);
            if (uri != null) {
                return uri;
            }
            current = current.eContainer();
        }
        return null;
    }

    protected void findIndexedReferences(Set<URI> targetURIs, IResourceDescription resourceDescription, IAcceptor<IReferenceDescription> acceptor, IProgressMonitor monitor) {
        for (IReferenceDescription referenceDescription : resourceDescription.getReferenceDescriptions()) {
            if (!targetURIs.contains(referenceDescription.getTargetEObjectUri())) continue;
            acceptor.accept((Object)referenceDescription);
        }
    }
}

