/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.serializer.tokens.CrossReferenceSerializer;
import org.eclipse.xtext.ui.refactoring.impl.StatusWrapper;
import org.eclipse.xtext.util.ITextRegion;

public class CrossReferenceSerializerFacade {
    private static final Logger LOG = Logger.getLogger(CrossReferenceSerializerFacade.class);
    private boolean useNewSerializer;
    @Inject(optional=true)
    private org.eclipse.xtext.parsetree.reconstr.impl.CrossReferenceSerializer oldCrossRefSerializer;
    @Inject(optional=true)
    private CrossReferenceSerializer newCrossRefSerializer;

    @Inject
    protected void setSerializer(ISerializer serializer) {
        this.useNewSerializer = serializer instanceof Serializer;
        if (this.useNewSerializer) {
            Assert.isTrue((this.newCrossRefSerializer != null ? 1 : 0) != 0);
        } else {
            Assert.isTrue((this.oldCrossRefSerializer != null ? 1 : 0) != 0);
        }
    }

    public boolean useNewSerializer() {
        return this.useNewSerializer;
    }

    public String serializeCrossRef(EObject owner, CrossReference crossref, EObject target, ITextRegion linkTextRegion, StatusWrapper status) {
        try {
            if (this.useNewSerializer) {
                return this.serializeCrossRefNew(owner, crossref, target, linkTextRegion, status);
            }
            return this.serializeCrossRefOld(owner, crossref, target, linkTextRegion, status);
        }
        catch (Exception exc) {
            LOG.error((Object)"Error updating cross-reference", (Throwable)exc);
            this.handleException(exc, owner, linkTextRegion, status);
            return null;
        }
    }

    protected String serializeCrossRefOld(EObject owner, CrossReference crossref, EObject target, ITextRegion linkTextRegion, StatusWrapper status) {
        String linkText = this.oldCrossRefSerializer.serializeCrossRef(owner, crossref, target, null);
        if (linkText == null) {
            this.handleNameCollision(owner, linkTextRegion, status);
        }
        return linkText;
    }

    protected String serializeCrossRefNew(EObject owner, CrossReference crossref, EObject target, ITextRegion linkTextRegion, StatusWrapper status) {
        final boolean[] hasNameCollision = new boolean[1];
        String linkText = this.newCrossRefSerializer.serializeCrossRef(owner, crossref, target, null, (ISerializationDiagnostic.Acceptor)new ISerializationDiagnostic.ExceptionThrowingAcceptor(){

            public void accept(ISerializationDiagnostic diagnostic) {
                if ("no eobject description found".equals(diagnostic.getId())) {
                    hasNameCollision[0] = true;
                } else {
                    super.accept(diagnostic);
                }
            }
        });
        if (hasNameCollision[0]) {
            return this.handleNameCollision(owner, linkTextRegion, status);
        }
        return linkText;
    }

    protected String handleNameCollision(EObject owner, ITextRegion linkTextRegion, StatusWrapper status) {
        return this.handleError("Renaming element will break existing cross-reference", owner, linkTextRegion, status);
    }

    protected String handleException(Exception exc, EObject owner, ITextRegion linkTextRegion, StatusWrapper status) {
        return this.handleError(exc.getMessage(), owner, linkTextRegion, status);
    }

    protected String handleError(String message, EObject owner, ITextRegion linkTextRegion, StatusWrapper status) {
        status.add(3, message, owner, linkTextRegion);
        return null;
    }
}

