/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.CUCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocTagsSubProcessor {
    private static String[] TAG_ORDER = new String[]{"@author", "@version", "@param", "@return", "@throws", "@see", "@since", "@serial", "@deprecated"};

    public static void getMissingJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        String label;
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(node = ASTNodes.getNormalizedNode(node));
        if (bodyDeclaration == null) {
            return;
        }
        Javadoc javadoc = bodyDeclaration.getJavadoc();
        if (javadoc == null) {
            return;
        }
        StructuralPropertyDescriptor location = node.getLocationInParent();
        if (location == SingleVariableDeclaration.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            if (node.getParent().getLocationInParent() != MethodDeclaration.PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == TypeParameter.NAME_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_paramtag_description;
            StructuralPropertyDescriptor parentLocation = node.getParent().getLocationInParent();
            if (parentLocation != MethodDeclaration.TYPE_PARAMETERS_PROPERTY && parentLocation != TypeDeclaration.TYPE_PARAMETERS_PROPERTY) {
                return;
            }
        } else if (location == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_returntag_description;
        } else if (location == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
            label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_throwstag_description;
        } else {
            return;
        }
        AddMissingJavadocTagProposal proposal = new AddMissingJavadocTagProposal(label, context.getCompilationUnit(), bodyDeclaration, node, 4);
        proposals.add(proposal);
        String label2 = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_allmissing_description;
        AddAllMissingJavadocTagsProposal addAllMissing = new AddAllMissingJavadocTagsProposal(label2, context.getCompilationUnit(), bodyDeclaration, 5);
        proposals.add(addAllMissing);
    }

    public static void getUnusedAndUndocumentedParameterOrExceptionProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        String key;
        ICompilationUnit cu = context.getCompilationUnit();
        IJavaProject project = cu.getJavaProject();
        if (!"enabled".equals(project.getOption("org.eclipse.jdt.core.compiler.doc.comment.support", true))) {
            return;
        }
        boolean isUnusedParam = problem.getProblemId() == 536870974;
        String string = key = isUnusedParam ? "org.eclipse.jdt.core.compiler.problem.unusedParameterIncludeDocCommentReference" : "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionIncludeDocCommentReference";
        if (!"enabled".equals(project.getOption(key, true))) {
            return;
        }
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)ASTNodes.getParent(node, 31);
        if (methodDecl == null || methodDecl.resolveBinding() == null) {
            return;
        }
        String label = isUnusedParam ? CorrectionMessages.JavadocTagsSubProcessor_document_parameter_description : CorrectionMessages.JavadocTagsSubProcessor_document_exception_description;
        AddMissingJavadocTagProposal proposal = new AddMissingJavadocTagProposal(label, context.getCompilationUnit(), (BodyDeclaration)methodDecl, node, 1);
        proposals.add(proposal);
    }

    public static void getMissingJavadocCommentProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws CoreException {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (node == null) {
            return;
        }
        BodyDeclaration declaration = ASTResolving.findParentBodyDeclaration(node);
        if (declaration == null) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ITypeBinding binding = Bindings.getBindingOfParentType((ASTNode)declaration);
        if (binding == null) {
            return;
        }
        if (declaration instanceof MethodDeclaration) {
            String string;
            MethodDeclaration methodDecl = (MethodDeclaration)declaration;
            IMethodBinding methodBinding = methodDecl.resolveBinding();
            IMethodBinding overridden = null;
            if (methodBinding != null) {
                overridden = Bindings.findOverriddenMethod(methodBinding, true);
            }
            if ((string = CodeGeneration.getMethodComment(cu, binding.getName(), methodDecl, overridden, String.valueOf('\n'))) != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_method_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), string));
            }
        } else if (declaration instanceof AbstractTypeDeclaration) {
            String[] typeParamNames;
            String typeQualifiedName = Bindings.getTypeQualifiedName(binding);
            if (declaration instanceof TypeDeclaration) {
                List typeParams = ((TypeDeclaration)declaration).typeParameters();
                typeParamNames = new String[typeParams.size()];
                int i = 0;
                while (i < typeParamNames.length) {
                    typeParamNames[i] = ((TypeParameter)typeParams.get(i)).getName().getIdentifier();
                    ++i;
                }
            } else {
                typeParamNames = new String[]{};
            }
            String string = CodeGeneration.getTypeComment(cu, typeQualifiedName, typeParamNames, String.valueOf('\n'));
            if (string != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_type_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), string));
            }
        } else if (declaration instanceof FieldDeclaration) {
            String comment = "/**\n *\n */\n";
            List fragments = ((FieldDeclaration)declaration).fragments();
            if (fragments != null && fragments.size() > 0) {
                VariableDeclaration decl = (VariableDeclaration)fragments.get(0);
                String fieldName = decl.getName().getIdentifier();
                String typeName = binding.getName();
                comment = CodeGeneration.getFieldComment(cu, typeName, fieldName, String.valueOf('\n'));
            }
            if (comment != null) {
                String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_field_description;
                proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), comment));
            }
        } else if (declaration instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumDecl = (EnumConstantDeclaration)declaration;
            String id = enumDecl.getName().getIdentifier();
            String comment = CodeGeneration.getFieldComment(cu, binding.getName(), id, String.valueOf('\n'));
            String label = CorrectionMessages.JavadocTagsSubProcessor_addjavadoc_enumconst_description;
            proposals.add(new AddJavadocCommentProposal(label, cu, 1, declaration.getStartPosition(), comment));
        }
    }

    public static Set<String> getPreviousTypeParamNames(List<TypeParameter> typeParams, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < typeParams.size()) {
            TypeParameter curr = typeParams.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(String.valueOf('<') + curr.getName().getIdentifier() + '>');
            ++i;
        }
        return previousNames;
    }

    private static Set<String> getPreviousParamNames(List<SingleVariableDeclaration> params, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < params.size()) {
            SingleVariableDeclaration curr = params.get(i);
            if (curr == missingNode) {
                return previousNames;
            }
            previousNames.add(curr.getName().getIdentifier());
            ++i;
        }
        return previousNames;
    }

    private static Set<String> getPreviousExceptionNames(List<Name> list, ASTNode missingNode) {
        HashSet<String> previousNames = new HashSet<String>();
        int i = 0;
        while (i < list.size() && missingNode != list.get(i)) {
            Name curr = list.get(i);
            previousNames.add(ASTNodes.getSimpleNameIdentifier(curr));
            ++i;
        }
        return previousNames;
    }

    public static TagElement findTag(Javadoc javadoc, String name, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            TagElement curr = (TagElement)tags.get(i);
            if (name.equals(curr.getTagName())) {
                if (arg != null) {
                    String argument = JavadocTagsSubProcessor.getArgument(curr);
                    if (arg.equals(argument)) {
                        return curr;
                    }
                } else {
                    return curr;
                }
            }
            ++i;
        }
        return null;
    }

    public static TagElement findParamTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if ("@param".equals(currName) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static TagElement findThrowsTag(Javadoc javadoc, String arg) {
        List tags = javadoc.tags();
        int nTags = tags.size();
        int i = 0;
        while (i < nTags) {
            String argument;
            TagElement curr = (TagElement)tags.get(i);
            String currName = curr.getTagName();
            if (("@throws".equals(currName) || "@exception".equals(currName)) && arg.equals(argument = JavadocTagsSubProcessor.getArgument(curr))) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames) {
        JavadocTagsSubProcessor.insertTag(rewriter, newElement, sameKindLeadingNames, null);
    }

    public static void insertTag(ListRewrite rewriter, TagElement newElement, Set<String> sameKindLeadingNames, TextEditGroup groupDescription) {
        List tags = rewriter.getRewrittenList();
        String insertedTagName = newElement.getTagName();
        TagElement after = null;
        int tagRanking = JavadocTagsSubProcessor.getTagRanking(insertedTagName);
        int i = tags.size() - 1;
        while (i >= 0) {
            String arg;
            TagElement curr = (TagElement)tags.get(i);
            String tagName = curr.getTagName();
            if (tagName == null || tagRanking > JavadocTagsSubProcessor.getTagRanking(tagName)) {
                after = curr;
                break;
            }
            if (sameKindLeadingNames != null && JavadocTagsSubProcessor.isSameTag(insertedTagName, tagName) && (arg = JavadocTagsSubProcessor.getArgument(curr)) != null && sameKindLeadingNames.contains(arg)) {
                after = curr;
                break;
            }
            --i;
        }
        if (after != null) {
            rewriter.insertAfter((ASTNode)newElement, after, groupDescription);
        } else {
            rewriter.insertFirst((ASTNode)newElement, groupDescription);
        }
    }

    private static boolean isSameTag(String insertedTagName, String tagName) {
        if (insertedTagName.equals(tagName)) {
            return true;
        }
        if ("@exception".equals(tagName)) {
            return "@throws".equals(insertedTagName);
        }
        return false;
    }

    private static int getTagRanking(String tagName) {
        if (tagName.equals("@exception")) {
            tagName = "@throws";
        }
        int i = 0;
        while (i < TAG_ORDER.length) {
            if (tagName.equals(TAG_ORDER[i])) {
                return i;
            }
            ++i;
        }
        return TAG_ORDER.length;
    }

    private static String getArgument(TagElement curr) {
        List fragments = curr.fragments();
        if (!fragments.isEmpty()) {
            Object first = fragments.get(0);
            if (first instanceof Name) {
                return ASTNodes.getSimpleNameIdentifier((Name)first);
            }
            if (first instanceof TextElement && "@param".equals(curr.getTagName())) {
                String text = ((TextElement)first).getText();
                if ("<".equals(text) && fragments.size() >= 3) {
                    Object second = fragments.get(1);
                    Object third = fragments.get(2);
                    if (second instanceof Name && third instanceof TextElement && ">".equals(((TextElement)third).getText())) {
                        return String.valueOf('<') + ASTNodes.getSimpleNameIdentifier((Name)second) + '>';
                    }
                } else if (text.startsWith(String.valueOf('<')) && text.endsWith(String.valueOf('>')) && text.length() > 2) {
                    return text.substring(1, text.length() - 1);
                }
            }
        }
        return null;
    }

    public static void getRemoveJavadocTagProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        while (node != null && !(node instanceof TagElement)) {
            node = node.getParent();
        }
        if (node == null) {
            return;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)node.getAST());
        rewrite.remove(node, null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_removetag_description;
        Image image = JavaPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        proposals.add(new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image));
    }

    public static void getInvalidQualificationProposals(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) {
        ASTNode node = problem.getCoveringNode(context.getASTRoot());
        if (!(node instanceof Name)) {
            return;
        }
        Name name = (Name)node;
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ITypeBinding)) {
            return;
        }
        ITypeBinding typeBinding = (ITypeBinding)binding;
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        rewrite.replace((ASTNode)name, (ASTNode)ast.newName(typeBinding.getQualifiedName()), null);
        String label = CorrectionMessages.JavadocTagsSubProcessor_qualifylinktoinner_description;
        Image image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif");
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, context.getCompilationUnit(), rewrite, 5, image);
        proposals.add(proposal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddAllMissingJavadocTagsProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;

        public AddAllMissingJavadocTagsProposal(String label, ICompilationUnit cu, BodyDeclaration bodyDecl, int relevance) {
            super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = bodyDecl;
        }

        @Override
        protected ASTRewrite getRewrite() throws CoreException {
            ASTRewrite rewrite = ASTRewrite.create((AST)this.fBodyDecl.getAST());
            if (this.fBodyDecl instanceof MethodDeclaration) {
                this.insertAllMissingMethodTags(rewrite, (MethodDeclaration)this.fBodyDecl);
            } else {
                this.insertAllMissingTypeTags(rewrite, (TypeDeclaration)this.fBodyDecl);
            }
            return rewrite;
        }

        private void insertAllMissingMethodTags(ASTRewrite rewriter, MethodDeclaration methodDecl) {
            Type type;
            ITypeRoot typeRoot;
            AST ast = methodDecl.getAST();
            Javadoc javadoc = methodDecl.getJavadoc();
            ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            List<TypeParameter> typeParams = methodDecl.typeParameters();
            ASTNode root = methodDecl.getRoot();
            if (root instanceof CompilationUnit && (typeRoot = ((CompilationUnit)root).getTypeRoot()) != null && !StubUtility.shouldGenerateMethodTypeParameterTags(typeRoot.getJavaProject())) {
                typeParams = Collections.emptyList();
            }
            ArrayList<String> typeParamNames = new ArrayList<String>();
            int i = typeParams.size() - 1;
            while (i >= 0) {
                TypeParameter decl = (TypeParameter)typeParams.get(i);
                String name = String.valueOf('<') + decl.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    TextElement text = ast.newTextElement();
                    text.setText(name);
                    newTag.fragments().add(text);
                    this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
                }
                typeParamNames.add(name);
                --i;
            }
            List params = methodDecl.parameters();
            int i2 = params.size() - 1;
            while (i2 >= 0) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)params.get(i2);
                String name = decl.getName().getIdentifier();
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    newTag.fragments().add(ast.newSimpleName(name));
                    this.insertTabStop(rewriter, newTag.fragments(), "methParam" + i2);
                    Set sameKindLeadingNames = JavadocTagsSubProcessor.getPreviousParamNames(params, (ASTNode)decl);
                    sameKindLeadingNames.addAll(typeParamNames);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
                }
                --i2;
            }
            if (!(methodDecl.isConstructor() || (type = methodDecl.getReturnType2()).isPrimitiveType() && ((PrimitiveType)type).getPrimitiveTypeCode() == PrimitiveType.VOID || JavadocTagsSubProcessor.findTag(javadoc, "@return", null) != null)) {
                TagElement newTag = ast.newTagElement();
                newTag.setTagName("@return");
                this.insertTabStop(rewriter, newTag.fragments(), "return");
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
            }
            List thrownExceptions = methodDecl.thrownExceptions();
            int i3 = thrownExceptions.size() - 1;
            while (i3 >= 0) {
                String name;
                Name exception = (Name)thrownExceptions.get(i3);
                ITypeBinding binding = exception.resolveTypeBinding();
                if (binding != null && JavadocTagsSubProcessor.findThrowsTag(javadoc, name = binding.getName()) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@throws");
                    TextElement excNode = ast.newTextElement();
                    excNode.setText(ASTNodes.asString((ASTNode)exception));
                    newTag.fragments().add(excNode);
                    this.insertTabStop(rewriter, newTag.fragments(), "exception" + i3);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(thrownExceptions, (ASTNode)exception));
                }
                --i3;
            }
        }

        private void insertAllMissingTypeTags(ASTRewrite rewriter, TypeDeclaration typeDecl) {
            AST ast = typeDecl.getAST();
            Javadoc javadoc = typeDecl.getJavadoc();
            ListRewrite tagsRewriter = rewriter.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            List typeParams = typeDecl.typeParameters();
            int i = typeParams.size() - 1;
            while (i >= 0) {
                TypeParameter decl = (TypeParameter)typeParams.get(i);
                String name = String.valueOf('<') + decl.getName().getIdentifier() + '>';
                if (JavadocTagsSubProcessor.findTag(javadoc, "@param", name) == null) {
                    TagElement newTag = ast.newTagElement();
                    newTag.setTagName("@param");
                    TextElement text = ast.newTextElement();
                    text.setText(name);
                    newTag.fragments().add(text);
                    this.insertTabStop(rewriter, newTag.fragments(), "typeParam" + i);
                    JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(typeParams, (ASTNode)decl));
                }
                --i;
            }
        }

        private void insertTabStop(ASTRewrite rewriter, List<ASTNode> fragments, String linkedName) {
            TextElement textElement = rewriter.getAST().newTextElement();
            textElement.setText("");
            fragments.add((ASTNode)textElement);
            this.addLinkedPosition(rewriter.track((ASTNode)textElement), false, linkedName);
        }
    }

    private static final class AddJavadocCommentProposal
    extends CUCorrectionProposal {
        private final int fInsertPosition;
        private final String fComment;

        private AddJavadocCommentProposal(String name, ICompilationUnit cu, int relevance, int insertPosition, String comment) {
            super(name, cu, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif"));
            this.fInsertPosition = insertPosition;
            this.fComment = comment;
        }

        protected void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
            try {
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                IJavaProject project = this.getCompilationUnit().getJavaProject();
                IRegion region = document.getLineInformationOfOffset(this.fInsertPosition);
                String lineContent = document.get(region.getOffset(), region.getLength());
                String indentString = Strings.getIndentString(lineContent, project);
                String str = Strings.changeIndent(this.fComment, 0, project, indentString, lineDelimiter);
                InsertEdit edit = new InsertEdit(this.fInsertPosition, str);
                rootEdit.addChild((TextEdit)edit);
                if (this.fComment.charAt(this.fComment.length() - 1) != '\n') {
                    rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, lineDelimiter));
                    rootEdit.addChild((TextEdit)new InsertEdit(this.fInsertPosition, indentString));
                }
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
    }

    private static final class AddMissingJavadocTagProposal
    extends LinkedCorrectionProposal {
        private final BodyDeclaration fBodyDecl;
        private final ASTNode fMissingNode;

        public AddMissingJavadocTagProposal(String label, ICompilationUnit cu, BodyDeclaration methodDecl, ASTNode missingNode, int relevance) {
            super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.jdt.ui.jdoc_tag_obj.gif"));
            this.fBodyDecl = methodDecl;
            this.fMissingNode = missingNode;
        }

        protected ASTRewrite getRewrite() throws CoreException {
            AST ast = this.fBodyDecl.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            this.insertMissingJavadocTag(rewrite, this.fMissingNode, this.fBodyDecl);
            return rewrite;
        }

        private void insertMissingJavadocTag(ASTRewrite rewrite, ASTNode missingNode, BodyDeclaration bodyDecl) {
            TagElement newTag;
            AST ast = bodyDecl.getAST();
            Javadoc javadoc = bodyDecl.getJavadoc();
            if (javadoc == null) {
                javadoc = ast.newJavadoc();
                rewrite.set((ASTNode)bodyDecl, (StructuralPropertyDescriptor)bodyDecl.getJavadocProperty(), (Object)javadoc, null);
            }
            ListRewrite tagsRewriter = rewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY);
            StructuralPropertyDescriptor location = missingNode.getLocationInParent();
            if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)missingNode.getParent();
                String name = ((SimpleName)missingNode).getIdentifier();
                newTag = ast.newTagElement();
                newTag.setTagName("@param");
                newTag.fragments().add(ast.newSimpleName(name));
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDecl;
                List params = methodDeclaration.parameters();
                Set sameKindLeadingNames = JavadocTagsSubProcessor.getPreviousParamNames(params, (ASTNode)decl);
                List typeParams = methodDeclaration.typeParameters();
                int i = 0;
                while (i < typeParams.size()) {
                    String curr = String.valueOf('<') + ((TypeParameter)typeParams.get(i)).getName().getIdentifier() + '>';
                    sameKindLeadingNames.add(curr);
                    ++i;
                }
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, sameKindLeadingNames);
            } else if (location == TypeParameter.NAME_PROPERTY) {
                TypeParameter typeParam = (TypeParameter)missingNode.getParent();
                String name = String.valueOf('<') + ((SimpleName)missingNode).getIdentifier() + '>';
                newTag = ast.newTagElement();
                newTag.setTagName("@param");
                TextElement text = ast.newTextElement();
                text.setText(name);
                newTag.fragments().add(text);
                List params = bodyDecl instanceof TypeDeclaration ? ((TypeDeclaration)bodyDecl).typeParameters() : ((MethodDeclaration)bodyDecl).typeParameters();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousTypeParamNames(params, (ASTNode)typeParam));
            } else if (location == MethodDeclaration.RETURN_TYPE2_PROPERTY) {
                newTag = ast.newTagElement();
                newTag.setTagName("@return");
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, null);
            } else if (location == MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY) {
                newTag = ast.newTagElement();
                newTag.setTagName("@throws");
                TextElement excNode = ast.newTextElement();
                excNode.setText(ASTNodes.asString(missingNode));
                newTag.fragments().add(excNode);
                List exceptions = ((MethodDeclaration)bodyDecl).thrownExceptions();
                JavadocTagsSubProcessor.insertTag(tagsRewriter, newTag, JavadocTagsSubProcessor.getPreviousExceptionNames(exceptions, missingNode));
            } else {
                Assert.isTrue((boolean)false, (String)"AddMissingJavadocTagProposal: unexpected node location");
                return;
            }
            TextElement textElement = ast.newTextElement();
            textElement.setText("");
            newTag.fragments().add(textElement);
            this.addLinkedPosition(rewrite.track((ASTNode)textElement), false, "comment_start");
            if (bodyDecl.getJavadoc() == null) {
                newTag.fragments().add(ast.newTextElement());
            }
        }
    }
}

