/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class NewPackageCreationWizard
extends NewElementWizard {
    private NewPackageWizardPage fPage;

    public NewPackageCreationWizard(NewPackageWizardPage page) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWPACK);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.NewPackageCreationWizard_title);
        this.fPage = page;
    }

    public NewPackageCreationWizard() {
        this(null);
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewPackageWizardPage();
            this.fPage.setWizard((IWizard)this);
            this.fPage.init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createPackage(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            IResource resource = this.fPage.getModifiedResource();
            this.selectAndReveal(resource);
            if (resource instanceof IFile && resource.getName().equals("package-info.java")) {
                this.openResource((IFile)resource);
            }
        }
        return res;
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getNewPackageFragment();
    }
}

