/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalTypeReference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class IllegalImplementsProblemDetector
extends AbstractIllegalTypeReference {
    private HashMap fRestrictedInterfaces = new HashMap();

    public int getReferenceKinds() {
        return 2;
    }

    protected int getProblemKind() {
        return 4;
    }

    protected String getSeverityKey() {
        return "ILLEGAL_IMPLEMENT";
    }

    public boolean considerReference(IReference reference) {
        block7: {
            block6: {
                if (!super.considerReference(reference)) break block6;
                return true;
            }
            try {
                IApiType type = (IApiType)reference.getMember();
                IApiType[] inters = type.getSuperInterfaces();
                IApiType inter = null;
                int j = 0;
                while (j < inters.length) {
                    if (inters[j].getName().equals(reference.getReferencedTypeName())) {
                        inter = inters[j];
                        break;
                    }
                    ++j;
                }
                if (inter != null && this.findRestrictedSuperinterfaces(type.getApiComponent(), reference.getReferencedTypeName(), inter)) {
                    this.retainReference(reference);
                    return true;
                }
            }
            catch (CoreException ce) {
                if (!ApiPlugin.DEBUG_PROBLEM_DETECTOR) break block7;
                ApiPlugin.log(ce);
            }
        }
        return false;
    }

    protected boolean isProblem(IReference reference) {
        try {
            IApiMember member;
            if (this.isIllegalType(reference)) {
                return super.isProblem(reference);
            }
            if (this.fRestrictedInterfaces.size() > 0 && (member = reference.getMember()).getType() == 2) {
                IApiType itype = (IApiType)this.fRestrictedInterfaces.get(reference.getReferencedTypeName());
                return itype != null && !this.isImplemented(((IApiType)member).getSuperclass(), itype.getName());
            }
            return true;
        }
        catch (CoreException ce) {
            if (ApiPlugin.DEBUG_PROBLEM_DETECTOR) {
                ApiPlugin.log(ce);
            }
            return super.isProblem(reference);
        }
    }

    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        if (this.isIllegalType(reference)) {
            return super.getMessageArgs(reference);
        }
        if (this.fRestrictedInterfaces.size() > 0 && (inter = (IApiType)this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            return new String[]{this.getSimpleTypeName(type), inter.getSimpleName(), this.getSimpleTypeName(reference.getMember())};
        }
        return super.getMessageArgs(reference);
    }

    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        if (this.isIllegalType(reference)) {
            return super.getQualifiedMessageArgs(reference);
        }
        if (this.fRestrictedInterfaces.size() > 0 && (inter = (IApiType)this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            return new String[]{this.getQualifiedTypeName(type), inter.getName(), this.getQualifiedTypeName(reference.getMember())};
        }
        return super.getQualifiedMessageArgs(reference);
    }

    protected int getProblemFlags(IReference reference) {
        if (this.isIllegalType(reference)) {
            return super.getProblemFlags(reference);
        }
        return 10;
    }

    private boolean isImplemented(IApiType type, String iname) throws CoreException {
        if (type == null) {
            return false;
        }
        if (this.isImplemented(iname, type.getSuperInterfaces())) {
            return true;
        }
        return this.isImplemented(type.getSuperclass(), iname);
    }

    private boolean isImplemented(String iname, IApiType[] interfaces) throws CoreException {
        if (interfaces.length == 0) {
            return false;
        }
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(iname)) {
                return true;
            }
            if (this.isImplemented(iname, interfaces[i].getSuperInterfaces())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findRestrictedSuperinterfaces(IApiComponent originalcomponent, String entryinterface, IApiType type) throws CoreException {
        IApiType[] inters = type.getSuperInterfaces();
        if (inters.length == 0) {
            return false;
        }
        IApiAnnotations annot = null;
        IApiComponent comp = null;
        int i = 0;
        while (i < inters.length) {
            comp = inters[i].getApiComponent();
            if (comp != null) {
                if (!comp.equals(originalcomponent) && (annot = comp.getApiDescription().resolveAnnotations(Factory.typeDescriptor(inters[i].getName()))) != null && RestrictionModifiers.isImplementRestriction(annot.getRestrictions())) {
                    return this.fRestrictedInterfaces.put(entryinterface, inters[i]) == null;
                }
                return this.findRestrictedSuperinterfaces(originalcomponent, entryinterface, inters[i]);
            }
            ++i;
        }
        return false;
    }
}

