/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.Activator;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.States;

public class ReferenceScenarioDataMapImpl
extends EObjectImpl
implements ReferenceScenarioDataMap {
    public static final String ITERATION_KEY = "iteration";
    public static final String INCIDENCE_KEY = "Incidence";
    public static final String TIME_KEY = "time";
    private double maxIncidence = 0.0;
    private String maxIncidenceLocation;
    private static final double PPM = 1.0E-6;
    public Set<String> S_KEY_SET = new HashSet<String>();
    public Set<String> E_KEY_SET = new HashSet<String>();
    public Set<String> I_KEY_SET = new HashSet<String>();
    public Set<String> R_KEY_SET = new HashSet<String>();
    public Set<String> INCIDENCE_KEY_SET = new HashSet<String>();
    Map<String, ReferenceScenarioDataInstance> referenceScenarioDataMap = new HashMap<String, ReferenceScenarioDataInstance>();
    private String refDir;
    private String populationIdentifier;
    DiseaseType type;

    protected ReferenceScenarioDataMapImpl() {
    }

    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.REFERENCE_SCENARIO_DATA_MAP;
    }

    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    public void setPopulationIdentifier(String populationIdentifier) {
        this.populationIdentifier = populationIdentifier;
    }

    public void addInstance(String key, ReferenceScenarioDataInstance data) {
        this.referenceScenarioDataMap.put(key, data);
    }

    public void findMaxIncidence() {
        Iterator<String> iter = this.referenceScenarioDataMap.keySet().iterator();
        while (iter != null && iter.hasNext()) {
            String key = iter.next();
            ReferenceScenarioDataInstance data = this.referenceScenarioDataMap.get(key);
            double count = this.getTotalIncidence(data);
            if (!(count >= this.maxIncidence)) continue;
            this.maxIncidence = count;
            this.maxIncidenceLocation = key;
        }
    }

    public DiseaseType getType() {
        if (this.referenceScenarioDataMap == null || this.referenceScenarioDataMap.size() == 0) {
            return null;
        }
        return this.type;
    }

    public void setType(DiseaseType t, Set<String> Skeys, Set<String> Ekeys, Set<String> Ikeys, Set<String> Rkeys, Set<String> IncKeys) {
        this.type = t;
        this.S_KEY_SET = Skeys;
        this.E_KEY_SET = Ekeys;
        this.I_KEY_SET = Ikeys;
        this.R_KEY_SET = Rkeys;
        this.INCIDENCE_KEY_SET = IncKeys;
    }

    public String[] getRegionKeys() {
        Set<String> keySet = this.referenceScenarioDataMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public String[] getModelLabelKeys() {
        Set<String> keySet = this.referenceScenarioDataMap.keySet();
        String[] keys = keySet.toArray(new String[keySet.size()]);
        if (keys != null && keys.length > 0) {
            ReferenceScenarioDataInstance rsdi = this.referenceScenarioDataMap.get(keys[0]);
            Set<String> dataKeysSet = rsdi.instance.keySet();
            String[] dataKeys = dataKeysSet.toArray(new String[dataKeysSet.size()]);
            return dataKeys;
        }
        return null;
    }

    public String[] getS_Keys() {
        String[] keys = new String[]{};
        if (this.S_KEY_SET != null) {
            keys = this.S_KEY_SET.toArray(new String[this.S_KEY_SET.size()]);
        }
        return keys;
    }

    public String[] getE_Keys() {
        String[] keys = new String[]{};
        if (this.E_KEY_SET != null) {
            keys = this.E_KEY_SET.toArray(new String[this.E_KEY_SET.size()]);
        }
        return keys;
    }

    public String[] getI_Keys() {
        String[] keys = new String[]{};
        if (this.I_KEY_SET != null) {
            keys = this.I_KEY_SET.toArray(new String[this.I_KEY_SET.size()]);
        }
        return keys;
    }

    public String[] getR_Keys() {
        String[] keys = new String[]{};
        if (this.R_KEY_SET != null) {
            keys = this.R_KEY_SET.toArray(new String[this.R_KEY_SET.size()]);
        }
        return keys;
    }

    public String[] getInc_KEY_SET() {
        String[] keys = new String[]{};
        if (this.INCIDENCE_KEY_SET != null) {
            keys = this.INCIDENCE_KEY_SET.toArray(new String[this.INCIDENCE_KEY_SET.size()]);
        }
        return keys;
    }

    public int getNumLocations() {
        return this.referenceScenarioDataMap.size();
    }

    public Set<String> getLocations() {
        return this.referenceScenarioDataMap.keySet();
    }

    public double getTotalIncidence(ReferenceScenarioDataInstance instance) {
        double retValue = 0.0;
        if (instance.getData().containsKey(INCIDENCE_KEY)) {
            List<Double> incidence = instance.getData().get(INCIDENCE_KEY);
            int i = 0;
            while (i < incidence.size()) {
                retValue += incidence.get(i).doubleValue();
                ++i;
            }
        }
        return retValue;
    }

    public boolean containsLocation(String loc) {
        return this.referenceScenarioDataMap.containsKey(loc);
    }

    public ReferenceScenarioDataInstance getLocation(String loc) {
        return this.referenceScenarioDataMap.get(loc);
    }

    public ReferenceScenarioDataInstance aggregateScenarioData(IRunnableContext runnableContext) {
        final ReferenceScenarioDataInstance aggregatedData = new ReferenceScenarioDataInstance(this);
        IRunnableWithProgress aggregateTask = new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) {
                progress.beginTask("Aggregating data...", ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.size());
                Iterator<String> iter = ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.keySet().iterator();
                while (iter != null && iter.hasNext()) {
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String loc = iter.next();
                    ReferenceScenarioDataInstance locationData = ReferenceScenarioDataMapImpl.this.referenceScenarioDataMap.get(loc);
                    aggregatedData.integrateData(locationData.instance);
                }
                progress.done();
            }
        };
        try {
            runnableContext.run(true, true, aggregateTask);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return aggregatedData;
    }

    public String getReferenceDirectory() {
        return this.refDir;
    }

    public void setReferenceDirectory(String d) {
        this.refDir = d;
    }

    public double getMaxIncidence() {
        return this.maxIncidence;
    }

    public String getMaxIncidenceLocation() {
        return this.maxIncidenceLocation;
    }

    @Override
    public boolean sane() {
        Activator.logInformation("TODO   ReferenceScenarioDataMapImpl.sane() must be fully implemented !!!");
        Iterator<String> locationIter = this.getLocations().iterator();
        while (locationIter != null && locationIter.hasNext()) {
            String locationID = locationIter.next();
            ReferenceScenarioDataInstance instance = this.getLocation(locationID);
            List<String> popData = instance.getData(States.statesToFit[4]);
            if (popData == null) {
                popData = instance.getData("Population Count");
            }
            List<String> sData = instance.getData(States.statesToFit[0]);
            List<String> eData = null;
            List<String> iData = instance.getData(States.statesToFit[2]);
            List<String> rData = null;
            List<String> ddData = instance.getData(States.statesToFit[6]);
            if (instance.dataMap.getType() == DiseaseType.SEIR) {
                eData = instance.getData(States.statesToFit[1]);
            }
            if (instance.dataMap.getType() != DiseaseType.SI) {
                rData = instance.getData(States.statesToFit[3]);
            }
            int length = popData.size();
            if (sData.size() != length || iData.size() != length || ddData.size() != length) {
                return false;
            }
            if (eData != null && eData.size() != length) {
                return false;
            }
            if (rData != null && rData.size() != length) {
                return false;
            }
            int t = 0;
            while (t < length) {
                double sum = 0.0;
                double s = new Double(sData.get(t));
                double i = new Double(iData.get(t));
                double dd = new Double(ddData.get(t));
                double r = 0.0;
                double e = 0.0;
                if (eData != null) {
                    e = new Double(eData.get(t));
                }
                if (rData != null) {
                    r = new Double(rData.get(t));
                }
                if (s < 0.0 || i < 0.0 || e < 0.0 || r < 0.0 || dd < 0.0) {
                    System.err.println("Negative value found at time = " + t + " s=" + s + " e=" + e + " i=" + i + " r=" + r + "dd= " + dd);
                    return false;
                }
                sum = s + e + i + r;
                if (!this.closeEnough(sum, new Double(popData.get(t)))) {
                    System.err.println("Sum not correct at time = " + t + " difference is " + (sum - new Double(popData.get(t))));
                    return false;
                }
                ++t;
            }
        }
        return true;
    }

    boolean closeEnough(double d1, double d2) {
        boolean retVal = true;
        if (d1 == 0.0) {
            return Math.abs(d2) < 1.0E-6;
        }
        if (d2 == 0.0) {
            return Math.abs(d1) < 1.0E-6;
        }
        double diff = Math.abs(2.0 * (d1 - d2) / (d1 + d2));
        if (diff > 1.0E-6) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean consistentWith(ReferenceScenarioDataMapImpl other) {
        Activator.logInformation("TODO   ReferenceScenarioDataMapImpl.consistentWith(ReferenceScenarioDataMap other) must be fully implemented !!!");
        if (this.getLocations().size() != other.getLocations().size()) {
            Activator.logInformation("Error mismatched number of locations in log files for " + other.getReferenceDirectory() + " vs " + this.getReferenceDirectory());
            return false;
        }
        for (String loc : this.getLocations()) {
            if (other.getLocation(loc) != null) continue;
            Activator.logInformation("Location missing in data map " + other.getReferenceDirectory());
            return false;
        }
        for (String loc : this.getLocations()) {
            ReferenceScenarioDataInstance otherInst = other.getLocation(loc);
            ReferenceScenarioDataInstance thisInst = this.getLocation(loc);
            for (String state : thisInst.getInstance().keySet()) {
                List<String> thisData = thisInst.getInstance().get(state);
                List<String> otherData = otherInst.getInstance().get(state);
                if (thisData.size() != otherData.size()) {
                    System.err.println("Error the list of data values does not have the same length for location " + loc + " folder " + this.getReferenceDirectory());
                    return false;
                }
                int i = 0;
                while (i < thisData.size()) {
                    double otherD;
                    double thisD = Double.parseDouble(thisData.get(i));
                    if (!this.closeEnough(thisD, otherD = Double.parseDouble(otherData.get(i)))) {
                        System.err.println("Error mismatched result for state " + state + " location " + loc + " " + thisD + " not same as " + otherD + " timestep " + i + " folder " + this.getReferenceDirectory() + " vs " + other.getReferenceDirectory());
                        return false;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    public class ReferenceScenarioDataInstance
    implements Cloneable {
        private double maxS = 0.0;
        private double maxE = 0.0;
        private double maxI = 0.0;
        private double maxR = 0.0;
        public Map<String, List<String>> instance;
        protected ReferenceScenarioDataMapImpl dataMap;

        public ReferenceScenarioDataMapImpl getDataMap() {
            return this.dataMap;
        }

        public ReferenceScenarioDataInstance(Map<String, List<String>> data, ReferenceScenarioDataMapImpl map) {
            this.instance = data;
            this.dataMap = map;
        }

        public ReferenceScenarioDataInstance(ReferenceScenarioDataMapImpl dataMap) {
            this.instance = new HashMap<String, List<String>>();
            this.dataMap = dataMap;
        }

        public ReferenceScenarioDataInstance clone() {
            this.getData();
            ReferenceScenarioDataInstance newInstance = new ReferenceScenarioDataInstance(this.dataMap);
            for (String key : this.instance.keySet()) {
                List<String> dataList = this.instance.get(key);
                ArrayList<String> newList = new ArrayList<String>();
                int i = 0;
                while (i < dataList.size()) {
                    String val = dataList.get(i);
                    newList.add(val);
                    ++i;
                }
                newInstance.instance.put(key, newList);
            }
            newInstance.getData();
            return newInstance;
        }

        public void integrateData(Map<String, List<String>> data) {
            for (Map.Entry<String, List<String>> entry : data.entrySet()) {
                String state = entry.getKey();
                List<String> valueList = entry.getValue();
                if (valueList.size() < 1) continue;
                List<Object> aggregatedList = new ArrayList();
                if (this.instance.containsKey(state)) {
                    aggregatedList = this.instance.get(state);
                } else {
                    int i = 0;
                    while (i < valueList.size()) {
                        aggregatedList.add("0.0");
                        ++i;
                    }
                    this.instance.put(state, aggregatedList);
                }
                String first = valueList.get(0);
                boolean isData = true;
                try {
                    new Double(first).doubleValue();
                }
                catch (NumberFormatException numberFormatException) {
                    isData = false;
                }
                int i = 0;
                while (i < valueList.size()) {
                    String value = valueList.get(i);
                    if (isData) {
                        double val = new Double(value);
                        double oldVal = new Double((String)aggregatedList.get(i));
                        oldVal = state.indexOf(ReferenceScenarioDataMapImpl.ITERATION_KEY) == -1 ? (oldVal += val) : val;
                        aggregatedList.set(i, "" + oldVal);
                        this.instance.put(state, aggregatedList);
                    } else {
                        aggregatedList.set(i, value);
                        this.instance.put(state, aggregatedList);
                    }
                    ++i;
                }
            }
        }

        public List<String> getData(String parm) {
            return this.instance.get(parm);
        }

        public boolean containsParameter(String p) {
            return this.instance.containsKey(p);
        }

        public Map<String, List<String>> getInstance() {
            return this.instance;
        }

        public void findMaxValues() {
            double val;
            int j;
            List<String> dataList;
            int i;
            String[] S_keys = this.dataMap.getS_Keys();
            String[] E_keys = this.dataMap.getE_Keys();
            String[] I_keys = this.dataMap.getI_Keys();
            String[] R_keys = this.dataMap.getR_Keys();
            if (this.dataMap.getS_Keys() != null) {
                i = 0;
                while (i < S_keys.length) {
                    dataList = this.getData(S_keys[i]);
                    if (dataList != null) {
                        this.maxS = new Double(dataList.get(0));
                        j = 0;
                        while (j < dataList.size()) {
                            val = new Double(dataList.get(j));
                            if (val > this.maxS) {
                                this.maxS = val;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (this.dataMap.getE_Keys() != null) {
                i = 0;
                while (i < E_keys.length) {
                    dataList = this.getData(E_keys[i]);
                    if (dataList != null) {
                        this.maxE = new Double(dataList.get(0));
                        j = 0;
                        while (j < dataList.size()) {
                            val = new Double(dataList.get(j));
                            if (val > this.maxE) {
                                this.maxE = val;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (this.dataMap.getI_Keys() != null) {
                i = 0;
                while (i < I_keys.length) {
                    dataList = this.getData(I_keys[i]);
                    if (dataList != null) {
                        this.maxI = new Double(dataList.get(0));
                        j = 0;
                        while (j < dataList.size()) {
                            val = new Double(dataList.get(j));
                            if (val > this.maxI) {
                                this.maxI = val;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (this.dataMap.getR_Keys() != null) {
                i = 0;
                while (i < R_keys.length) {
                    dataList = this.getData(R_keys[i]);
                    if (dataList != null) {
                        this.maxR = new Double(dataList.get(0));
                        j = 0;
                        while (j < dataList.size()) {
                            val = new Double(dataList.get(j));
                            if (val > this.maxR) {
                                this.maxR = val;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }

        public Map<String, List<Double>> getData() {
            HashMap<String, List<Double>> data = new HashMap<String, List<Double>>();
            for (String state : this.instance.keySet()) {
                ArrayList<Double> list = new ArrayList<Double>();
                if (state.equalsIgnoreCase(ReferenceScenarioDataMapImpl.TIME_KEY)) continue;
                for (String sd : this.instance.get(state)) {
                    list.add(Double.parseDouble(sd));
                }
                data.put(state, list);
            }
            return data;
        }

        public List<Double> getStotals() {
            String[] keys = this.getDataMap().getS_Keys();
            ArrayList<Double> data = new ArrayList<Double>();
            if (keys.length == 0) {
                return data;
            }
            List<String> strList = this.instance.get(keys[0]);
            if (strList != null) {
                int j = 0;
                while (j < strList.size()) {
                    data.add(j, (double)new Double(strList.get(j)));
                    ++j;
                }
            }
            if (keys.length >= 2) {
                int i = 1;
                while (i < keys.length) {
                    strList = this.instance.get(keys[i]);
                    int j = 0;
                    while (j < strList.size()) {
                        double val = new Double(strList.get(j));
                        data.set(j, new Double(val += ((Double)data.get(j)).doubleValue()));
                        ++j;
                    }
                    ++i;
                }
            }
            return data;
        }

        public List<Double> getEtotals() {
            String[] keys = this.getDataMap().getE_Keys();
            ArrayList<Double> data = new ArrayList<Double>();
            if (keys.length == 0) {
                return data;
            }
            List<String> strList = this.instance.get(keys[0]);
            if (strList != null) {
                int j = 0;
                while (j < strList.size()) {
                    data.add(j, (double)new Double(strList.get(j)));
                    ++j;
                }
            }
            if (keys.length >= 2) {
                int i = 1;
                while (i < keys.length) {
                    strList = this.instance.get(keys[i]);
                    int j = 0;
                    while (j < strList.size()) {
                        double val = new Double(strList.get(j));
                        data.set(j, new Double(val += ((Double)data.get(j)).doubleValue()));
                        ++j;
                    }
                    ++i;
                }
            }
            return data;
        }

        public List<Double> getItotals() {
            String[] keys = this.getDataMap().getI_Keys();
            ArrayList<Double> data = new ArrayList<Double>();
            if (keys.length == 0) {
                return data;
            }
            List<String> strList = this.instance.get(keys[0]);
            if (strList != null) {
                int j = 0;
                while (j < strList.size()) {
                    data.add(j, (double)new Double(strList.get(j)));
                    ++j;
                }
            }
            if (keys.length >= 2) {
                int i = 1;
                while (i < keys.length) {
                    strList = this.instance.get(keys[i]);
                    int j = 0;
                    while (j < strList.size()) {
                        double val = new Double(strList.get(j));
                        data.set(j, new Double(val += ((Double)data.get(j)).doubleValue()));
                        ++j;
                    }
                    ++i;
                }
            }
            return data;
        }

        public List<Double> getRtotals() {
            String[] keys = this.getDataMap().getR_Keys();
            ArrayList<Double> data = new ArrayList<Double>();
            if (keys.length == 0) {
                return data;
            }
            List<String> strList = this.instance.get(keys[0]);
            if (strList != null) {
                int j = 0;
                while (j < strList.size()) {
                    data.add(j, (double)new Double(strList.get(j)));
                    ++j;
                }
            }
            if (keys.length >= 2) {
                int i = 1;
                while (i < keys.length) {
                    strList = this.instance.get(keys[i]);
                    int j = 0;
                    while (j < strList.size()) {
                        double val = new Double(strList.get(j));
                        data.set(j, new Double(val += ((Double)data.get(j)).doubleValue()));
                        ++j;
                    }
                    ++i;
                }
            }
            return data;
        }

        public double getMaxS() {
            return this.maxS;
        }

        public double getMaxE() {
            return this.maxE;
        }

        public double getMaxI() {
            return this.maxI;
        }

        public double getMaxR() {
            return this.maxR;
        }

        public int getSize() {
            if (this.instance.size() == 0) {
                return 0;
            }
            return this.instance.values().iterator().next().size();
        }
    }
}

