/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.veterinary.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.veterinary.ContaminatedUnits;
import org.eclipse.stem.diseasemodels.veterinary.ContaminatedUnitsLabel;
import org.eclipse.stem.diseasemodels.veterinary.ContaminatedUnitsLabelValue;
import org.eclipse.stem.diseasemodels.veterinary.VeterinaryFactory;
import org.eclipse.stem.diseasemodels.veterinary.VeterinaryPackage;
import org.eclipse.stem.diseasemodels.veterinary.impl.ContaminatedUnitsExpressions;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelImpl;

public class ContaminatedUnitsImpl
extends PopulationModelImpl
implements ContaminatedUnits {
    protected static final double DISSAPATION_RATE_EDEFAULT = 0.0;
    protected double dissapationRate = 0.0;
    protected static final double SHEDDING_FACTOR_EDEFAULT = 0.0;
    protected double sheddingFactor = 0.0;

    protected EClass eStaticClass() {
        return VeterinaryPackage.Literals.CONTAMINATED_UNITS;
    }

    @Override
    public double getDissapationRate() {
        return this.dissapationRate;
    }

    @Override
    public void setDissapationRate(double newDissapationRate) {
        this.dissapationRate = newDissapationRate;
    }

    @Override
    public double getSheddingFactor() {
        return this.sheddingFactor;
    }

    @Override
    public void setSheddingFactor(double newSheddingFactor) {
        this.sheddingFactor = newSheddingFactor;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getDissapationRate();
            }
            case 17: {
                return this.getSheddingFactor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setDissapationRate((Double)newValue);
                return;
            }
            case 17: {
                this.setSheddingFactor((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setDissapationRate(0.0);
                return;
            }
            case 17: {
                this.setSheddingFactor(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.dissapationRate != 0.0;
            }
            case 17: {
                return this.sheddingFactor != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dissapationRate: ");
        result.append(this.dissapationRate);
        result.append(", sheddingFactor: ");
        result.append(this.sheddingFactor);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime currentTime, double continuousTime, long timeDelta, EList<DynamicLabel> labels) {
        super.applyExternalDeltas(currentTime, continuousTime, timeDelta, labels);
    }

    public void doStochasticProcess(IntegrationLabel label, long timeDelta) {
        super.doStochasticProcess(label, timeDelta);
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        ContaminatedUnitsExpressions deltaCalculator = new ContaminatedUnitsExpressions();
        int _i = 0;
        while (_i < labels.size()) {
            ContaminatedUnitsLabel diseaseLabel = (ContaminatedUnitsLabel)labels.get(_i);
            ContaminatedUnitsLabelValue currentDiseaseState = (ContaminatedUnitsLabelValue)diseaseLabel.getProbeValue();
            ContaminatedUnitsLabelValue deltaValue = (ContaminatedUnitsLabelValue)diseaseLabel.getDeltaValue();
            deltaValue.reset();
            deltaCalculator.calculate(t, timeDelta, time, this, diseaseLabel, currentDiseaseState, diseaseLabel.getNode(), deltaValue);
            deltaValue.scale((double)timeDelta / (double)this.getTimePeriod());
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)diseaseLabel, time, t, timeDelta);
            ++_i;
        }
    }

    public PopulationModelLabel createPopulationModelLabel(String populationIdentifier) {
        ContaminatedUnitsLabel label = VeterinaryFactory.eINSTANCE.createContaminatedUnitsLabel();
        label.setTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        return label;
    }

    public PopulationModelLabelValue createPopulationModelLabelValue(String populationIdentifier) {
        return VeterinaryFactory.eINSTANCE.createContaminatedUnitsLabelValue();
    }
}

