/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;
import org.eclipse.stem.diseasemodels.standard.impl.StandardInfectorImpl;

public class SIInfectorImpl
extends StandardInfectorImpl
implements SIInfector {
    protected static final double INFECTIOUS_COUNT_EDEFAULT = 1.0;
    protected double infectiousCount = 1.0;

    protected SIInfectorImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SI_INFECTOR;
    }

    @Override
    public double getInfectiousCount() {
        return this.infectiousCount;
    }

    @Override
    public void setInfectiousCount(double newInfectiousCount) {
        this.infectiousCount = newInfectiousCount;
    }

    @Override
    protected void doInitialization(DiseaseModelLabel diseaseModelLabel) throws ScenarioInitializationException {
        DiseaseModelLabel siLabel = diseaseModelLabel;
        StandardDiseaseModelLabelValue value = (StandardDiseaseModelLabelValue)siLabel.getCurrentValue();
        EStructuralFeature infFeature = this.findFeature(this.getTargetFeature(), (LabelValue)value);
        if (infFeature == null) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.UNABLE_TO_INFECT_STATE, (Object[])new Object[]{this.getTargetFeature(), siLabel}), (Identifiable)this, new Exception());
        }
        double newSValue = 0.0;
        double currentPop = value.getPopulationCount();
        double additionalInfectious = 0.0;
        additionalInfectious = this.isInfectPercentage() ? currentPop * (this.getInfectiousCount() / 100.0) : this.getInfectiousCount();
        if (additionalInfectious > value.getS()) {
            additionalInfectious = value.getS();
        }
        newSValue = value.getS() - additionalInfectious;
        double currentInf = value.eGetDouble(infFeature.getFeatureID());
        double newIValue = currentInf + additionalInfectious;
        newSValue = newSValue < 0.0 ? 0.0 : newSValue;
        ((StandardDiseaseModelLabelValue)siLabel.getCurrentValue()).setS(newSValue);
        ((StandardDiseaseModelLabelValue)siLabel.getNextValue()).setS(newSValue);
        ((StandardDiseaseModelLabelValue)siLabel.getProbeValue()).setS(newSValue);
        ((StandardDiseaseModelLabelValue)siLabel.getCurrentValue()).eSetDouble(infFeature.getFeatureID(), newIValue);
        ((StandardDiseaseModelLabelValue)siLabel.getNextValue()).eSetDouble(infFeature.getFeatureID(), newIValue);
        ((StandardDiseaseModelLabelValue)siLabel.getProbeValue()).eSetDouble(infFeature.getFeatureID(), newIValue);
    }

    protected EStructuralFeature findFeature(String name, LabelValue lv) {
        for (EAttribute ea : lv.eClass().getEAllAttributes()) {
            if (!ea.getName().equals(name)) continue;
            return ea;
        }
        return null;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getInfectiousCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setInfectiousCount((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setInfectiousCount(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.infectiousCount != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (infectiousCount: ");
        result.append(this.infectiousCount);
        result.append(')');
        return result.toString();
    }
}

