/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;
import org.eclipse.stem.geography.names.GeographicNames;
import org.eclipse.stem.jobs.execution.IExecutable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.IdentifiableDelegate;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public abstract class IdentifiablePluginView
extends ViewPart {
    protected TreeViewer treeViewer;
    private DublinCoreToolTipHandler dcTTipHandler;
    protected ISelection selection;
    protected Map<URI, Identifiable> deserializedIdentifiablesMap = new HashMap<URI, Identifiable>();

    public void createPartControl(Composite parent) {
        this.dcTTipHandler = new DublinCoreToolTipHandler(parent.getShell());
        this.treeViewer = new TreeViewer(parent);
        this.treeViewer.setContentProvider((IContentProvider)new IdentifiablePluginViewTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getIdentifiablePluginViewLabelContentProvider());
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput((Object)this.getInput());
        this.dcTTipHandler.addDCToolTipHelp((Control)this.treeViewer.getTree());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IContributionItem)new Separator("execution"));
        this.treeViewer.getControl().setMenu(contextMenuManager.createContextMenu(this.treeViewer.getControl()));
        this.getSite().registerContextMenu(contextMenuManager, (ISelectionProvider)this.treeViewer);
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IExecutable executable = (IExecutable)Platform.getAdapterManager().getAdapter(((StructuredSelection)event.getSelection()).toList().get(0), IExecutable.class);
                if (executable != null) {
                    Adapter a;
                    Notifier obj;
                    executable.run();
                    if (executable instanceof Adapter && (obj = (a = (Adapter)executable).getTarget()) instanceof ScenarioImpl) {
                        Activator.switchToPerspective("org.eclipse.stem.ui.STEMSimulationPerspective");
                    }
                }
            }
        });
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), LocalTransfer.getInstance()};
        this.treeViewer.addDragSupport(7, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                event.doit = true;
                IdentifiablePluginView.this.selection = IdentifiablePluginView.this.treeViewer.getSelection();
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    event.data = this.extractURIStringsFromIdentifiableDelegates((IStructuredSelection)IdentifiablePluginView.this.selection);
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)((IStructuredSelection)event.data));
                } else if (LocalTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.extractURIStringsFromIdentifiableDelegates((IStructuredSelection)IdentifiablePluginView.this.selection);
                }
            }

            private IStructuredSelection extractURIStringsFromIdentifiableDelegates(IStructuredSelection selectedDelegates) {
                ArrayList<String> collection = new ArrayList<String>();
                for (Object element : selectedDelegates) {
                    String uriString;
                    if (!(element instanceof IdentifiableDelegate) || (uriString = ((IdentifiableDelegate)element).getDublinCore().getIdentifier()) == null) continue;
                    collection.add(uriString);
                }
                return new IStructuredSelection(collection){
                    final List<String> list;
                    {
                        this.list = list;
                    }

                    public Object getFirstElement() {
                        return this.list.get(0);
                    }

                    public Iterator<String> iterator() {
                        return this.list.iterator();
                    }

                    public int size() {
                        return this.list.size();
                    }

                    public Object[] toArray() {
                        return this.list.toArray();
                    }

                    public List<String> toList() {
                        return this.list;
                    }

                    public boolean isEmpty() {
                        return this.list.isEmpty();
                    }
                };
            }

            public void dragFinished(DragSourceEvent event) {
                IdentifiablePluginView.this.selection = null;
                LocalTransfer.getInstance().javaToNative(null, null);
            }
        });
    }

    public void setFocus() {
    }

    protected abstract IdentifiableViewModel getInput();

    protected abstract IdentifiablePluginViewLabelContentProvider getIdentifiablePluginViewLabelContentProvider();

    protected static class Category
    implements Comparable<Object> {
        Category parent;
        String parentId;
        String categoryId;
        String categoryName;
        List<Category> childCategories;
        List<IdentifiableDelegate> childIdentifiables;

        protected Category(String categoryName, String categoryId, String parentId) {
            this.categoryName = categoryName;
            this.categoryId = categoryId;
            this.parentId = parentId;
            this.parent = null;
            this.childCategories = new ArrayList<Category>();
            this.childIdentifiables = new ArrayList<IdentifiableDelegate>();
        }

        protected Category(IConfigurationElement element) {
            this(Category.getNLSCatagoryName(element.getAttribute("name")), element.getAttribute("id"), element.getAttribute("parent_id"));
        }

        public void addChildCategory(Category category) {
            this.childCategories.add(category);
        }

        public void addIdentifiableDelegate(IdentifiableDelegate identifiableDelegate) {
            this.childIdentifiables.add(identifiableDelegate);
        }

        private static String getNLSCatagoryName(String attribute) {
            String name = GeographicNames.getName((String)attribute);
            return name.startsWith("!") ? attribute : name;
        }

        protected final String getCategoryId() {
            return this.categoryId;
        }

        protected final String getParentId() {
            return this.parentId;
        }

        protected final Category getParent() {
            return this.parent;
        }

        protected final void setParent(Category parent) {
            this.parent = parent;
        }

        public Object[] getChildren() {
            ArrayList<Comparable<Object>> kidList = new ArrayList<Comparable<Object>>();
            Collections.sort(this.childCategories);
            Collections.sort(this.childIdentifiables);
            kidList.addAll(this.childCategories);
            kidList.addAll(this.childIdentifiables);
            return kidList.toArray();
        }

        public String toString() {
            StringBuilder retValue = new StringBuilder(this.categoryName);
            retValue.append(", ");
            retValue.append(this.categoryId);
            retValue.append(", ");
            retValue.append(this.parentId);
            return retValue.toString();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.categoryId == null ? 0 : this.categoryId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Category other = (Category)obj;
            return !(this.categoryId == null ? other.categoryId != null : !this.categoryId.equals(other.categoryId));
        }

        @Override
        public int compareTo(Object o) {
            int retValue = 0;
            if (o instanceof Category) {
                Category category = (Category)o;
                retValue = this.categoryName.compareTo(category.categoryName);
            } else if (o instanceof IdentifiableDelegate) {
                retValue = 1;
            }
            return retValue;
        }
    }

    private static class DublinCoreToolTipHandler {
        protected static final int Y_OFFSET = 16;
        protected Shell dcTipShell;
        Label dcDescriptionText;
        Label dcCreatorText;
        Label dcValidText;
        Label dcSourceText;

        DublinCoreToolTipHandler(Shell parent) {
            Display display = parent.getDisplay();
            this.dcTipShell = new Shell(parent, 16388);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            this.dcTipShell.setLayout((Layout)gridLayout);
            Color backgroundColor = display.getSystemColor(29);
            Color foregroundColor = display.getSystemColor(28);
            this.dcTipShell.setBackground(backgroundColor);
            this.dcDescriptionText = this.createDCAttributeLabel(this.dcTipShell, backgroundColor, foregroundColor);
            this.dcCreatorText = this.createDCAttributeLabel(this.dcTipShell, backgroundColor, foregroundColor);
            this.dcValidText = this.createDCAttributeLabel(this.dcTipShell, backgroundColor, foregroundColor);
            this.dcSourceText = this.createDCAttributeLabel(this.dcTipShell, backgroundColor, foregroundColor);
            this.dcTipShell.pack();
        }

        private Label createDCAttributeLabel(Shell parent, Color backgroundColor, Color foregroundColor) {
            Label retValue = new Label((Composite)parent, 0);
            retValue.setBackground(backgroundColor);
            retValue.setForeground(foregroundColor);
            retValue.setLayoutData((Object)new GridData(772));
            return retValue;
        }

        public void addDCToolTipHelp(final Control control) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (DublinCoreToolTipHandler.this.dcTipShell.isVisible()) {
                        DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                    }
                }
            });
            control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                    Point pt = new Point(e.x, e.y);
                    if (e.widget instanceof Tree) {
                        Tree tree = (Tree)e.widget;
                        TreeItem treeItem = tree.getItem(pt);
                        if (treeItem != null) {
                            Object obj = treeItem.getData();
                            if (obj instanceof IdentifiableDelegate) {
                                IdentifiableDelegate id = (IdentifiableDelegate)obj;
                                DublinCoreImpl dc = id.getDublinCore();
                                String description = dc.getDescription();
                                String creator = dc.getCreator();
                                String valid = dc.getValid();
                                String source = dc.getSource();
                                if (description != null && !description.equals("")) {
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setText(description);
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcDescriptionText.setVisible(false);
                                }
                                if (creator != null && !creator.equals("")) {
                                    DublinCoreToolTipHandler.this.dcCreatorText.setText(creator);
                                    DublinCoreToolTipHandler.this.dcCreatorText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcCreatorText.setVisible(false);
                                }
                                if (valid != null && !valid.equals("")) {
                                    DublinCoreToolTipHandler.this.dcValidText.setText(valid);
                                    DublinCoreToolTipHandler.this.dcValidText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcValidText.setVisible(false);
                                }
                                if (source != null && !source.equals("")) {
                                    DublinCoreToolTipHandler.this.dcSourceText.setText(source);
                                    DublinCoreToolTipHandler.this.dcSourceText.setVisible(true);
                                } else {
                                    DublinCoreToolTipHandler.this.dcSourceText.setVisible(false);
                                }
                                DublinCoreToolTipHandler.this.dcTipShell.pack();
                                DublinCoreToolTipHandler.this.dcTipShell.setBounds(this.computeHoverLocation(DublinCoreToolTipHandler.this.dcTipShell, control.toDisplay(pt)));
                                DublinCoreToolTipHandler.this.dcTipShell.setVisible(true);
                            } else {
                                DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                            }
                        } else {
                            DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                        }
                    }
                }

                private Rectangle computeHoverLocation(Shell dcTipShell, Point mousePosition) {
                    Rectangle retValue = dcTipShell.getBounds();
                    Rectangle displayBounds = dcTipShell.getDisplay().getBounds();
                    retValue.x = Math.max(Math.min(mousePosition.x, displayBounds.width - retValue.width), 0);
                    retValue.y = Math.max(Math.min(mousePosition.y + 16, displayBounds.height - retValue.height), 0);
                    return retValue;
                }

                public void mouseExit(MouseEvent e) {
                    if (DublinCoreToolTipHandler.this.dcTipShell.isVisible()) {
                        DublinCoreToolTipHandler.this.dcTipShell.setVisible(false);
                    }
                }
            });
        }
    }

    protected static abstract class IdentifiablePluginViewLabelContentProvider
    implements ILabelProvider {
        private static Image categoryIcon = null;
        static boolean categoryIconFirstTime = true;
        private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

        public Image getImage(Object element) {
            Image retValue = null;
            if (element instanceof Category) {
                retValue = this.getCategoryIcon();
            }
            return retValue;
        }

        protected Image getCategoryIcon() {
            if (categoryIconFirstTime && categoryIcon == null) {
                categoryIconFirstTime = false;
                categoryIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return categoryIcon;
        }

        public String getText(Object element) {
            String retValue = "";
            if (element instanceof Category) {
                Category category = (Category)element;
                retValue = category.categoryName;
            } else if (element instanceof IdentifiableDelegate) {
                IdentifiableDelegate identifiableDelegate = (IdentifiableDelegate)element;
                retValue = identifiableDelegate.toString();
            }
            return retValue;
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add(listener);
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove(listener);
        }
    }

    protected static class IdentifiablePluginViewTreeContentProvider
    implements ITreeContentProvider {
        protected IdentifiablePluginViewTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] retValue = null;
            if (parentElement instanceof Category) {
                Category category = (Category)parentElement;
                ArrayList<Comparable<Object>> kidList = new ArrayList<Comparable<Object>>();
                Collections.sort(category.childCategories);
                Collections.sort(category.childIdentifiables);
                kidList.addAll(category.childCategories);
                kidList.addAll(category.childIdentifiables);
                retValue = kidList.toArray();
            }
            return retValue;
        }

        public Object getParent(Object element) {
            Object retValue = null;
            retValue = element instanceof Category ? ((Category)element).parent : ((IdentifiableDelegate)element).getParent();
            return retValue;
        }

        public boolean hasChildren(Object element) {
            boolean retValue = false;
            if (element instanceof Category) {
                Category cagatory = (Category)element;
                retValue = cagatory.childCategories.size() > 0 || cagatory.childIdentifiables.size() > 0;
            }
            return retValue;
        }

        public Object[] getElements(Object inputElement) {
            IdentifiableViewModel model = (IdentifiableViewModel)inputElement;
            Arrays.sort(model.getRoot().getChildren());
            return model.getRoot().getChildren();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static abstract class IdentifiableViewModel {
        private final Category root = new Category("/", "/", "");
        private final Map<String, Category> categoryMap = new HashMap<String, Category>();

        public IdentifiableViewModel(String extensionPointID) {
            IConfigurationElement element;
            IConfigurationElement[] configElements;
            this.categoryMap.put(this.root.getCategoryId(), this.root);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = configElements = registry.getConfigurationElementsFor(extensionPointID);
            int n = configElements.length;
            int n2 = 0;
            while (n2 < n) {
                element = iConfigurationElementArray[n2];
                if ("stem_category".equals(element.getName()) && !element.getAttribute("name").startsWith("%")) {
                    this.addCategory(element);
                }
                ++n2;
            }
            this.resolveCategories();
            iConfigurationElementArray = configElements;
            n = configElements.length;
            n2 = 0;
            while (n2 < n) {
                element = iConfigurationElementArray[n2];
                if (!"stem_category".equals(element.getName())) {
                    if ("dublin_core".equals(element.getName())) {
                        Category category = this.root;
                        String categoryId = element.getAttribute("category_id");
                        if (categoryId != null) {
                            category = this.categoryMap.get(categoryId);
                            if (category == null) {
                                Activator.logError(MessageFormat.format(Messages.getString("IPView.No_Category"), categoryId), null);
                                category = this.root;
                            }
                            category = category == null ? this.root : category;
                        }
                        this.addIdentifiableDelegate(category, element);
                    } else if (element.getAttribute("name") != null) {
                        this.addIdentifiableDelegate(this.root, element);
                    } else {
                        Activator.logError(MessageFormat.format(Messages.getString("IPView.Unexpected_Element"), element.getName(), extensionPointID), null);
                    }
                }
                ++n2;
            }
        }

        private void addIdentifiableDelegate(Category category, IConfigurationElement element) {
            IdentifiableDelegate identifiableDelegate = new IdentifiableDelegate(element);
            category.addIdentifiableDelegate(identifiableDelegate);
        }

        private Category addCategory(IConfigurationElement element) {
            Category category = new Category(element);
            Category retValue = this.categoryMap.get(category.getCategoryId());
            if (retValue == null) {
                retValue = category;
                this.categoryMap.put(category.getCategoryId(), category);
            }
            return retValue;
        }

        private void resolveCategories() {
            for (Category category : this.categoryMap.values()) {
                if (category == this.root) continue;
                Category parentCategory = this.categoryMap.get(category.getParentId());
                if (parentCategory == null) {
                    Activator.logInformation("When organizing categories, the specified parent category \"" + category.getParentId() + "\" for the category \"" + category.getCategoryId() + "\" could not be found.  Using \"/\" instead.", null);
                    parentCategory = this.root;
                }
                category.setParent(parentCategory);
                parentCategory.addChildCategory(category);
            }
        }

        protected final Category getRoot() {
            return this.root;
        }
    }
}

