/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import org.eclipse.core.resources.IProject;
import org.eclipse.stem.ui.views.explorer.Messages;

public abstract class IdentifiableTreeNode {
    private final String componentName;
    private final String folderName;
    private final IProject project;
    private final String imageKey;

    public IdentifiableTreeNode(IProject project, String componentName, String folderName, String imageKey) {
        this.project = project;
        this.componentName = componentName;
        this.folderName = folderName;
        this.imageKey = imageKey;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getImageKey() {
        return this.imageKey;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.componentName);
        return sb.toString();
    }

    public int hashCode() {
        return this.folderName.hashCode() ^ this.project.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof IdentifiableTreeNode)) {
            return false;
        }
        return ((IdentifiableTreeNode)o).getFolderName().equals(this.folderName) && ((IdentifiableTreeNode)o).getProject().getName().equals(this.getProject().getName());
    }

    public static class DecoratorsTreeNode
    extends IdentifiableTreeNode {
        public DecoratorsTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.DECORATOR_FOLDER"), "decorators", "decorator_model_file.image");
        }
    }

    public static class ExperimentsTreeNode
    extends IdentifiableTreeNode {
        public ExperimentsTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.EXPERIMENT_FOLDER"), "experiments", "experiment_model_file.image");
        }
    }

    public static class GraphsTreeNode
    extends IdentifiableTreeNode {
        public GraphsTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.GRAPH_FOLDER"), "graphs", "graph_model_file.image");
        }
    }

    public static class LoggersTreeNode
    extends IdentifiableTreeNode {
        public LoggersTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.LOGGER_FOLDER"), "loggers", "logger_model_file.image");
        }
    }

    public static class ModelsTreeNode
    extends IdentifiableTreeNode {
        public ModelsTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.MODEL_FOLDER"), "models", "model_model_file.image");
        }
    }

    public static class ModifiersTreeNode
    extends IdentifiableTreeNode {
        public ModifiersTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.MODIFIER_FOLDER"), "modifiers", "modifier_model_file.image");
        }
    }

    public static class PredicatesTreeNode
    extends IdentifiableTreeNode {
        public PredicatesTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.PREDICATE_FOLDER"), "predicates", "predicate_model_file.image");
        }
    }

    public static class ScenariosTreeNode
    extends IdentifiableTreeNode {
        public ScenariosTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.SCENARIO_FOLDER"), "scenarios", "scenario_model_file.image");
        }
    }

    public static class SequencersTreeNode
    extends IdentifiableTreeNode {
        public SequencersTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.SEQUENCER_FOLDER"), "sequencers", "sequencer_model_file.image");
        }
    }

    public static class SolversTreeNode
    extends IdentifiableTreeNode {
        public SolversTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.SOLVERS_FOLDER"), "solvers", "solvers_model_file.image");
        }
    }

    public static class TriggersTreeNode
    extends IdentifiableTreeNode {
        public TriggersTreeNode(IProject project) {
            super(project, Messages.getString("EXPLORER.TRIGGER_FOLDER"), "triggers", "trigger_model_file.image");
        }
    }
}

