/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.adapters.color.ColorProvider;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderAdapterFactory;
import org.eclipse.stem.ui.views.graphmap.GraphMapPreferences;
import org.eclipse.stem.ui.views.graphmap.GraphMapRegistry;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.stem.ui.views.graphmap.Messages;
import org.eclipse.stem.ui.widgets.ColorProviderPropertiesComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class GeoViewOptionsBar
extends Composite
implements SelectionListener {
    private List<PropertySelectionListener> selectionListeners = new CopyOnWriteArrayList<PropertySelectionListener>();
    private Combo decoratorsCombo;
    private Combo populationsCombo;
    private Combo colorProvidersCombo;
    private Combo edgesCombo;
    private Composite colorProviderComposite;
    private Composite colorsLegendComposite;
    private Group geoViewOptionsGroup;
    private Group edgesGroup;
    private List<Decorator> decorators;
    private List<String> populationIdentifiers;
    private List<Class<? extends ColorProvider>> supportedColorProviders = null;
    private List<String> supportedColorProvidersNames = null;
    private Map<String, String> edgeTypeToUriPrefixMap = new HashMap<String, String>();
    private Class<? extends ColorProvider> selectedColorProvider = null;
    private Decorator selectedDecorator;
    private String selectedPopulationIdentifier;
    private ItemPropertyDescriptor selectedProperty;
    private String edgePrefix;
    private GraphMapView view;
    private ISimulation sim;

    public GeoViewOptionsBar(Composite parent, int style, GraphMapView view) {
        super(parent, style);
        this.view = view;
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.fill = true;
        this.setLayout((Layout)rowLayout);
        this.geoViewOptionsGroup = new Group((Composite)this, 0);
        this.geoViewOptionsGroup.setLayout((Layout)new GridLayout());
        this.geoViewOptionsGroup.setText(Messages.getString("IMView.MProp"));
        this.geoViewOptionsGroup.setVisible(false);
        this.decoratorsCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.decoratorsCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.populationsCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.populationsCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.colorProvidersCombo = new Combo((Composite)this.geoViewOptionsGroup, 0x100000C);
        this.colorProvidersCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.supportedColorProviders = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProviders();
        this.supportedColorProvidersNames = ColorProviderAdapterFactory.INSTANCE.getSupportedColorProvidersNames();
        this.decoratorsCombo.addSelectionListener((SelectionListener)this);
        this.populationsCombo.addSelectionListener((SelectionListener)this);
        this.colorProvidersCombo.addSelectionListener((SelectionListener)this);
        this.edgesGroup = new Group((Composite)this, 0);
        this.edgesCombo = new Combo((Composite)this.edgesGroup, 0x100000C);
        this.edgesCombo.add("");
        this.edgesCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.edgesGroup.setLayout((Layout)new GridLayout());
        this.edgesGroup.setVisible(false);
        this.edgesGroup.setText(Messages.getString("IMView.Edges"));
        this.edgesCombo.addSelectionListener((SelectionListener)this);
        this.pack();
        this.setSimulation(null);
    }

    public boolean isInitialized() {
        return this.decorators != null && !this.decorators.isEmpty();
    }

    public void setSimulation(ISimulation simulation) {
        this.sim = simulation;
        if (simulation == null) {
            return;
        }
        GraphMapPreferences prefs = GraphMapPreferences.getInstance();
        int viewId = GraphMapRegistry.getInstance().getViewId(this.view);
        IDialogSettings settings = prefs.getPreferencesFor(viewId, simulation.getScenario());
        this.setDecorators(this.getDecoratorsToDisplay(simulation), settings);
        if (this.decorators == null) {
            return;
        }
        this.setColorProviders(settings);
        this.geoViewOptionsGroup.setVisible(true);
        this.setEdges();
        if (settings != null && settings.get("org.eclipse.stem.ui.views.graphmap.geoview.edge") != null) {
            this.edgePrefix = settings.get("org.eclipse.stem.ui.views.graphmap.geoview.edge");
            if (this.edgePrefix.isEmpty()) {
                this.edgePrefix = null;
            }
            int edgSelect = 0;
            String[] edgeTypes = this.edgesCombo.getItems();
            int i = 0;
            while (i < edgeTypes.length) {
                if (this.edgePrefix == null && edgeTypes[i].isEmpty() || this.edgePrefix.equals(this.edgeTypeToUriPrefixMap.get(edgeTypes[i]))) {
                    edgSelect = i;
                    break;
                }
                ++i;
            }
            this.edgesCombo.select(edgSelect);
        }
        this.edgesGroup.setVisible(true);
        this.getInformation(simulation);
    }

    public void addPropertySelectionListener(PropertySelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removePropertySelectionListener(PropertySelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public Class<? extends ColorProvider> getSelectedColorProvider() {
        return this.selectedColorProvider;
    }

    public Decorator getSelectedDecorator() {
        return this.selectedDecorator;
    }

    public String getSelectedPopulationIdentifier() {
        return this.selectedPopulationIdentifier;
    }

    public ItemPropertyDescriptor getSelectedProperty() {
        return this.selectedProperty;
    }

    public String getSelectedEdge() {
        return this.edgePrefix;
    }

    public void widgetSelected(SelectionEvent e) {
        GraphMapPreferences prefs = GraphMapPreferences.getInstance();
        int viewId = GraphMapRegistry.getInstance().getViewId(this.view);
        if (e.getSource() == this.decoratorsCombo) {
            Decorator tempDecorator;
            if (!this.decorators.isEmpty() && this.selectedDecorator != (tempDecorator = this.decorators.get(this.decoratorsCombo.getSelectionIndex()))) {
                this.selectedDecorator = tempDecorator;
                List<String> popIds = this.getPopulationIdentifiers(this.selectedDecorator);
                this.populationIdentifiers = popIds;
                if (this.populationIdentifiers != null) {
                    this.selectedPopulationIdentifier = this.populationIdentifiers.get(0);
                }
                this.initializeCombo(this.populationsCombo, this.getPopulationIdNames(popIds), this.getPopulationIdIndex(this.selectedPopulationIdentifier, this.populationIdentifiers));
                IDialogSettings settings = null;
                if (this.sim != null && SimulationManager.getManager().getActiveSimulations().contains(this.sim)) {
                    prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.decorator", tempDecorator.getURI());
                    prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.populationidentifier", this.selectedPopulationIdentifier);
                    settings = prefs.getPreferencesFor(viewId, this.sim.getScenario());
                }
                this.updateColorProviderComposites(settings);
                this.firePropertySelectionEvent();
            }
        } else if (e.getSource() == this.populationsCombo) {
            String tempPopId;
            if (!this.populationIdentifiers.isEmpty() && !this.selectedPopulationIdentifier.equals(tempPopId = this.populationIdentifiers.get(this.populationsCombo.getSelectionIndex()))) {
                this.selectedPopulationIdentifier = tempPopId;
                IDialogSettings settings = null;
                if (this.sim != null && SimulationManager.getManager().getActiveSimulations().contains(this.sim)) {
                    prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.populationidentifier", this.selectedPopulationIdentifier);
                    settings = prefs.getPreferencesFor(viewId, this.sim.getScenario());
                }
                this.updateColorProviderComposites(settings);
                this.firePropertySelectionEvent();
            }
        } else if (e.getSource() == this.colorProvidersCombo) {
            this.selectedColorProvider = this.supportedColorProviders.get(this.colorProvidersCombo.getSelectionIndex());
            IDialogSettings settings = null;
            if (this.sim != null && SimulationManager.getManager().getActiveSimulations().contains(this.sim)) {
                prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.colorprovider", this.selectedColorProvider.getSimpleName());
            }
            this.updateColorProviderComposites(settings);
            this.firePropertySelectionEvent();
        } else if (e.getSource() == this.edgesCombo) {
            String selectedEdges = this.edgesCombo.getText();
            if (selectedEdges == null || selectedEdges.equals("")) {
                this.edgePrefix = null;
                prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.edge", "");
                this.firePropertySelectionEvent();
            } else {
                this.edgePrefix = this.edgeTypeToUriPrefixMap.get(selectedEdges);
                prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.edge", this.edgePrefix);
                if (this.sim != null) {
                    this.updateColorProviderComposites(prefs.getPreferencesFor(viewId, this.sim.getScenario()));
                }
                this.firePropertySelectionEvent();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void setDecorators(List<Decorator> decorators, IDialogSettings settings) {
        this.decorators = decorators;
        Decorator decorator = this.selectedDecorator = decorators.isEmpty() ? null : decorators.get(0);
        if (decorators.size() >= 2 && !(this.selectedDecorator instanceof DiseaseModel)) {
            int i = 0;
            while (i < decorators.size()) {
                if (decorators.get(i) instanceof DiseaseModel) {
                    this.selectedDecorator = decorators.get(i);
                    break;
                }
                ++i;
            }
        }
        if (settings != null && settings.get("org.eclipse.stem.ui.views.graphmap.geoview.decorator") != null) {
            String dec = settings.get("org.eclipse.stem.ui.views.graphmap.geoview.decorator");
            int i = 0;
            while (i < decorators.size()) {
                if (dec.equals(decorators.get(i).getURI().toString())) {
                    this.selectedDecorator = decorators.get(i);
                    break;
                }
                ++i;
            }
        }
        List<String> popIds = this.getPopulationIdentifiers(this.selectedDecorator);
        this.populationIdentifiers = popIds;
        if (this.populationIdentifiers != null) {
            this.selectedPopulationIdentifier = this.populationIdentifiers.get(0);
        }
        if (settings != null && settings.get("org.eclipse.stem.ui.views.graphmap.geoview.populationidentifier") != null) {
            this.selectedPopulationIdentifier = settings.get("org.eclipse.stem.ui.views.graphmap.geoview.populationidentifier");
        }
        this.initializeCombo(this.decoratorsCombo, this.getDecoratorNames(decorators), this.getDecoratorIndex(this.selectedDecorator, decorators));
        this.initializeCombo(this.populationsCombo, this.getPopulationIdNames(popIds), this.getPopulationIdIndex(this.selectedPopulationIdentifier, this.populationIdentifiers));
    }

    private void setColorProviders(IDialogSettings settings) {
        if (this.supportedColorProviders.isEmpty()) {
            return;
        }
        int selProvider = 0;
        int i = 0;
        while (i < this.supportedColorProvidersNames.size()) {
            String providerName = this.supportedColorProvidersNames.get(i);
            Class<? extends ColorProvider> provider = this.supportedColorProviders.get(i);
            if (settings != null && provider.getSimpleName().equals(settings.get("org.eclipse.stem.ui.views.graphmap.geoview.colorprovider"))) {
                selProvider = i;
            }
            this.colorProvidersCombo.add(providerName);
            ++i;
        }
        this.colorProvidersCombo.select(selProvider);
        this.selectedColorProvider = this.supportedColorProviders.get(selProvider);
        this.updateColorProviderComposites(settings);
    }

    private List<String> getPopulationIdentifiers(Decorator decorator) {
        if (decorator instanceof DiseaseModel) {
            return ((DiseaseModel)decorator).getAllLabelIdentifiers();
        }
        if (decorator instanceof PopulationModel) {
            return ((PopulationModel)decorator).getAllLabelIdentifiers();
        }
        return null;
    }

    private void setEdges() {
        if (this.selectedDecorator == null) {
            return;
        }
        Set edgesURIs = this.selectedDecorator.getGraph().getEdges().keySet();
        for (URI nextUri : edgesURIs) {
            String edgePrefix = nextUri.trimSegments(1).toString();
            String edgeType = org.eclipse.stem.ui.preferences.Messages.getString(edgePrefix);
            if (edgeType.startsWith("!") && edgeType.endsWith("!")) {
                edgePrefix = nextUri.trimSegments(2).toString();
                edgeType = org.eclipse.stem.ui.preferences.Messages.getString(edgePrefix);
            }
            if (this.edgeTypeToUriPrefixMap.containsKey(edgeType)) continue;
            this.edgeTypeToUriPrefixMap.put(edgeType, edgePrefix);
            this.edgesCombo.add(edgeType);
            if (!edgePrefix.equals("stem://org.eclipse.stem/edge/migration")) continue;
            String triggeredType = String.valueOf(edgeType) + " (" + Messages.getString("IMView.Triggered") + ")";
            String triggeredHistoryType = String.valueOf(edgeType) + " (" + Messages.getString("IMView.History") + ")";
            this.edgeTypeToUriPrefixMap.put(triggeredType, "triggered" + edgePrefix);
            this.edgesCombo.add(triggeredType);
            this.edgeTypeToUriPrefixMap.put(triggeredHistoryType, "history" + edgePrefix);
            this.edgesCombo.add(triggeredHistoryType);
        }
    }

    private void updateColorProviderComposites(IDialogSettings settings) {
        AdapterFactory adapterFactory;
        if (this.colorProviderComposite != null) {
            this.colorProviderComposite.dispose();
        }
        if (this.colorsLegendComposite != null) {
            this.colorsLegendComposite.dispose();
        }
        if ((adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(this.selectedColorProvider)) instanceof IColorProviderAdapterFactory) {
            IColorProviderAdapterFactory selectedColorProviderAdapterFactory = (IColorProviderAdapterFactory)adapterFactory;
            this.colorProviderComposite = selectedColorProviderAdapterFactory.createPropertiesComposite((Composite)this.geoViewOptionsGroup, 0, this.selectedDecorator, this.selectedPopulationIdentifier);
            if (this.colorProviderComposite == null) {
                return;
            }
            if (this.colorProviderComposite instanceof ColorProviderPropertiesComposite) {
                final ColorProviderPropertiesComposite pComp = (ColorProviderPropertiesComposite)this.colorProviderComposite;
                pComp.addPropertySelectionListener(new ColorProviderPropertiesComposite.PropertySelectionListener(){

                    @Override
                    public void propertySelected(ColorProviderPropertiesComposite.PropertySelectionEvent propertySelectionEvent) {
                        GeoViewOptionsBar.this.selectedProperty = propertySelectionEvent.getProperty();
                        GeoViewOptionsBar.this.firePropertySelectionEvent();
                    }
                });
                if (settings != null && settings.get("org.eclipse.stem.ui.views.graphmap.geoview.colorproviderproperty") != null) {
                    pComp.setInitialPropertyName(settings.get("org.eclipse.stem.ui.views.graphmap.geoview.colorproviderproperty"));
                    pComp.initialize(this.selectedDecorator, this.selectedPopulationIdentifier);
                } else if (pComp.getSelectedProperty() != null) {
                    GraphMapPreferences prefs = GraphMapPreferences.getInstance();
                    int viewId = GraphMapRegistry.getInstance().getViewId(this.view);
                    prefs.updatePreferenceState(viewId, this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.colorproviderproperty", pComp.getSelectedProperty().getDisplayName(null));
                }
                pComp.addPropertySelectionListener(new ColorProviderPropertiesComposite.PropertySelectionListener(){

                    @Override
                    public void propertySelected(ColorProviderPropertiesComposite.PropertySelectionEvent propertySelectionEvent) {
                        ISimulation sim = GeoViewOptionsBar.this.sim;
                        if (sim != null && SimulationManager.getManager().getActiveSimulations().contains(sim)) {
                            GraphMapPreferences prefs = GraphMapPreferences.getInstance();
                            int viewId = GraphMapRegistry.getInstance().getViewId(GeoViewOptionsBar.this.view);
                            prefs.updatePreferenceState(viewId, GeoViewOptionsBar.this.sim, "org.eclipse.stem.ui.views.graphmap.geoview.colorproviderproperty", pComp.getSelectedProperty().getDisplayName(null));
                        }
                        GeoViewOptionsBar.this.selectedProperty = propertySelectionEvent.getProperty();
                        GeoViewOptionsBar.this.firePropertySelectionEvent();
                    }
                });
            }
            this.colorProviderComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.geoViewOptionsGroup.layout();
            this.colorsLegendComposite = selectedColorProviderAdapterFactory.createColorsLegendComposite(this, 0);
            if (this.colorsLegendComposite != null) {
                this.colorsLegendComposite.pack();
                this.colorsLegendComposite.layout();
            }
            this.layout();
        }
    }

    private List<Decorator> getDecoratorsToDisplay(ISimulation simulation) {
        Graph canonicalGraph;
        ArrayList<Decorator> retValue = new ArrayList<Decorator>();
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            for (Object element : canonicalGraph.getDecorators()) {
                Decorator decorator = (Decorator)element;
                if (this.accept(decorator)) {
                    retValue.add(decorator);
                    continue;
                }
                if (!(decorator instanceof TriggerList)) continue;
                retValue.add(decorator);
            }
        }
        return retValue;
    }

    private void getInformation(ISimulation simulation) {
        Graph canonicalGraph;
        if (simulation != null && (canonicalGraph = simulation.getScenario().getCanonicalGraph()) != null) {
            canonicalGraph.getGraphLabels();
            canonicalGraph.getNodeLabelsByTypeURI(URI.createURI((String)"stemtype://org.eclipse.stem/label/population"));
        }
    }

    private void initializeCombo(Combo combo, String[] names, int selectionIndex) {
        combo.setItems(names);
        combo.select(selectionIndex);
    }

    private String[] getDecoratorNames(List<Decorator> decorators) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (decorators != null) {
            Iterator<Decorator> iterator = decorators.iterator();
            while (iterator.hasNext()) {
                ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                Decorator decorator = iterator.next();
                IItemLabelProvider lp = (IItemLabelProvider)itemProviderFactory.adapt((Notifier)decorator, IItemLabelProvider.class);
                String title = lp.getText((Object)decorator);
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private String[] getPopulationIdNames(List<String> popIds) {
        ArrayList<String> retValue = new ArrayList<String>();
        if (popIds != null) {
            for (String decid : popIds) {
                String title = decid;
                title = title == null ? "null" : title;
                retValue.add(title);
            }
        }
        return retValue.toArray(new String[0]);
    }

    private int getDecoratorIndex(Decorator selectedDecorator, List<Decorator> decorators) {
        if (selectedDecorator != null && decorators != null && !decorators.isEmpty()) {
            return decorators.indexOf(selectedDecorator);
        }
        return 0;
    }

    private int getPopulationIdIndex(String selectedPopId, List<String> popIds) {
        if (selectedPopId != null && popIds != null && !popIds.isEmpty()) {
            return popIds.indexOf(selectedPopId);
        }
        return 0;
    }

    private void firePropertySelectionEvent() {
        for (PropertySelectionListener listener : this.selectionListeners) {
            listener.propertySelected();
        }
    }

    private boolean accept(Decorator decorator) {
        EList labels = decorator.getLabelsToUpdate();
        if (labels == null) {
            return false;
        }
        for (DynamicLabel l : labels) {
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)l, RelativeValueProvider.class);
            if (rvp == null) continue;
            return true;
        }
        return false;
    }

    public static interface PropertySelectionListener {
        public void propertySelected();
    }
}

