/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.common.DoubleValue;
import org.eclipse.stem.core.common.DoubleValueList;
import org.eclipse.stem.core.common.DoubleValueMatrix;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.foodproduction.ConsumptionType;
import org.eclipse.stem.foodproduction.DiseaseCarryingTransformer;
import org.eclipse.stem.foodproduction.FoodConsumer;
import org.eclipse.stem.foodproduction.FoodproductionPackage;
import org.eclipse.stem.foodproduction.impl.FoodTransformerImpl;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;

public class FoodConsumerImpl
extends FoodTransformerImpl
implements FoodConsumer {
    protected IntegrationDecorator sourceDecorator;
    protected IntegrationDecorator targetDecorator;
    protected DoubleValueMatrix stateTransitionsMap;
    protected EList<EAttribute> sourceAttributes;
    protected EList<EAttribute> targetAttributes;
    protected static final double CONSUMPTION_RATE_EDEFAULT = 0.1;
    protected double consumptionRate = 0.1;
    protected static final ConsumptionType CONSUMPTION_TYPE_EDEFAULT = ConsumptionType.RELATIVE_CONSUMPTION;
    protected ConsumptionType consumptionType = CONSUMPTION_TYPE_EDEFAULT;
    protected static final double WASTE_RATE_EDEFAULT = 0.0;
    protected double wasteRate = 0.0;
    protected static final double MAX_VOLUME_OF_STOCKS_EDEFAULT = 1000000.0;
    protected double maxVolumeOfStocks = 1000000.0;

    @Override
    protected EClass eStaticClass() {
        return FoodproductionPackage.Literals.FOOD_CONSUMER;
    }

    @Override
    public IntegrationDecorator getSourceDecorator() {
        if (this.sourceDecorator != null && this.sourceDecorator.eIsProxy()) {
            InternalEObject oldSourceDecorator = (InternalEObject)this.sourceDecorator;
            this.sourceDecorator = (IntegrationDecorator)this.eResolveProxy(oldSourceDecorator);
            if (this.sourceDecorator != oldSourceDecorator && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 13, (Object)oldSourceDecorator, (Object)this.sourceDecorator));
            }
        }
        return this.sourceDecorator;
    }

    public IntegrationDecorator basicGetSourceDecorator() {
        return this.sourceDecorator;
    }

    @Override
    public void setSourceDecorator(IntegrationDecorator newSourceDecorator) {
        IntegrationDecorator oldSourceDecorator = this.sourceDecorator;
        this.sourceDecorator = newSourceDecorator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldSourceDecorator, (Object)this.sourceDecorator));
        }
    }

    @Override
    public IntegrationDecorator getTargetDecorator() {
        if (this.targetDecorator != null && this.targetDecorator.eIsProxy()) {
            InternalEObject oldTargetDecorator = (InternalEObject)this.targetDecorator;
            this.targetDecorator = (IntegrationDecorator)this.eResolveProxy(oldTargetDecorator);
            if (this.targetDecorator != oldTargetDecorator && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 14, (Object)oldTargetDecorator, (Object)this.targetDecorator));
            }
        }
        return this.targetDecorator;
    }

    public IntegrationDecorator basicGetTargetDecorator() {
        return this.targetDecorator;
    }

    @Override
    public void setTargetDecorator(IntegrationDecorator newTargetDecorator) {
        IntegrationDecorator oldTargetDecorator = this.targetDecorator;
        this.targetDecorator = newTargetDecorator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldTargetDecorator, (Object)this.targetDecorator));
        }
    }

    @Override
    public DoubleValueMatrix getStateTransitionsMap() {
        return this.stateTransitionsMap;
    }

    public NotificationChain basicSetStateTransitionsMap(DoubleValueMatrix newStateTransitionsMap, NotificationChain msgs) {
        DoubleValueMatrix oldStateTransitionsMap = this.stateTransitionsMap;
        this.stateTransitionsMap = newStateTransitionsMap;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldStateTransitionsMap, (Object)newStateTransitionsMap);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStateTransitionsMap(DoubleValueMatrix newStateTransitionsMap) {
        if (newStateTransitionsMap != this.stateTransitionsMap) {
            NotificationChain msgs = null;
            if (this.stateTransitionsMap != null) {
                msgs = ((InternalEObject)this.stateTransitionsMap).eInverseRemove((InternalEObject)this, -16, null, msgs);
            }
            if (newStateTransitionsMap != null) {
                msgs = ((InternalEObject)newStateTransitionsMap).eInverseAdd((InternalEObject)this, -16, null, msgs);
            }
            if ((msgs = this.basicSetStateTransitionsMap(newStateTransitionsMap, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newStateTransitionsMap, (Object)newStateTransitionsMap));
        }
    }

    @Override
    public EList<EAttribute> getSourceAttributes() {
        if (this.sourceAttributes == null) {
            this.sourceAttributes = new EObjectResolvingEList(EAttribute.class, (InternalEObject)this, 16);
        }
        return this.sourceAttributes;
    }

    @Override
    public EList<EAttribute> getTargetAttributes() {
        if (this.targetAttributes == null) {
            this.targetAttributes = new EObjectResolvingEList(EAttribute.class, (InternalEObject)this, 17);
        }
        return this.targetAttributes;
    }

    @Override
    public double getConsumptionRate() {
        return this.consumptionRate;
    }

    @Override
    public void setConsumptionRate(double newConsumptionRate) {
        double oldConsumptionRate = this.consumptionRate;
        this.consumptionRate = newConsumptionRate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldConsumptionRate, this.consumptionRate));
        }
    }

    @Override
    public ConsumptionType getConsumptionType() {
        return this.consumptionType;
    }

    @Override
    public void setConsumptionType(ConsumptionType newConsumptionType) {
        ConsumptionType oldConsumptionType = this.consumptionType;
        ConsumptionType consumptionType = this.consumptionType = newConsumptionType == null ? CONSUMPTION_TYPE_EDEFAULT : newConsumptionType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldConsumptionType, (Object)this.consumptionType));
        }
    }

    @Override
    public double getWasteRate() {
        return this.wasteRate;
    }

    @Override
    public void setWasteRate(double newWasteRate) {
        double oldWasteRate = this.wasteRate;
        this.wasteRate = newWasteRate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, oldWasteRate, this.wasteRate));
        }
    }

    @Override
    public double getMaxVolumeOfStocks() {
        return this.maxVolumeOfStocks;
    }

    @Override
    public void setMaxVolumeOfStocks(double newMaxVolumeOfStocks) {
        double oldMaxVolumeOfStocks = this.maxVolumeOfStocks;
        this.maxVolumeOfStocks = newMaxVolumeOfStocks;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 21, oldMaxVolumeOfStocks, this.maxVolumeOfStocks));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 15: {
                return this.basicSetStateTransitionsMap(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 13: {
                if (resolve) {
                    return this.getSourceDecorator();
                }
                return this.basicGetSourceDecorator();
            }
            case 14: {
                if (resolve) {
                    return this.getTargetDecorator();
                }
                return this.basicGetTargetDecorator();
            }
            case 15: {
                return this.getStateTransitionsMap();
            }
            case 16: {
                return this.getSourceAttributes();
            }
            case 17: {
                return this.getTargetAttributes();
            }
            case 18: {
                return this.getConsumptionRate();
            }
            case 19: {
                return this.getConsumptionType();
            }
            case 20: {
                return this.getWasteRate();
            }
            case 21: {
                return this.getMaxVolumeOfStocks();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 13: {
                this.setSourceDecorator((IntegrationDecorator)newValue);
                return;
            }
            case 14: {
                this.setTargetDecorator((IntegrationDecorator)newValue);
                return;
            }
            case 15: {
                this.setStateTransitionsMap((DoubleValueMatrix)newValue);
                return;
            }
            case 16: {
                this.getSourceAttributes().clear();
                this.getSourceAttributes().addAll((Collection)newValue);
                return;
            }
            case 17: {
                this.getTargetAttributes().clear();
                this.getTargetAttributes().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setConsumptionRate((Double)newValue);
                return;
            }
            case 19: {
                this.setConsumptionType((ConsumptionType)((Object)newValue));
                return;
            }
            case 20: {
                this.setWasteRate((Double)newValue);
                return;
            }
            case 21: {
                this.setMaxVolumeOfStocks((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 13: {
                this.setSourceDecorator(null);
                return;
            }
            case 14: {
                this.setTargetDecorator(null);
                return;
            }
            case 15: {
                this.setStateTransitionsMap(null);
                return;
            }
            case 16: {
                this.getSourceAttributes().clear();
                return;
            }
            case 17: {
                this.getTargetAttributes().clear();
                return;
            }
            case 18: {
                this.setConsumptionRate(0.1);
                return;
            }
            case 19: {
                this.setConsumptionType(CONSUMPTION_TYPE_EDEFAULT);
                return;
            }
            case 20: {
                this.setWasteRate(0.0);
                return;
            }
            case 21: {
                this.setMaxVolumeOfStocks(1000000.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 13: {
                return this.sourceDecorator != null;
            }
            case 14: {
                return this.targetDecorator != null;
            }
            case 15: {
                return this.stateTransitionsMap != null;
            }
            case 16: {
                return this.sourceAttributes != null && !this.sourceAttributes.isEmpty();
            }
            case 17: {
                return this.targetAttributes != null && !this.targetAttributes.isEmpty();
            }
            case 18: {
                return this.consumptionRate != 0.1;
            }
            case 19: {
                return this.consumptionType != CONSUMPTION_TYPE_EDEFAULT;
            }
            case 20: {
                return this.wasteRate != 0.0;
            }
            case 21: {
                return this.maxVolumeOfStocks != 1000000.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == DiseaseCarryingTransformer.class) {
            switch (derivedFeatureID) {
                case 13: {
                    return 0;
                }
                case 14: {
                    return 1;
                }
                case 15: {
                    return 2;
                }
                case 16: {
                    return 3;
                }
                case 17: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == DiseaseCarryingTransformer.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 13;
                }
                case 1: {
                    return 14;
                }
                case 2: {
                    return 15;
                }
                case 3: {
                    return 16;
                }
                case 4: {
                    return 17;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (consumptionRate: ");
        result.append(this.consumptionRate);
        result.append(", consumptionType: ");
        result.append((Object)this.consumptionType);
        result.append(", wasteRate: ");
        result.append(this.wasteRate);
        result.append(", maxVolumeOfStocks: ");
        result.append(this.maxVolumeOfStocks);
        result.append(')');
        return result.toString();
    }

    public void updateLabels(STEMTime time, long timeDelta, int cycle) {
        String sourcePopulation = this.getSourcePopulationName();
        String targetPopulation = this.getTargetPopulationName();
        StandardPackage populationPackage = StandardPackage.eINSTANCE;
        org.eclipse.stem.diseasemodels.standard.StandardPackage diseasePackage = org.eclipse.stem.diseasemodels.standard.StandardPackage.eINSTANCE;
        GraphPackage graphPackage = GraphPackage.eINSTANCE;
        for (DynamicLabel dl : this.getSourceLabels()) {
            double adjustedWasteRate;
            double sourceWasted;
            StandardPopulationModelLabel source = (StandardPopulationModelLabel)dl;
            Node node = source.getNode();
            StandardPopulationModelLabel target = (StandardPopulationModelLabel)node.getLabel(populationPackage.getStandardPopulationModelLabel(), graphPackage.getIntegrationLabel_Identifier(), (Object)targetPopulation);
            if (target == null) {
                Activator.logError((String)"Cannot find target population label", (Throwable)new Exception());
                continue;
            }
            StandardPopulationModelLabelValue sourceValue = (StandardPopulationModelLabelValue)source.getCurrentValue();
            StandardPopulationModelLabelValue targetValue = (StandardPopulationModelLabelValue)target.getCurrentValue();
            if (sourceValue.getCount() == 0.0 || targetValue.getCount() == 0.0) continue;
            StandardDiseaseModelLabel sourceDisease = (StandardDiseaseModelLabel)node.getLabel(diseasePackage.getDiseaseModelLabel(), graphPackage.getIntegrationLabel_Identifier(), (Object)sourcePopulation);
            StandardDiseaseModelLabel targetDisease = (StandardDiseaseModelLabel)node.getLabel(diseasePackage.getDiseaseModelLabel(), graphPackage.getIntegrationLabel_Identifier(), (Object)targetPopulation);
            StandardDiseaseModelLabelValue sourceDiseaseValue = (StandardDiseaseModelLabelValue)sourceDisease.getCurrentValue();
            StandardDiseaseModelLabelValue targetDiseaseValue = (StandardDiseaseModelLabelValue)targetDisease.getCurrentValue();
            double adjustedConsumptionRate = this.getConsumptionRate() * ((double)timeDelta / (double)this.getTimePeriod());
            double sourceConsumed = 0.0;
            if (this.consumptionType == ConsumptionType.RELATIVE_CONSUMPTION) {
                sourceConsumed = adjustedConsumptionRate * sourceValue.getCount();
            } else if (this.consumptionType == ConsumptionType.ABSOLUTE_CONSUMPTION) {
                sourceConsumed = adjustedConsumptionRate;
            } else if (this.consumptionType == ConsumptionType.CONSUMPTION_PER_PERSON) {
                sourceConsumed = adjustedConsumptionRate * targetValue.getCount();
            }
            if (sourceConsumed > sourceValue.getCount()) {
                sourceConsumed = sourceValue.getCount();
            }
            if (sourceConsumed > targetValue.getCount()) {
                sourceConsumed = targetValue.getCount();
            }
            if ((sourceWasted = (adjustedWasteRate = this.getWasteRate() * ((double)timeDelta / (double)this.getTimePeriod())) * sourceValue.getCount()) > sourceValue.getCount() - sourceConsumed) {
                sourceWasted = sourceValue.getCount() - sourceConsumed;
            }
            if (sourceValue.getCount() - sourceConsumed - sourceWasted > this.getMaxVolumeOfStocks()) {
                sourceWasted = sourceValue.getCount() - sourceConsumed - this.getMaxVolumeOfStocks();
            }
            double consumedByS = targetDiseaseValue.getS() / targetValue.getCount() * sourceConsumed;
            int row = 0;
            int col = 0;
            for (EAttribute sAttr : this.getSourceAttributes()) {
                double consumedFraction = (Double)sourceDiseaseValue.eGet((EStructuralFeature)sAttr) / sourceValue.getCount() * consumedByS;
                for (EAttribute tAttr : this.getTargetAttributes()) {
                    double moves = ((DoubleValue)((DoubleValueList)this.getStateTransitionsMap().getValueLists().get(row)).getValues().get(col)).getValue() * consumedFraction;
                    targetDiseaseValue.eSet((EStructuralFeature)tAttr, (Object)((Double)targetDiseaseValue.eGet((EStructuralFeature)tAttr) + moves));
                    targetDiseaseValue.setS(targetDiseaseValue.getS() - moves);
                    ++col;
                }
                col = 0;
                ++row;
            }
            double newSourceCount = sourceValue.getCount() - sourceConsumed - sourceWasted;
            double factor = newSourceCount / sourceValue.getCount();
            sourceValue.setCount(newSourceCount);
            sourceDiseaseValue.scale(factor);
        }
    }
}

