/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.TransformationDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.foodproduction.FoodTransformer;
import org.eclipse.stem.foodproduction.FoodproductionPackage;
import org.eclipse.stem.populationmodels.standard.DemographicPopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationGroup;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;

public abstract class FoodTransformerImpl
extends TransformationDecoratorImpl
implements FoodTransformer {
    protected static final String SOURCE_POPULATION_NAME_EDEFAULT = "cattle";
    protected String sourcePopulationName = "cattle";
    protected static final String TARGET_POPULATION_NAME_EDEFAULT = "beef";
    protected String targetPopulationName = "beef";
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected static final long TIME_PERIOD_EDEFAULT = 86400000L;
    protected long timePeriod = 86400000L;

    protected FoodTransformerImpl() {
    }

    protected EClass eStaticClass() {
        return FoodproductionPackage.Literals.FOOD_TRANSFORMER;
    }

    @Override
    public String getSourcePopulationName() {
        return this.sourcePopulationName;
    }

    @Override
    public void setSourcePopulationName(String newSourcePopulationName) {
        String oldSourcePopulationName = this.sourcePopulationName;
        this.sourcePopulationName = newSourcePopulationName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldSourcePopulationName, (Object)this.sourcePopulationName));
        }
    }

    @Override
    public String getTargetPopulationName() {
        return this.targetPopulationName;
    }

    @Override
    public void setTargetPopulationName(String newTargetPopulationName) {
        String oldTargetPopulationName = this.targetPopulationName;
        this.targetPopulationName = newTargetPopulationName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldTargetPopulationName, (Object)this.targetPopulationName));
        }
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        URI oldTargetURI = this.targetURI;
        this.targetURI = newTargetURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldTargetURI, (Object)this.targetURI));
        }
    }

    @Override
    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(long newTimePeriod) {
        long oldTimePeriod = this.timePeriod;
        this.timePeriod = newTimePeriod;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldTimePeriod, this.timePeriod));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getSourcePopulationName();
            }
            case 10: {
                return this.getTargetPopulationName();
            }
            case 11: {
                return this.getTargetURI();
            }
            case 12: {
                return this.getTimePeriod();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setSourcePopulationName((String)newValue);
                return;
            }
            case 10: {
                this.setTargetPopulationName((String)newValue);
                return;
            }
            case 11: {
                this.setTargetURI((URI)newValue);
                return;
            }
            case 12: {
                this.setTimePeriod((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setSourcePopulationName(SOURCE_POPULATION_NAME_EDEFAULT);
                return;
            }
            case 10: {
                this.setTargetPopulationName(TARGET_POPULATION_NAME_EDEFAULT);
                return;
            }
            case 11: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 12: {
                this.setTimePeriod(86400000L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return SOURCE_POPULATION_NAME_EDEFAULT == null ? this.sourcePopulationName != null : !SOURCE_POPULATION_NAME_EDEFAULT.equals(this.sourcePopulationName);
            }
            case 10: {
                return TARGET_POPULATION_NAME_EDEFAULT == null ? this.targetPopulationName != null : !TARGET_POPULATION_NAME_EDEFAULT.equals(this.targetPopulationName);
            }
            case 11: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals((Object)this.targetURI);
            }
            case 12: {
                return this.timePeriod != 86400000L;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sourcePopulationName: ");
        result.append(this.sourcePopulationName);
        result.append(", targetPopulationName: ");
        result.append(this.targetPopulationName);
        result.append(", targetURI: ");
        result.append(this.targetURI);
        result.append(", timePeriod: ");
        result.append(this.timePeriod);
        result.append(')');
        return result.toString();
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        String sourcePopulation = this.getSourcePopulationName();
        String foodPopulation = this.getTargetPopulationName();
        Graph canonicalGraph = this.getGraph();
        EList decorators = canonicalGraph.getDecorators();
        for (Decorator d : decorators) {
            if (!(d instanceof PopulationModel)) continue;
            if (d instanceof DemographicPopulationModel) {
                DemographicPopulationModel dpm = (DemographicPopulationModel)d;
                EList groups = dpm.getPopulationGroups();
                for (PopulationGroup g : groups) {
                    if (!g.getIdentifier().equals(sourcePopulation)) continue;
                    this.addMatchingPopLabels((EList<DynamicLabel>)dpm.getLabelsToUpdate(), sourcePopulation, foodPopulation);
                }
                continue;
            }
            PopulationModel pm = (PopulationModel)d;
            if (!pm.getPopulationIdentifier().equals(sourcePopulation)) continue;
            this.addMatchingPopLabels((EList<DynamicLabel>)pm.getLabelsToUpdate(), sourcePopulation, foodPopulation);
        }
    }

    private void addMatchingPopLabels(EList<DynamicLabel> sourceLabels, String sourcePop, String foodPop) {
        URI thisTransformersURI = this.targetURI;
        for (DynamicLabel dl : sourceLabels) {
            StandardPopulationModelLabel popLabel;
            if (!(dl instanceof StandardPopulationModelLabel) || !(popLabel = (StandardPopulationModelLabel)dl).getPopulationIdentifier().equals(sourcePop) || !this.existsStaticPopulationLabel(foodPop, (Node)dl.getIdentifiable())) continue;
            Node node = popLabel.getNode();
            if (thisTransformersURI == null) {
                this.getSourceLabels().add((Object)popLabel);
                continue;
            }
            boolean match = this.isContained(node, thisTransformersURI);
            if (!match) continue;
            this.getSourceLabels().add((Object)popLabel);
        }
    }

    private boolean isContained(Node node, URI uri) {
        URI labeledURI = node.getURI();
        if (uri.equals((Object)labeledURI)) {
            return true;
        }
        EList edges = node.getEdges();
        for (Edge e : edges) {
            if (!(e.getLabel() instanceof RelativePhysicalRelationshipLabel)) continue;
            Node nodeA = e.getA();
            Node nodeB = e.getB();
            if (!nodeA.equals(node)) continue;
            return this.isContained(nodeB, uri);
        }
        return false;
    }

    private boolean existsStaticPopulationLabel(String foodPop, Node node) {
        for (NodeLabel nl : node.getLabels()) {
            if (!(nl instanceof PopulationLabel) || !((PopulationLabel)nl).getPopulationIdentifier().equals(foodPop)) continue;
            return true;
        }
        return false;
    }
}

