/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.foodproduction.presentation;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.foodproduction.FoodTransformer;
import org.eclipse.stem.foodproduction.presentation.FoodProductionDefinitionControl;
import org.eclipse.stem.foodproduction.presentation.FoodProductionMessages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewFoodTransformerWizard
extends NewIdentifiableWizard {
    private NewFoodTransformerPage nfpp = null;

    protected String getWizardTitle() {
        return FoodProductionMessages.getString("NFPWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.nfpp = new NewFoodTransformerPage(FoodProductionMessages.getString("NFPWiz.page_title"), this);
        this.nfpp.setTitle(FoodProductionMessages.getString("NFPWiz.page_title"));
        this.nfpp.setDescription(FoodProductionMessages.getString("NFPWiz.page_description"));
        this.setHelpContextId("org.eclipse.stem.doc.newfoodproduction_contextid");
        return this.nfpp;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/foodproduction/foodproduction.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.createTypeURI((String)"foodproducer").toString());
                this.type.setEnabled(false);
                FoodTransformer foodTransformer = NewFoodTransformerWizard.this.nfpp.getSelectedFoodTransformer();
                DublinCore plugginDublinCore = foodTransformer.getDublinCore();
                this.updateDublinCorePage(plugginDublinCore);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        FoodTransformer retValue = this.nfpp.getSelectedFoodTransformer();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    protected String getSerializationFolderName() {
        return "decorators";
    }

    protected String getSerializationFileNameExtension() {
        return "foodproduction";
    }

    protected static class NewFoodTransformerPage
    extends NewIdentifiablePage {
        FoodProductionDefinitionControl fpc = null;
        NewFoodTransformerWizard parentWizard = null;

        protected NewFoodTransformerPage(String pageName, NewFoodTransformerWizard newFPWizard) {
            super(pageName);
            this.parentWizard = newFPWizard;
        }

        protected Composite createSpecificComposite(Composite parent) {
            this.fpc = new FoodProductionDefinitionControl(parent, 0, this.projectValidator, this.getSelectedProject(), this.parentWizard);
            return this.fpc;
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.fpc.validate();
                if (!retValue) {
                    this.setErrorMessage(this.fpc.getErrorMessage());
                }
            }
            return retValue;
        }

        FoodTransformer getSelectedFoodTransformer() {
            return this.fpc.getSelectedFoodTransformer();
        }
    }

    public static class NewFoodTransformerWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewFoodTransformerWizard wizard = new NewFoodTransformerWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

