/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.centers;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.stem.geography.names.GeographicMapper;

public class GeographicCenters
extends GeographicMapper {
    private static final String CENTERS_BUNDLE_TYPE = "centers";
    public static final String LEVEL_0_ISO_NAMES_ROOT_NAME = "level0ISONames";
    private static final String LEVEL_0_RB_NAME = "org.eclipse.stem.data.geography.level0ISONames";
    private static ResourceBundle level0RB = null;
    private static Map<String, ResourceBundle> rbMap = new HashMap<String, ResourceBundle>();

    public static double[] getCenter(String isoKey) {
        return GeographicCenters.getCenter(isoKey, GeographicCenters.keyLevel(isoKey));
    }

    public static double[] getCenter(String isoKey, int level) {
        double[] retValue = null;
        String latLongString = "";
        try {
            if (isoKey.equalsIgnoreCase("ZZZ")) {
                retValue = new double[]{0.0, 0.0};
                return retValue;
            }
            String isoKey2 = isoKey;
            if (isoKey.length() == 3) {
                isoKey2 = GeographicCenters.getAlpha2(isoKey);
            }
            ResourceBundle rb = GeographicCenters.getResourceBundle(isoKey2, level, "org.eclipse.stem.data.geography.centers", CENTERS_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
            try {
                latLongString = rb.getString(isoKey2).trim();
            }
            catch (MissingResourceException missingResourceException) {
                rb = GeographicCenters.getResourceBundle(isoKey, level, "org.eclipse.stem.data.geography.centers", CENTERS_BUNDLE_TYPE, LEVEL_0_RB_NAME, level0RB, rbMap);
                latLongString = rb.getString(isoKey).trim();
            }
            if (latLongString != null && !latLongString.equals("")) {
                StringTokenizer st = new StringTokenizer(latLongString, ",");
                String latitudeString = st.nextToken();
                String longitudeString = st.nextToken();
                retValue = new double[]{Double.parseDouble(latitudeString), Double.parseDouble(longitudeString)};
            }
        }
        catch (MissingResourceException missingResourceException) {
            retValue = null;
        }
        catch (NullPointerException nullPointerException) {
            retValue = null;
        }
        catch (NumberFormatException nfe) {
            Activator.logError((String)("Error parsing \"" + latLongString + "\" for the lat/long center of \"" + isoKey + "\" Number format?"), (Throwable)nfe);
        }
        catch (NoSuchElementException nsee) {
            Activator.logError((String)("Error parsing \"" + latLongString + "\" for the lat/long center of \"" + isoKey + "\" Missing value?"), (Throwable)nsee);
        }
        return retValue;
    }

    protected static ResourceBundle getResourceBundle(String isoKey, int level, String bundlePrefix, String bundleType, String level0RBName, ResourceBundle level0RB, Map<String, ResourceBundle> rbMap) {
        ResourceBundle retValue = null;
        String alpha2ISOKey = isoKey;
        alpha2ISOKey = isoKey.length() == 3 ? GeographicCenters.getAlpha2(isoKey) : isoKey.trim().substring(0, 2);
        retValue = rbMap.get(alpha2ISOKey);
        if (retValue == null) {
            retValue = GeographicCenters.readResourceBundle(alpha2ISOKey, bundlePrefix, bundleType);
            if (retValue == null) {
                Activator.logError((String)("Could not read Resource Bundle of type " + bundleType + " for \"" + alpha2ISOKey + "\""), null);
            } else {
                rbMap.put(alpha2ISOKey, retValue);
            }
        }
        return retValue;
    }
}

