/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.ImplementedBy;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.JvmModelAssociator;

@ImplementedBy(value=Impl.class)
public interface IXtendJvmAssociations
extends IJvmModelAssociations {
    public JvmGenericType getInferredType(XtendClass var1);

    public JvmConstructor getInferredConstructor(XtendClass var1);

    public JvmConstructor getInferredConstructor(XtendConstructor var1);

    public JvmOperation getDirectlyInferredOperation(XtendFunction var1);

    public JvmOperation getDispatchOperation(XtendFunction var1);

    public JvmField getJvmField(XtendField var1);

    public XtendClass getXtendClass(JvmGenericType var1);

    public XtendFunction getXtendFunction(JvmOperation var1);

    public XtendConstructor getXtendConstructor(JvmConstructor var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Singleton
    public static class Impl
    extends JvmModelAssociator
    implements IXtendJvmAssociations {
        @Override
        public JvmGenericType getInferredType(XtendClass xtendClass) {
            JvmGenericType firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendClass), JvmGenericType.class);
            return firstOrNull;
        }

        @Override
        public JvmConstructor getInferredConstructor(XtendClass xtendClass) {
            JvmConstructor firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendClass), JvmConstructor.class);
            return firstOrNull;
        }

        @Override
        public JvmConstructor getInferredConstructor(XtendConstructor xtendConstructor) {
            JvmConstructor firstOrNull = this.getFirstOrNull(this.getJvmElements(xtendConstructor), JvmConstructor.class);
            return firstOrNull;
        }

        @Override
        public JvmOperation getDirectlyInferredOperation(XtendFunction xtendFunction) {
            Iterable jvmElements = Iterables.filter((Iterable)this.getJvmElements(xtendFunction), JvmOperation.class);
            String expectedName = xtendFunction.getName();
            if (xtendFunction.isDispatch()) {
                expectedName = "_" + expectedName;
            }
            for (JvmOperation jvmOperation : jvmElements) {
                if (!jvmOperation.getSimpleName().equals(expectedName)) continue;
                return jvmOperation;
            }
            return null;
        }

        @Override
        public JvmOperation getDispatchOperation(XtendFunction dispatchFunction) {
            if (!dispatchFunction.isDispatch()) {
                throw new IllegalArgumentException("Function " + dispatchFunction.getName() + " is not a dispatch function");
            }
            Set jvmElements = this.getJvmElements(dispatchFunction);
            for (EObject candidate : jvmElements) {
                if (!(candidate instanceof JvmOperation) || !dispatchFunction.getName().equals(((JvmOperation)candidate).getSimpleName())) continue;
                return (JvmOperation)candidate;
            }
            return null;
        }

        @Override
        public XtendClass getXtendClass(JvmGenericType jvmType) {
            return (XtendClass)this.getPrimarySourceElement((EObject)jvmType);
        }

        @Override
        public XtendFunction getXtendFunction(JvmOperation jvmOperation) {
            return (XtendFunction)this.getPrimarySourceElement((EObject)jvmOperation);
        }

        @Override
        public XtendConstructor getXtendConstructor(JvmConstructor jvmConstructor) {
            EObject primarySourceElement = this.getPrimarySourceElement((EObject)jvmConstructor);
            return primarySourceElement instanceof XtendConstructor ? (XtendConstructor)primarySourceElement : null;
        }

        protected <T> T getFirstOrNull(Iterable<EObject> elements, Class<T> type) {
            Iterator iterator = Iterables.filter(elements, type).iterator();
            return iterator.hasNext() ? (T)iterator.next() : null;
        }

        @Override
        public JvmField getJvmField(XtendField field) {
            return this.getFirstOrNull(this.getJvmElements(field), JvmField.class);
        }
    }
}

