/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeStack {
    private Stack<Scope> scopes = new Stack();

    public void openScope(boolean pseudoScope) {
        this.scopes.push(new Scope(pseudoScope));
    }

    public void closeScope() {
        this.scopes.pop();
    }

    @Nullable
    public Object get(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.scopes.isEmpty()) {
            return null;
        }
        int size = this.scopes.size();
        int i = size - 1;
        while (i >= 0) {
            Scope currentScope;
            Variable var;
            if ((var = (currentScope = (Scope)this.scopes.get(i--)).get(name)) == null) continue;
            return var.referenced;
        }
        return null;
    }

    @Nullable
    public String getName(Object referenced) {
        if (referenced == null) {
            throw new NullPointerException("referenced");
        }
        if (this.scopes.isEmpty()) {
            return null;
        }
        int size = this.scopes.size();
        int i = size - 1;
        while (i >= 0) {
            Scope currentScope = (Scope)this.scopes.get(i--);
            for (Variable v : currentScope.variables()) {
                if (!v.referenced.equals(referenced)) continue;
                return v.name;
            }
        }
        return null;
    }

    @NonNull
    public String declareVariable(@NonNull Object key, @NonNull String proposedName, boolean synthetic) {
        if (this.scopes.isEmpty()) {
            throw new IllegalArgumentException("No scope has been opened yet.");
        }
        Scope currentScope = this.scopes.peek();
        HashSet names = Sets.newHashSet();
        boolean scopeClosed = false;
        for (Scope scope : Lists.reverse((List)Lists.newArrayList(this.scopes))) {
            for (Variable variable : scope.variables()) {
                if (scopeClosed && variable.synthetic) continue;
                names.add(variable.name);
            }
            boolean bl = scopeClosed = scopeClosed || !scope.pseudoScope;
            if (scopeClosed && !synthetic) break;
        }
        String newName = this.findNewName(names, proposedName);
        currentScope.addVariable(newName, synthetic, key);
        return newName;
    }

    @NonNull
    protected String findNewName(@NonNull Set<String> names, @NonNull String proposedName) {
        if (names.contains(proposedName)) {
            int i = 1;
            while (i < Integer.MAX_VALUE) {
                String newProposal = String.valueOf(proposedName) + "_" + i;
                if (!names.contains(newProposal)) {
                    return newProposal;
                }
                ++i;
            }
        }
        return proposedName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @NonNullByDefault
    static class Scope {
        public boolean pseudoScope = false;
        private Map<String, Variable> variables = Maps.newHashMap();

        public Scope(boolean pseudoScope) {
            this.pseudoScope = pseudoScope;
        }

        public void addVariable(String name, boolean synthetic, Object element) {
            if (this.variables.containsKey(name)) {
                throw new IllegalArgumentException("variable '" + name + "' already declared in scope.");
            }
            this.variables.put(name, new Variable(name, synthetic, element));
        }

        public Set<String> variableNames() {
            return this.variables.keySet();
        }

        public Iterable<Variable> variables() {
            return this.variables.values();
        }

        @Nullable
        public Variable get(String name) {
            return this.variables.get(name);
        }

        public String toString() {
            return String.valueOf(this.pseudoScope ? "[PSEUDO]" : "") + this.variables;
        }
    }

    @NonNullByDefault
    static final class Variable {
        public String name;
        public boolean synthetic;
        public Object referenced;

        Variable(String name2, boolean synthetic2, Object referenced) {
            this.name = name2;
            this.synthetic = synthetic2;
            this.referenced = referenced;
        }

        public String toString() {
            return this.referenced.getClass().getSimpleName();
        }
    }
}

