/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Provider;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionBasedScope
extends AbstractScope {
    private final IFeatureScopeSession session;
    private final XAbstractFeatureCall featureCall;

    protected AbstractSessionBasedScope(IScope parent, IFeatureScopeSession session, XAbstractFeatureCall featureCall) {
        super(parent, false);
        if (session == null) {
            throw new IllegalArgumentException("session may not be null");
        }
        this.session = session;
        this.featureCall = featureCall;
    }

    protected IFeatureScopeSession getSession() {
        return this.session;
    }

    protected XAbstractFeatureCall getFeatureCall() {
        return this.featureCall;
    }

    protected String getFeatureName(QualifiedName name) {
        return name.toString();
    }

    protected abstract Collection<IEObjectDescription> getLocalElementsByName(QualifiedName var1);

    public Iterable<IEObjectDescription> getElements(final QualifiedName name) {
        Iterable localElements = this.getLocalElementsByName(name);
        if (localElements.isEmpty()) {
            return this.getParent().getElements(name);
        }
        Iterable parentElements = this.getParentElements((Provider)new Provider<Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> get() {
                return AbstractSessionBasedScope.this.getParent().getElements(name);
            }
        });
        Iterable result = Iterables.concat((Iterable)localElements, (Iterable)parentElements);
        return result;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByEObject(final EObject object, final URI uri) {
        Iterable localElements = this.getAllLocalElements();
        Iterable result = Iterables.filter((Iterable)localElements, (Predicate)new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                if (input.getEObjectOrProxy() == object) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                if (uri.equals((Object)input.getEObjectURI())) {
                    return this.canBeFoundByNameAndShadowingKey(input);
                }
                return false;
            }

            public boolean canBeFoundByNameAndShadowingKey(IEObjectDescription input) {
                Iterable lookUp = AbstractSessionBasedScope.this.getLocalElementsByName(input.getName());
                String myShadowingKey = AbstractSessionBasedScope.this.getShadowingKey(input);
                for (IEObjectDescription other : lookUp) {
                    if (!myShadowingKey.equals(AbstractSessionBasedScope.this.getShadowingKey(other))) continue;
                    if (other == input) {
                        return true;
                    }
                    if (other.getEObjectOrProxy() == object) {
                        return true;
                    }
                    return uri.equals((Object)other.getEObjectURI());
                }
                return false;
            }
        });
        return result;
    }

    protected String getShadowingKey(IEObjectDescription description) {
        if (description instanceof BucketedEObjectDescription) {
            return ((BucketedEObjectDescription)description).getShadowingKey();
        }
        return description.getName().toString();
    }

    protected boolean isShadowed(IEObjectDescription fromParent) {
        Iterable localElements = this.getLocalElementsByName(fromParent.getName());
        if (localElements.isEmpty()) {
            return false;
        }
        String shadowingKey = this.getShadowingKey(fromParent);
        for (IEObjectDescription local : localElements) {
            if (!shadowingKey.equals(this.getShadowingKey(local))) continue;
            return true;
        }
        return false;
    }
}

