/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.featurecalls;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.inject.Singleton;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class OperatorMapping {
    public static final QualifiedName PLUS = QualifiedName.create((String)"+");
    public static final QualifiedName MINUS = QualifiedName.create((String)"-");
    public static final QualifiedName POWER = QualifiedName.create((String)"**");
    public static final QualifiedName MULTIPLY = QualifiedName.create((String)"*");
    public static final QualifiedName DIVIDE = QualifiedName.create((String)"/");
    public static final QualifiedName MODULO = QualifiedName.create((String)"%");
    public static final QualifiedName DOUBLE_LESS_THAN = QualifiedName.create((String)"<<");
    public static final QualifiedName DOUBLE_GREATER_THAN = QualifiedName.create((String)">>");
    public static final QualifiedName TRIPLE_LESS_THAN = QualifiedName.create((String)"<<<");
    public static final QualifiedName TRIPLE_GREATER_THAN = QualifiedName.create((String)">>>");
    public static final QualifiedName ELVIS = QualifiedName.create((String)"?:");
    public static final QualifiedName DIAMOND = QualifiedName.create((String)"<>");
    public static final QualifiedName SPACESHIP = QualifiedName.create((String)"<=>");
    public static final QualifiedName OR = QualifiedName.create((String)"||");
    public static final QualifiedName AND = QualifiedName.create((String)"&&");
    public static final QualifiedName ADD = QualifiedName.create((String)"+=");
    public static final QualifiedName EQUALS = QualifiedName.create((String)"==");
    public static final QualifiedName NOT_EQUALS = QualifiedName.create((String)"!=");
    public static final QualifiedName LESS_THAN = QualifiedName.create((String)"<");
    public static final QualifiedName LESS_EQUALS_THAN = QualifiedName.create((String)"<=");
    public static final QualifiedName GREATER_THAN = QualifiedName.create((String)">");
    public static final QualifiedName GREATER_EQUALS_THAN = QualifiedName.create((String)">=");
    public static final QualifiedName MAPPED_TO = QualifiedName.create((String)"->");
    public static final QualifiedName UP_TO = QualifiedName.create((String)"..");
    public static final QualifiedName NOT = QualifiedName.create((String)"!");
    public static final QualifiedName DOUBLE_ARROW = QualifiedName.create((String)"=>");
    protected BiMap<QualifiedName, QualifiedName> map = HashBiMap.create();
    public static final String OP_PREFIX = "operator_";

    public OperatorMapping() {
        this.initializeMapping();
    }

    protected void initializeMapping() {
        this.map.put((Object)PLUS, (Object)QualifiedName.create((String)"operator_plus"));
        this.map.put((Object)MINUS, (Object)QualifiedName.create((String)"operator_minus"));
        this.map.put((Object)POWER, (Object)QualifiedName.create((String)"operator_power"));
        this.map.put((Object)MULTIPLY, (Object)QualifiedName.create((String)"operator_multiply"));
        this.map.put((Object)DIVIDE, (Object)QualifiedName.create((String)"operator_divide"));
        this.map.put((Object)MODULO, (Object)QualifiedName.create((String)"operator_modulo"));
        this.map.put((Object)DOUBLE_LESS_THAN, (Object)QualifiedName.create((String)"operator_doubleLessThan"));
        this.map.put((Object)DOUBLE_GREATER_THAN, (Object)QualifiedName.create((String)"operator_doubleGreaterThan"));
        this.map.put((Object)TRIPLE_LESS_THAN, (Object)QualifiedName.create((String)"operator_tripleLessThan"));
        this.map.put((Object)TRIPLE_GREATER_THAN, (Object)QualifiedName.create((String)"operator_tripleGreaterThan"));
        this.map.put((Object)ELVIS, (Object)QualifiedName.create((String)"operator_elvis"));
        this.map.put((Object)DIAMOND, (Object)QualifiedName.create((String)"operator_diamond"));
        this.map.put((Object)SPACESHIP, (Object)QualifiedName.create((String)"operator_spaceship"));
        this.map.put((Object)OR, (Object)QualifiedName.create((String)"operator_or"));
        this.map.put((Object)AND, (Object)QualifiedName.create((String)"operator_and"));
        this.map.put((Object)ADD, (Object)QualifiedName.create((String)"operator_add"));
        this.map.put((Object)EQUALS, (Object)QualifiedName.create((String)"operator_equals"));
        this.map.put((Object)NOT_EQUALS, (Object)QualifiedName.create((String)"operator_notEquals"));
        this.map.put((Object)LESS_THAN, (Object)QualifiedName.create((String)"operator_lessThan"));
        this.map.put((Object)LESS_EQUALS_THAN, (Object)QualifiedName.create((String)"operator_lessEqualsThan"));
        this.map.put((Object)GREATER_THAN, (Object)QualifiedName.create((String)"operator_greaterThan"));
        this.map.put((Object)GREATER_EQUALS_THAN, (Object)QualifiedName.create((String)"operator_greaterEqualsThan"));
        this.map.put((Object)MAPPED_TO, (Object)QualifiedName.create((String)"operator_mappedTo"));
        this.map.put((Object)UP_TO, (Object)QualifiedName.create((String)"operator_upTo"));
        this.map.put((Object)NOT, (Object)QualifiedName.create((String)"operator_not"));
        this.map.put((Object)DOUBLE_ARROW, (Object)QualifiedName.create((String)"operator_doubleArrow"));
    }

    public QualifiedName getMethodName(QualifiedName operator) {
        return (QualifiedName)this.map.get((Object)operator);
    }

    public QualifiedName getOperator(QualifiedName methodName) {
        return (QualifiedName)this.map.inverse().get((Object)methodName);
    }
}

