/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.RootExpressionComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.util.BoundTypeArgumentMerger;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.TypeParameterSubstitutor;

public class DefaultReentrantTypeResolver
implements IReentrantTypeResolver {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private ITypeComputer typeComputer;
    @Inject
    private ScopeProviderAccess scopeProviderAccess;
    @Inject
    private IBatchScopeProvider batchScopeProvider;
    @Inject
    private BoundTypeArgumentMerger typeArgumentMerger;
    private EObject root;
    private boolean resolving = false;

    public void initializeFrom(@NonNull EObject root) {
        this.root = root;
    }

    protected EObject getRoot() {
        return this.root;
    }

    @NonNull
    public IResolvedTypes reentrantResolve() {
        if (this.resolving) {
            throw new UnsupportedOperationException("TODO: import a functional handle on the type resolution that delegates to the best available (current, but evolving) result");
        }
        try {
            this.resolving = true;
            IResolvedTypes iResolvedTypes = this.resolve();
            return iResolvedTypes;
        }
        finally {
            this.resolving = false;
        }
    }

    protected IResolvedTypes resolve() {
        ResolvedTypes result = new ResolvedTypes(this);
        IFeatureScopeSession session = this.batchScopeProvider.newSession(this.root.eResource());
        this.computeTypes(result, session);
        return result;
    }

    protected TypeParameterSubstitutor createTypeParameterSubstitutor() {
        return new TypeParameterSubstitutor(Collections.<JvmTypeParameter, JvmTypeReference>emptyMap(), this.services);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session) {
        this.computeTypes(resolvedTypes, session, this.root);
    }

    protected void computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, EObject element) {
        if (!(element instanceof XExpression)) {
            throw new IllegalArgumentException("element: " + element);
        }
        this._computeTypes(resolvedTypes, session, (XExpression)element);
    }

    protected void _computeTypes(ResolvedTypes resolvedTypes, IFeatureScopeSession session, XExpression expression) {
        RootExpressionComputationState state = new RootExpressionComputationState(resolvedTypes, session, expression, this);
        state.computeTypes();
    }

    protected ITypeComputer getTypeComputer() {
        return this.typeComputer;
    }

    protected void setTypeComputer(ITypeComputer typeComputer) {
        this.typeComputer = typeComputer;
    }

    protected ScopeProviderAccess getScopeProviderAccess() {
        return this.scopeProviderAccess;
    }

    protected IBatchScopeProvider getBatchScopeProvider() {
        return this.batchScopeProvider;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected BoundTypeArgumentMerger getTypeArgumentMerger() {
        return this.typeArgumentMerger;
    }
}

