/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.util;

import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.UnboundTypeParameter;
import org.eclipse.xtext.xtype.XComputedTypeReference;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.util.AbstractXtypeReferenceVisitor;
import org.eclipse.xtext.xtype.util.AbstractXtypeReferenceVisitorWithParameter;

public class TypeReferenceAnalyzer {
    public boolean isReferencedBy(JvmType type, JvmTypeReference reference) {
        return this.isReferencedBy(type, reference, true);
    }

    public boolean isReferencedBy(JvmType type, JvmTypeReference reference, final boolean resolveUnbound) {
        AbstractXtypeReferenceVisitorWithParameter<JvmType, Boolean> visitor = new AbstractXtypeReferenceVisitorWithParameter<JvmType, Boolean>(){

            public Boolean doVisitTypeReference(JvmTypeReference reference, JvmType type) {
                return Boolean.FALSE;
            }

            protected Boolean handleNullReference(JvmType type) {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitFunctionTypeReference(XFunctionTypeRef reference, JvmType type) {
                for (JvmTypeReference paramType : reference.getParamTypes()) {
                    if (!((Boolean)this.visit(paramType, type)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                if (((Boolean)this.visit(reference.getReturnType(), type)).booleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitCompoundTypeReference(JvmCompoundTypeReference reference, JvmType type) {
                for (JvmTypeReference component : reference.getReferences()) {
                    if (!((Boolean)this.visit(component, type)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitComputedTypeReference(XComputedTypeReference reference, JvmType type) {
                if (type instanceof JvmTypeParameter && reference.getTypeProvider() instanceof UnboundTypeParameter) {
                    UnboundTypeParameter unboundTypeParameter = (UnboundTypeParameter)reference.getTypeProvider();
                    if (unboundTypeParameter.getTypeParameter() == type) {
                        return Boolean.TRUE;
                    }
                    if (!resolveUnbound) {
                        return Boolean.FALSE;
                    }
                }
                return (Boolean)super.doVisitComputedTypeReference(reference, type);
            }

            public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference, JvmType type) {
                if (type instanceof JvmArrayType && type == reference.getType()) {
                    return Boolean.TRUE;
                }
                if (((Boolean)this.visit(reference.getComponentType(), type)).booleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference, JvmType type) {
                for (JvmTypeConstraint constraint : reference.getConstraints()) {
                    if (!((Boolean)this.visit(constraint.getTypeReference(), type)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference, JvmType type) {
                if (type == reference.getType()) {
                    return Boolean.TRUE;
                }
                for (JvmTypeReference argument : reference.getArguments()) {
                    if (!((Boolean)this.visit(argument, type)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        boolean result = (Boolean)visitor.visit(reference, type);
        return result;
    }

    public boolean isReferenceToTypeParameter(JvmTypeReference reference, final boolean resolveUnbound) {
        AbstractXtypeReferenceVisitor<Boolean> visitor = new AbstractXtypeReferenceVisitor<Boolean>(){

            public Boolean doVisitTypeReference(JvmTypeReference reference) {
                return Boolean.FALSE;
            }

            protected Boolean handleNullReference() {
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitFunctionTypeReference(XFunctionTypeRef reference) {
                for (JvmTypeReference paramType : reference.getParamTypes()) {
                    if (!((Boolean)this.visit(paramType)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                if (((Boolean)this.visit(reference.getReturnType())).booleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitCompoundTypeReference(JvmCompoundTypeReference reference) {
                for (JvmTypeReference component : reference.getReferences()) {
                    if (!((Boolean)this.visit(component)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            @Override
            public Boolean doVisitComputedTypeReference(XComputedTypeReference reference) {
                if (reference.getTypeProvider() instanceof UnboundTypeParameter && !resolveUnbound) {
                    return Boolean.TRUE;
                }
                return (Boolean)super.doVisitComputedTypeReference(reference);
            }

            public Boolean doVisitGenericArrayTypeReference(JvmGenericArrayTypeReference reference) {
                if (((Boolean)this.visit(reference.getComponentType())).booleanValue()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitWildcardTypeReference(JvmWildcardTypeReference reference) {
                for (JvmTypeConstraint constraint : reference.getConstraints()) {
                    if (!((Boolean)this.visit(constraint.getTypeReference())).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            public Boolean doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                if (reference.getType() instanceof JvmTypeParameter) {
                    return Boolean.TRUE;
                }
                for (JvmTypeReference argument : reference.getArguments()) {
                    if (!((Boolean)this.visit(argument)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        boolean result = (Boolean)visitor.visit(reference);
        return result;
    }
}

