/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtype.impl;

import com.google.common.collect.Lists;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitor;
import org.eclipse.xtext.common.types.util.ITypeReferenceVisitorWithParameter;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.impl.XFunctionTypeRefImpl;
import org.eclipse.xtext.xtype.util.XtypeReferenceVisitor;
import org.eclipse.xtext.xtype.util.XtypeReferenceVisitorWithParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFunctionTypeRefImplCustom
extends XFunctionTypeRefImpl {
    private static final URI javaLangObjectURI = URI.createURI((String)"java:/Objects/java.lang.Object#java.lang.Object");

    public <Result> Result accept(ITypeReferenceVisitor<Result> visitor) {
        if (visitor instanceof XtypeReferenceVisitor) {
            return ((XtypeReferenceVisitor)visitor).doVisitFunctionTypeReference(this);
        }
        return (Result)super.accept(visitor);
    }

    public <Parameter, Result> Result accept(ITypeReferenceVisitorWithParameter<Parameter, Result> visitor, Parameter parameter) {
        if (visitor instanceof XtypeReferenceVisitorWithParameter) {
            return ((XtypeReferenceVisitorWithParameter)visitor).doVisitFunctionTypeReference(this, parameter);
        }
        return (Result)super.accept(visitor, parameter);
    }

    @Override
    public JvmType getType() {
        if (this.type == null) {
            JvmVoid newType = TypesFactory.eINSTANCE.createJvmVoid();
            ((InternalEObject)newType).eSetProxyURI(this.computeTypeUri(this.isProcedure()));
            this.type = (JvmType)this.eResolveProxy((InternalEObject)newType);
        }
        return super.getType();
    }

    private boolean isProcedure() {
        JvmTypeReference returnType = this.getReturnType();
        if (returnType == null) {
            return true;
        }
        JvmType type = returnType.getType();
        if (type == null) {
            return false;
        }
        if (type.eIsProxy()) {
            return false;
        }
        return type instanceof JvmVoid;
    }

    public JvmTypeReference getEquivalent() {
        if (this.equivalent == null) {
            JvmType rawType = this.getType();
            if (rawType != null && rawType instanceof JvmDeclaredType) {
                JvmParameterizedTypeReference result = !this.isInstanceContext() ? this.createEquivalentWithWildcards(rawType, this.isProcedure()) : this.createEquivalentWithoutWildcards(rawType, this.isProcedure());
                boolean wasDeliver = this.eDeliver();
                try {
                    this.eSetDeliver(false);
                    this.setEquivalent((JvmTypeReference)result);
                }
                finally {
                    this.eSetDeliver(wasDeliver);
                }
            } else {
                this.equivalent = null;
            }
        }
        return this.equivalent;
    }

    protected JvmParameterizedTypeReference createEquivalentWithoutWildcards(JvmType rawType, boolean procedure) {
        TypesFactory typesFactory = TypesFactory.eINSTANCE;
        JvmParameterizedTypeReference result = typesFactory.createJvmParameterizedTypeReference();
        result.setType(rawType);
        for (JvmTypeReference paramType : Lists.newArrayList(this.getParamTypes())) {
            JvmTypeReference wrapped = this.wrapIfNecessary(paramType);
            if (wrapped == null || wrapped.eContainer() != null) {
                JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
                delegate.setDelegate(wrapped);
                result.getArguments().add((Object)delegate);
                continue;
            }
            result.getArguments().add((Object)wrapped);
        }
        if (!procedure) {
            JvmTypeReference wrapped;
            JvmTypeReference jvmTypeReference = wrapped = procedure ? this.getReturnType() : this.wrapIfNecessary(this.getReturnType());
            if (wrapped == null || wrapped.eContainer() != null) {
                JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
                delegate.setDelegate(wrapped);
                result.getArguments().add((Object)delegate);
            } else {
                result.getArguments().add((Object)wrapped);
            }
        }
        return result;
    }

    protected JvmParameterizedTypeReference createEquivalentWithWildcards(JvmType rawType, boolean procedure) {
        TypesFactory typesFactory = TypesFactory.eINSTANCE;
        JvmParameterizedTypeReference result = typesFactory.createJvmParameterizedTypeReference();
        result.setType(rawType);
        for (JvmTypeReference paramType : Lists.newArrayList(this.getParamTypes())) {
            if (!(paramType instanceof JvmWildcardTypeReference)) {
                JvmWildcardTypeReference paramWildcard = typesFactory.createJvmWildcardTypeReference();
                JvmLowerBound lowerBound = typesFactory.createJvmLowerBound();
                JvmTypeReference wrapped = this.wrapIfNecessary(paramType);
                if (wrapped == null || wrapped.eContainer() != null) {
                    JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
                    delegate.setDelegate(wrapped);
                    lowerBound.setTypeReference((JvmTypeReference)delegate);
                } else {
                    lowerBound.setTypeReference(wrapped);
                }
                JvmUpperBound upperBound = typesFactory.createJvmUpperBound();
                JvmTypeReference objectReference = this.getJavaLangObjectTypeRef(rawType, typesFactory);
                upperBound.setTypeReference(objectReference);
                paramWildcard.getConstraints().add((Object)upperBound);
                paramWildcard.getConstraints().add((Object)lowerBound);
                result.getArguments().add((Object)paramWildcard);
                continue;
            }
            JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
            delegate.setDelegate(paramType);
            result.getArguments().add((Object)delegate);
        }
        if (!procedure) {
            if (!(this.returnType instanceof JvmWildcardTypeReference)) {
                JvmTypeReference wrapped;
                JvmWildcardTypeReference returnType = typesFactory.createJvmWildcardTypeReference();
                JvmUpperBound returnTypeBound = typesFactory.createJvmUpperBound();
                JvmTypeReference jvmTypeReference = wrapped = procedure ? this.getReturnType() : this.wrapIfNecessary(this.getReturnType());
                if (wrapped == null || wrapped.eContainer() != null) {
                    JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
                    delegate.setDelegate(wrapped);
                    returnTypeBound.setTypeReference((JvmTypeReference)delegate);
                } else {
                    returnTypeBound.setTypeReference(wrapped);
                }
                returnType.getConstraints().add((Object)returnTypeBound);
                result.getArguments().add((Object)returnType);
            } else {
                JvmDelegateTypeReference delegate = typesFactory.createJvmDelegateTypeReference();
                delegate.setDelegate(this.returnType);
                result.getArguments().add((Object)delegate);
            }
        }
        return result;
    }

    protected JvmTypeReference getJavaLangObjectTypeRef(JvmType rawType, TypesFactory typesFactory) {
        EObject javaLangObject;
        ResourceSet rs = EcoreUtil2.getResourceSet((Notifier)rawType);
        JvmParameterizedTypeReference refToObject = typesFactory.createJvmParameterizedTypeReference();
        if (rs != null && (javaLangObject = rs.getEObject(javaLangObjectURI, true)) instanceof JvmType) {
            JvmType objectDeclaration = (JvmType)javaLangObject;
            refToObject.setType(objectDeclaration);
            return refToObject;
        }
        JvmGenericType proxy = typesFactory.createJvmGenericType();
        ((InternalEObject)proxy).eSetProxyURI(javaLangObjectURI);
        refToObject.setType((JvmType)proxy);
        return refToObject;
    }

    public JvmTypeReference wrapIfNecessary(JvmTypeReference reference) {
        if (reference == null) {
            return null;
        }
        JvmType type = reference.getType();
        if (type instanceof JvmPrimitiveType) {
            JvmType wrappedType = null;
            String name = type.getIdentifier();
            if ("int".equals(name)) {
                wrappedType = this.getType(Integer.class, (EObject)type);
            } else if ("boolean".equals(name)) {
                wrappedType = this.getType(Boolean.class, (EObject)type);
            } else if ("char".equals(name)) {
                wrappedType = this.getType(Character.class, (EObject)type);
            } else if ("long".equals(name)) {
                wrappedType = this.getType(Long.class, (EObject)type);
            } else if ("double".equals(name)) {
                wrappedType = this.getType(Double.class, (EObject)type);
            } else if ("byte".equals(name)) {
                wrappedType = this.getType(Byte.class, (EObject)type);
            } else if ("float".equals(name)) {
                wrappedType = this.getType(Float.class, (EObject)type);
            } else if ("short".equals(name)) {
                wrappedType = this.getType(Short.class, (EObject)type);
            }
            if (wrappedType == null) {
                return reference;
            }
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            result.setType(wrappedType);
            return result;
        }
        if (type instanceof JvmVoid && !type.eIsProxy()) {
            JvmParameterizedTypeReference result = TypesFactory.eINSTANCE.createJvmParameterizedTypeReference();
            JvmType wrappedType = this.getType(Void.class, (EObject)type);
            result.setType(wrappedType);
            return result;
        }
        return reference;
    }

    protected JvmType getType(Class<?> clazz, EObject context) {
        InternalEObject proxy = (InternalEObject)TypesFactory.eINSTANCE.createJvmVoid();
        proxy.eSetProxyURI(this.computeTypeUri(clazz));
        return (JvmType)EcoreUtil.resolve((EObject)proxy, (EObject)context);
    }

    protected URI computeTypeUri(boolean procedure) {
        int paramCount = Math.min(6, this.getParamTypes().size());
        if (procedure) {
            return URI.createURI((String)("java:/Objects/" + Procedures.class.getCanonicalName() + "#" + Procedures.class.getCanonicalName() + "$Procedure" + paramCount));
        }
        return URI.createURI((String)("java:/Objects/" + Functions.class.getCanonicalName() + "#" + Functions.class.getCanonicalName() + "$Function" + paramCount));
    }

    protected URI computeTypeUri(Class<?> topLevelClass) {
        return URI.createURI((String)("java:/Objects/" + topLevelClass.getCanonicalName() + "#" + topLevelClass.getCanonicalName()));
    }

    public String getIdentifier() {
        StringBuilder result = new StringBuilder("(");
        int i = 0;
        while (i < this.getParamTypes().size()) {
            JvmTypeReference reference = (JvmTypeReference)this.getParamTypes().get(i);
            result.append(reference.getIdentifier());
            if (i < this.getParamTypes().size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")=>");
        if (this.getReturnType() != null) {
            result.append(this.getReturnType().getIdentifier());
        }
        return result.toString();
    }

    public String getQualifiedName(char innerClassDelimiter) {
        StringBuilder result = new StringBuilder("(");
        int i = 0;
        while (i < this.getParamTypes().size()) {
            JvmTypeReference reference = (JvmTypeReference)this.getParamTypes().get(i);
            result.append(reference.getQualifiedName(innerClassDelimiter));
            if (i < this.getParamTypes().size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")=>");
        if (this.getReturnType() != null) {
            result.append(this.getReturnType().getQualifiedName(innerClassDelimiter));
        }
        return result.toString();
    }

    public String getSimpleName() {
        StringBuilder result = new StringBuilder("(");
        int i = 0;
        while (i < this.getParamTypes().size()) {
            JvmTypeReference reference = (JvmTypeReference)this.getParamTypes().get(i);
            result.append(reference.getSimpleName());
            if (i < this.getParamTypes().size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")=>");
        if (this.getReturnType() != null) {
            result.append(this.getReturnType().getSimpleName());
        }
        return result.toString();
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.eClass().getName());
        result.append(": (");
        int i = 0;
        while (i < this.getParamTypes().size()) {
            JvmTypeReference reference = (JvmTypeReference)this.getParamTypes().get(i);
            result.append(reference.toString());
            if (i < this.getParamTypes().size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(")=>");
        if (this.getReturnType() != null) {
            result.append(this.getReturnType().toString());
        }
        return result.toString();
    }
}

