/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.typing.ITypeProvider;
import org.eclipse.xtext.xbase.ui.labeling.XbaseImages;
import org.eclipse.xtext.xbase.validation.UIStrings;

public class XbaseLabelProvider
extends DefaultEObjectLabelProvider {
    @Inject
    private XbaseImages images;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private ITypeProvider typeProvider;

    @Inject
    public XbaseLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
    }

    public Image image(JvmGenericType genericType) {
        return this.images.forClass(genericType.getVisibility());
    }

    public String test(JvmGenericType genericType) {
        return genericType.getSimpleName();
    }

    public Image image(JvmOperation element) {
        return this.images.forOperation(element.getVisibility(), element.isStatic());
    }

    public Object text(JvmOperation element) {
        return this.signature(element.getSimpleName(), (JvmIdentifiableElement)element);
    }

    public Image image(JvmConstructor element) {
        return this.images.forConstructor(element.getVisibility());
    }

    public String text(JvmConstructor element) {
        return "new" + this.uiStrings.parameters((JvmIdentifiableElement)element);
    }

    public Image image(JvmField element) {
        return this.images.forField(element.getVisibility(), element.isStatic(), false);
    }

    public String text(JvmField element) {
        return String.valueOf(element.getSimpleName()) + " : " + element.getType().getSimpleName();
    }

    public Image image(JvmFormalParameter parameter) {
        return this.images.forLacalVariable();
    }

    public String text(JvmFormalParameter parameter) {
        JvmTypeReference parameterType = parameter.getParameterType();
        String result = parameter.getName();
        if (parameterType != null) {
            result = String.valueOf(parameterType.getSimpleName()) + " " + result;
        }
        return result;
    }

    public Image image(XVariableDeclaration variableDeclaration) {
        return this.images.forLacalVariable();
    }

    public Image image(JvmTypeParameter parameter) {
        return this.images.forTypeParameter();
    }

    public String text(XVariableDeclaration variableDeclaration) {
        JvmTypeReference type = this.typeProvider.getTypeForIdentifiable((JvmIdentifiableElement)variableDeclaration);
        String result = variableDeclaration.getName();
        if (type != null) {
            result = String.valueOf(type.getSimpleName()) + " " + result;
        }
        return result;
    }

    public String text(XCasePart casePart) {
        XSwitchExpression switchExpression;
        if (casePart.eContainer() instanceof XSwitchExpression && (switchExpression = (XSwitchExpression)casePart.eContainer()) != null) {
            XAbstractFeatureCall call;
            if (switchExpression.getLocalVarName() != null) {
                return switchExpression.getLocalVarName();
            }
            if (switchExpression.getSwitch() instanceof XAbstractFeatureCall && (call = (XAbstractFeatureCall)switchExpression.getSwitch()).getFeature() != null) {
                return call.getFeature().getSimpleName();
            }
        }
        return null;
    }

    protected StyledString signature(String simpleName, JvmIdentifiableElement element) {
        JvmTypeReference returnType = this.typeProvider.getTypeForIdentifiable(element);
        String returnTypeString = "void";
        if (returnType != null) {
            returnTypeString = returnType instanceof JvmAnyTypeReference ? "Object" : this.uiStrings.referenceToString(returnType, "Object");
        }
        return new StyledString(String.valueOf(simpleName) + this.uiStrings.parameters(element)).append(new StyledString(" : " + returnTypeString, StyledString.DECORATIONS_STYLER));
    }
}

