/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.predicate.IdentifiablePredicateExpression;
import org.eclipse.stem.core.predicate.PredicateFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewPredicateWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NPredicateWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.setHelpContextId("org.eclipse.stem.doc.newpredicate_contextid");
        return new NewPredicatePage();
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/predicate.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.PREDICATE_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_pred"));
                this.source.setText(Messages.getString("dc_source_pred"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_pred"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        IdentifiablePredicateExpression retValue = PredicateFactory.eINSTANCE.createIdentifiablePredicateExpression();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "predicates";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "predicate";
    }

    protected static class NewPredicatePage
    extends NewIdentifiablePage {
        protected NewPredicatePage() {
            super(Messages.getString("NPredicateWiz.page_title"));
            this.setTitle(Messages.getString("NPredicateWiz.page_title"));
            this.setDescription(Messages.getString("NPredicateWiz.page_description"));
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newpredicate_contextid");
            return new Composite(parent, 0);
        }
    }

    public static class NewPredicateWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewPredicateWizard wizard = new NewPredicateWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

