/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.xtext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.ctdl.ContextSensitiveResourceWrapper;
import org.eclipse.stem.model.ctdl.ctdl.CompartmentTransitionDefinitions;
import org.eclipse.stem.model.ctdl.ctdl.CtdlFactory;
import org.eclipse.stem.model.ctdl.ctdl.ExternalFunctionReference;
import org.eclipse.stem.model.ctdl.ctdl.FunctionCall;
import org.eclipse.stem.model.ctdl.ctdl.MetamodelResource;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.Transition;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class XtextUtils {
    public static boolean isNullOrEmpty(String s) {
        return s == null || "".equals(s.trim());
    }

    public static Set<String> getContributingPluginsForMetamodel(Package metamodel) {
        HashSet<String> plugins = new HashSet<String>();
        for (Model model : metamodel.getModels()) {
            List<XtextResource> resources = XtextUtils.getXtextResourcesForModel(model);
            for (XtextResource resource : resources) {
                plugins.addAll(XtextUtils.getContributingPluginsForExpression(resource));
            }
        }
        return plugins;
    }

    public static Set<String> getContributingPluginsForExpression(XtextResource resource) {
        HashSet<String> plugins = new HashSet<String>();
        TreeIterator iter = resource.getAllContents();
        while (iter.hasNext()) {
            ExternalFunctionReference ref;
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof FunctionCall) || !(((FunctionCall)obj).getRef() instanceof ExternalFunctionReference) || (ref = (ExternalFunctionReference)((FunctionCall)obj).getRef()).getFunc() == null) continue;
            plugins.add(ref.getFunc().getContributingPlugin());
        }
        return plugins;
    }

    public static List<XtextResource> getXtextResourcesForModel(Model model) {
        ArrayList<XtextResource> resources = new ArrayList<XtextResource>(model.getTransitions().size());
        for (Transition transition : model.getTransitions()) {
            XtextResource resource = XtextUtils.loadAndResolveXtextResourceForTransition(transition);
            if (resource == null) continue;
            resources.add(resource);
        }
        return resources;
    }

    public static XtextResource loadAndResolveXtextResourceForTransition(Transition transition) {
        if (transition == null || XtextUtils.isNullOrEmpty(transition.getExpression())) {
            return null;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"empty.sctd"));
        resourceSet.getResources().add((Object)resource);
        StringInputStream is = new StringInputStream(transition.getExpression());
        try {
            try {
                resource.load((InputStream)is, Collections.emptyMap());
            }
            catch (IOException e) {
                e.printStackTrace();
                GeneratorUtils.safeClose((InputStream)is);
                return null;
            }
        }
        finally {
            GeneratorUtils.safeClose((InputStream)is);
        }
        if (resource instanceof ContextSensitiveResourceWrapper) {
            ((ContextSensitiveResourceWrapper)resource).setTransition(transition);
        }
        EcoreUtil2.resolveLazyCrossReferences((Resource)resource, (CancelIndicator)new CancelIndicator(){

            public boolean isCanceled() {
                return false;
            }
        });
        if (resource.getContents().size() > 0 && resource.getContents().get(0) instanceof CompartmentTransitionDefinitions) {
            CompartmentTransitionDefinitions ctd = (CompartmentTransitionDefinitions)resource.getContents().get(0);
            MetamodelResource mmrs = CtdlFactory.eINSTANCE.createMetamodelResource();
            mmrs.setTransition(transition);
            mmrs.setModel(transition.getContainerModel());
            ctd.setMetamodel(mmrs);
        }
        transition.setExpressionResource((Resource)resource);
        return resource;
    }
}

