/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.functions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.interventions.InterventionLabelValue;
import org.eclipse.stem.interventions.StandardInterventionLabel;
import org.eclipse.stem.interventions.StandardInterventionLabelValue;
import org.eclipse.stem.interventions.StandardPeriodicInterventionLabelValue;

public class CTDLFunctions {
    public static double vaccinations(Node node, Label label, LabelValue diseaseLabelValue, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInteventionResult(node, (StandardDiseaseModelLabel)label, (StandardDiseaseModelLabelValue)diseaseLabelValue, time, timeDelta, t, true);
    }

    public static double isolations(Node node, Label label, LabelValue diseaseLabelValue, STEMTime time, long timeDelta, double t) {
        return CTDLFunctions.getInteventionResult(node, (StandardDiseaseModelLabel)label, (StandardDiseaseModelLabelValue)diseaseLabelValue, time, timeDelta, t, false);
    }

    private static double getInteventionResult(Node node, StandardDiseaseModelLabel label, StandardDiseaseModelLabelValue diseaseLabelValue, STEMTime time, long timeDelta, double t, boolean vaccinations) {
        EList labels = node.getLabels();
        int i = 0;
        while (i < labels.size()) {
            StandardInterventionLabel iLab;
            NodeLabel lab = (NodeLabel)labels.get(i);
            if (lab instanceof StandardInterventionLabel && (iLab = (StandardInterventionLabel)lab).getPopulationIdentifier().equals(label.getPopulationModelLabel().getPopulationIdentifier())) {
                InterventionLabelValue iLabVal = (InterventionLabelValue)iLab.getCurrentValue();
                if (iLabVal instanceof StandardInterventionLabelValue) {
                    if (vaccinations) {
                        return ((StandardInterventionLabelValue)iLabVal).getVaccinations();
                    }
                    return ((StandardInterventionLabelValue)iLabVal).getIsolations();
                }
                if (iLabVal instanceof StandardPeriodicInterventionLabelValue) {
                    StandardPeriodicInterventionLabelValue spilv = (StandardPeriodicInterventionLabelValue)iLabVal;
                    EList data = null;
                    data = vaccinations ? spilv.getVaccinations() : spilv.getIsolations();
                    return CTDLFunctions.interpolateOrAggregateResults((EList<Double>)data, spilv, label, diseaseLabelValue, t, timeDelta, spilv.getPeriod());
                }
            }
            ++i;
        }
        return 0.0;
    }

    private static double interpolateOrAggregateResults(EList<Double> data, StandardPeriodicInterventionLabelValue spilv, StandardDiseaseModelLabel label, StandardDiseaseModelLabelValue diseaseLabelValue, double t, long timeDelta, long period) {
        if (timeDelta > period) {
            double dataItemsPerTimeStep = (double)timeDelta / (double)period;
            int pos = (int)t;
            double fraction = t - (double)pos;
            int ipos = pos % data.size();
            double d1 = (Double)data.get(ipos);
            double d = d1 * (1.0 - fraction);
            double end_t = t + dataItemsPerTimeStep;
            int end_pos = (int)end_t;
            double end_fraction = end_t - (double)end_pos;
            int i = ipos + 1;
            while (i < end_pos) {
                d = i < data.size() ? (d += ((Double)data.get(i)).doubleValue()) : (d += ((Double)data.get(i - data.size())).doubleValue());
                ++i;
            }
            end_pos = end_pos >= data.size() ? 0 : end_pos;
            double d2 = (Double)data.get(end_pos) * end_fraction;
            return d += d2;
        }
        double simulationStepsPerDataFileStep = (double)period / (double)timeDelta;
        double preciseDataFilePos = t / simulationStepsPerDataFileStep;
        int dataFilePos = (int)preciseDataFilePos;
        if (dataFilePos >= data.size()) {
            dataFilePos %= data.size();
        }
        double num = (Double)data.get(dataFilePos);
        if (!spilv.isAbsolute()) {
            num *= diseaseLabelValue.getPopulationCount();
        }
        return num / simulationStepsPerDataFileStep;
    }

    public static double computeEffective(EAttribute infectiousAttribute, IntegrationDecorator decorator, Node node, Label label) {
        if (!(decorator instanceof StandardDiseaseModel)) {
            return 0.0;
        }
        StandardDiseaseModel disease = (StandardDiseaseModel)decorator;
        return CTDLFunctions.computeEffective(infectiousAttribute, disease.getCharacteristicMixingDistance(), disease.getRoadNetworkInfectiousProportion(), disease, node, label);
    }

    public static double computeEffective(EAttribute infectiousAttribute, double mixingParam, double roadParam, IntegrationDecorator decorator, Node node, Label label) {
        if (!(decorator instanceof StandardDiseaseModel) || !(label instanceof IntegrationLabel)) {
            return 0.0;
        }
        StandardDiseaseModel disease = (StandardDiseaseModel)decorator;
        IntegrationLabel diseaseLabel = (IntegrationLabel)label;
        double onsiteInfectious = diseaseLabel.getProbeValue().eGetDouble(infectiousAttribute.getFeatureID());
        if (mixingParam == 0.0 && roadParam == 0.0) {
            double totalPopulation = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount();
            double retVal = 0.0;
            if (totalPopulation > 0.0) {
                retVal = onsiteInfectious / totalPopulation;
            }
            return retVal;
        }
        double infectiousChangeFromMixing = 0.0;
        double populationChangeFromMixing = 0.0;
        ArrayList cEdges = new ArrayList();
        CommonBorderRelationshipLabelImpl.getCommonBorderEdgesFromNode((Node)node, cEdges);
        int i = 0;
        while (i < cEdges.size()) {
            Edge borderEdge = (Edge)cEdges.get(i);
            Node otherNode = borderEdge.getOtherNode(node);
            double borderLength = ((CommonBorderRelationshipLabelValue)borderEdge.getLabel().getCurrentValue()).getBorderLength();
            if (otherNode instanceof Region) {
                double otherArea = 0.0;
                double otherPopulation = 0.0;
                double otherInfective = 0.0;
                EList labs = otherNode.getLabels();
                int j = 0;
                while (j < labs.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    NodeLabel otherLabel = (NodeLabel)labs.get(j);
                    if (otherLabel instanceof AreaLabel) {
                        otherArea = ((AreaLabel)otherLabel).getCurrentAreaValue().getArea();
                    } else if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == disease && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                        otherPopulation = ((StandardDiseaseModelLabelValue)otherDiseaseLabel.getTempValue()).getPopulationCount();
                        otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                    }
                    ++j;
                }
                double mixingFactor = Math.min(mixingParam * borderLength / otherArea, 1.0);
                if (otherArea == 0.0) {
                    mixingFactor = 0.0;
                }
                infectiousChangeFromMixing += mixingFactor * otherInfective;
                populationChangeFromMixing += mixingFactor * otherPopulation;
            }
            ++i;
        }
        ArrayList rEdges = new ArrayList();
        RoadTransportRelationshipLabelImpl.getRoadEdgesFromNode((Node)node, rEdges);
        int i2 = 0;
        while (i2 < rEdges.size()) {
            Edge roadEdge = (Edge)rEdges.get(i2);
            EdgeLabel edgeLabel = roadEdge.getLabel();
            double numCrossings = ((RoadTransportRelationshipLabelValue)edgeLabel.getCurrentValue()).getNumberCrossings();
            double infectiousProportion = Math.min(roadParam * numCrossings, 1.0);
            Node otherNode = roadEdge.getOtherNode(node);
            double otherPopulation = 0.0;
            double otherInfective = 0.0;
            EList labs = otherNode.getLabels();
            int j = 0;
            while (j < labs.size()) {
                StandardDiseaseModelLabel otherDiseaseLabel;
                NodeLabel otherLabel = (NodeLabel)labs.get(j);
                if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == disease && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                    otherPopulation = ((StandardDiseaseModelLabelValue)otherDiseaseLabel.getTempValue()).getPopulationCount();
                    otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                }
                ++j;
            }
            infectiousChangeFromMixing += infectiousProportion * otherInfective;
            populationChangeFromMixing += infectiousProportion * otherPopulation;
            ++i2;
        }
        double totalPopulation = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount() + populationChangeFromMixing;
        double retVal = 0.0;
        if (totalPopulation > 0.0) {
            retVal = (onsiteInfectious + infectiousChangeFromMixing) / totalPopulation;
        }
        return retVal;
    }
}

