/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.logger.Logger;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.LoggerDefinitionControl;
import org.eclipse.stem.ui.wizards.LoggerWizardMessages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewLoggerWizard
extends NewIdentifiableWizard {
    private NewLoggerPage nlp = null;

    protected String getWizardTitle() {
        return LoggerWizardMessages.getString("NLW_Title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.nlp = new NewLoggerPage(LoggerWizardMessages.getString("NLW_PageTitle"), this);
        this.nlp.setTitle(LoggerWizardMessages.getString("NLW_PageTitle"));
        this.nlp.setDescription(LoggerWizardMessages.getString("NLW_PageDescription"));
        return this.nlp;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http://org/eclipse/stem/core/logger");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.LOGGER_TYPE_URI.toString());
                this.type.setEnabled(false);
                Logger logger = NewLoggerWizard.this.nlp.getSelectedLogger();
                DublinCore plugginDublinCore = logger.getDublinCore();
                this.updateDublinCorePage(plugginDublinCore);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Logger retValue = this.nlp.getSelectedLogger();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    protected String getSerializationFolderName() {
        return "loggers";
    }

    protected String getSerializationFileNameExtension() {
        return "logger";
    }

    protected static class NewLoggerPage
    extends NewIdentifiablePage {
        LoggerDefinitionControl ldc = null;
        NewLoggerWizard parentWizard = null;

        protected NewLoggerPage(String pageName, NewLoggerWizard newLoggerWizard) {
            super(pageName);
            this.parentWizard = newLoggerWizard;
        }

        protected Composite createSpecificComposite(Composite parent) {
            this.ldc = new LoggerDefinitionControl(parent, 0, this.projectValidator, this.getSelectedProject(), this.parentWizard);
            return this.ldc;
        }

        protected boolean validatePage() {
            boolean retValue = super.validatePage();
            if (retValue) {
                this.setErrorMessage(null);
                retValue = this.ldc.validate();
                if (!retValue) {
                    this.setErrorMessage(this.ldc.getErrorMessage());
                }
            }
            return retValue;
        }

        Logger getSelectedLogger() {
            return this.ldc.getSelectedLogger();
        }
    }

    public static class NewLoggerWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewLoggerWizard wizard = new NewLoggerWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

