/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.views.GEViewLabelProvider;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class GEViewContentProvider
implements IStructuredContentProvider,
ISimulationManagerListener,
ISelectionChangedListener,
ISelectionListener {
    private ListViewer viewer;
    private ISimulation currentSimulation = null;
    private SimulationManager simulationManager = null;
    private GEInterface gei = null;

    public GEViewContentProvider(GEInterface gei) {
        this.gei = gei;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        GELog.debug(this, "inputChanged: old=" + oldInput + " new=" + newInput);
        this.viewer = (ListViewer)v;
        if (oldInput != null) {
            ((SimulationManager)oldInput).removeListener((ISimulationManagerListener)this);
        }
        this.simulationManager = (SimulationManager)newInput;
        if (this.simulationManager != null) {
            this.simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void dispose() {
        GELog.debug(this.getClass(), "dispose(): ");
        if (this.simulationManager != null) {
            this.simulationManager.removeListener((ISimulationManagerListener)this);
        }
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public Object[] getElements(Object parent) {
        SimulationManager sm = (SimulationManager)parent;
        List simulations = sm.getActiveSimulations();
        int n = simulations.size();
        Object[] returnArray = new Object[n];
        int i = 0;
        while (i < n) {
            ISimulation simulation = (ISimulation)simulations.get(i);
            returnArray[i] = simulation;
            ++i;
        }
        if (n == 1 && this.currentSimulation == null) {
            this.currentSimulation = (ISimulation)simulations.get(0);
        }
        return returnArray;
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        GELog.debug(this.getClass(), "simulationsChange: ");
        this.viewer.remove((Object[])event.getSimulationsRemoved());
        this.viewer.add((Object[])event.getSimulationsAdded());
        if (this.currentSimulation == null && event.getSimulationsAdded().length > 0) {
            this.currentSimulation = event.getSimulationsAdded()[0];
            GELog.debug(this, "currentSimulation: " + this.currentSimulation.getName());
        }
        if (this.currentSimulation != null && event.getSimulationsRemoved().length > 0) {
            ISimulation[] iSimulationArray = event.getSimulationsRemoved();
            int n = iSimulationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISimulation sim = iSimulationArray[n2];
                if (this.currentSimulation == sim) {
                    this.currentSimulation = null;
                    GELog.debug(this, "currentSimulation is now null ");
                }
                ++n2;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection select) {
        if (!(select instanceof StructuredSelection)) {
            return;
        }
        Object[] elements = ((StructuredSelection)select).toArray();
        if (elements.length != 2 || !(elements[1] instanceof GeographicSelectionElements)) {
            return;
        }
        RegionImpl region = (RegionImpl)elements[0];
        GeographicSelectionElements gse = (GeographicSelectionElements)elements[1];
        GELog.debug(this, "MapView Selection: " + region);
        this.gei.displaySelection(region, gse);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        GELog.debug(this, "selectionChange: " + event);
        if (event.getSource() == this.viewer) {
            ISelection selection = event.getSelection();
            ArrayList<ISimulation> temp = new ArrayList<ISimulation>();
            if (event.getSelection() instanceof IStructuredSelection) {
                List list = ((IStructuredSelection)selection).toList();
                for (Object obj : list) {
                    if (!(obj instanceof ISimulation)) continue;
                    temp.add((ISimulation)obj);
                }
            }
            if (temp.size() > 0) {
                this.currentSimulation = (ISimulation)temp.get(0);
                GEViewLabelProvider lp = (GEViewLabelProvider)this.viewer.getLabelProvider();
                lp.setSelected(this.currentSimulation);
            }
        }
    }

    public ISimulation getCurrentSimulation() {
        return this.currentSimulation;
    }
}

