/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;

public class LyapunovAnalysis {
    Map<String, List<PhaseSpaceCoordinate>> commonPhaseSpaceA = new HashMap<String, List<PhaseSpaceCoordinate>>();
    Map<String, List<PhaseSpaceCoordinate>> commonPhaseSpaceB = new HashMap<String, List<PhaseSpaceCoordinate>>();
    Map<String, List<Double>> totalPopulation = new HashMap<String, List<Double>>();
    public double[] locationCount;
    public PhaseSpaceCoordinate[] trajectoryA;
    public PhaseSpaceCoordinate[] trajectoryB;
    public double[] time;

    public LyapunovAnalysis(ReferenceScenarioDataMapImpl scenarioMapA, ReferenceScenarioDataMapImpl scenarioMapB, IRunnableContext runnableContext) {
        final ReferenceScenarioDataMapImpl mapA = scenarioMapA;
        final ReferenceScenarioDataMapImpl mapB = scenarioMapB;
        IRunnableWithProgress task = new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) {
                progress.beginTask("Calculating common locations...", mapA.getNumLocations());
                Iterator iteratorA = mapA.getLocations().iterator();
                int maxTime = -1;
                while (iteratorA.hasNext()) {
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    String id = (String)iteratorA.next();
                    if (!mapB.containsLocation(id)) continue;
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapA = mapA.getLocation(id);
                    List<PhaseSpaceCoordinate> aData = LyapunovAnalysis.this.getNormalizedTrajectory(dataMapA);
                    LyapunovAnalysis.this.commonPhaseSpaceA.put(id, aData);
                    LyapunovAnalysis.this.totalPopulation.put(id, LyapunovAnalysis.this.getTotalPopulation(dataMapA));
                    ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMapB = mapB.getLocation(id);
                    List<PhaseSpaceCoordinate> bData = LyapunovAnalysis.this.getNormalizedTrajectory(dataMapB);
                    LyapunovAnalysis.this.commonPhaseSpaceB.put(id, bData);
                    if (maxTime == -1) {
                        maxTime = aData.size();
                    }
                    if (aData.size() < maxTime) {
                        maxTime = aData.size();
                    }
                    if (bData.size() >= maxTime) continue;
                    maxTime = bData.size();
                }
                progress.done();
                if (LyapunovAnalysis.this.time == null) {
                    LyapunovAnalysis.this.time = new double[maxTime];
                    LyapunovAnalysis.this.trajectoryA = new PhaseSpaceCoordinate[maxTime];
                    LyapunovAnalysis.this.trajectoryB = new PhaseSpaceCoordinate[maxTime];
                    LyapunovAnalysis.this.locationCount = new double[maxTime];
                    int i = 0;
                    while (i < maxTime) {
                        LyapunovAnalysis.this.time[i] = i;
                        LyapunovAnalysis.this.trajectoryA[i] = new PhaseSpaceCoordinate(0.0, 0.0);
                        LyapunovAnalysis.this.trajectoryB[i] = new PhaseSpaceCoordinate(0.0, 0.0);
                        LyapunovAnalysis.this.locationCount[i] = 0.0;
                        ++i;
                    }
                }
            }
        };
        try {
            runnableContext.run(true, false, task);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        catch (InvocationTargetException ive) {
            ive.printStackTrace();
        }
    }

    public List<PhaseSpaceCoordinate> getNormalizedTrajectory(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List exposedList = dataMap.getEtotals();
        List recoveredList = dataMap.getRtotals();
        List infectiousList = dataMap.getItotals();
        List susceptibleList = dataMap.getStotals();
        assert (infectiousList != null);
        assert (susceptibleList != null);
        ArrayList<PhaseSpaceCoordinate> normalizedTrajectory = new ArrayList<PhaseSpaceCoordinate>();
        double[] totalPop = new double[infectiousList.size()];
        int i = 0;
        while (i < infectiousList.size()) {
            double inf = (Double)infectiousList.get(i);
            double susc = (Double)susceptibleList.get(i);
            double exposed = 0.0;
            double recovered = 0.0;
            if (exposedList != null && exposedList.size() > 0) {
                exposed = (Double)exposedList.get(i);
            }
            if (recoveredList != null && recoveredList.size() > 0) {
                recovered = (Double)recoveredList.get(i);
            }
            totalPop[i] = inf + susc + exposed + recovered;
            PhaseSpaceCoordinate point = new PhaseSpaceCoordinate(susc /= totalPop[i], inf /= totalPop[i]);
            normalizedTrajectory.add(point);
            ++i;
        }
        return normalizedTrajectory;
    }

    public List<Double> getTotalPopulation(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List exposedList = dataMap.getEtotals();
        List recoveredList = dataMap.getRtotals();
        List infectiousList = dataMap.getItotals();
        List susceptibleList = dataMap.getStotals();
        assert (infectiousList != null);
        assert (susceptibleList != null);
        ArrayList<Double> population = new ArrayList<Double>();
        int i = 0;
        while (i < infectiousList.size()) {
            double totalPop = 0.0;
            double inf = (Double)infectiousList.get(i);
            double susc = (Double)susceptibleList.get(i);
            double exposed = 0.0;
            double recovered = 0.0;
            if (exposedList != null && exposedList.size() > 0) {
                exposed = (Double)exposedList.get(i);
            }
            if (recoveredList != null && recoveredList.size() > 0) {
                recovered = (Double)recoveredList.get(i);
            }
            totalPop = inf + susc + exposed + recovered;
            population.add(new Double(totalPop));
            ++i;
        }
        return population;
    }

    public List<PhaseSpaceCoordinate[]> getLyapunovTrajectory(IRunnableContext runnableContext) {
        final ArrayList<PhaseSpaceCoordinate[]> retVal = new ArrayList<PhaseSpaceCoordinate[]>();
        IRunnableWithProgress task = new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) {
                progress.beginTask("Getting Lyapunov trajectory", LyapunovAnalysis.this.time.length);
                double[] maxPopulation = new double[LyapunovAnalysis.this.time.length];
                int icount = 0;
                while (icount < LyapunovAnalysis.this.time.length) {
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    maxPopulation[icount] = 0.0;
                    for (String id : LyapunovAnalysis.this.commonPhaseSpaceA.keySet()) {
                        List<PhaseSpaceCoordinate> aData = LyapunovAnalysis.this.commonPhaseSpaceA.get(id);
                        List<PhaseSpaceCoordinate> bData = LyapunovAnalysis.this.commonPhaseSpaceB.get(id);
                        List<Double> population = LyapunovAnalysis.this.totalPopulation.get(id);
                        double iA = aData.get(icount).getYValue();
                        double iB = bData.get(icount).getYValue();
                        double sA = aData.get(icount).getXValue();
                        double sB = bData.get(icount).getXValue();
                        double pop = population.get(icount);
                        if (!(iA > 0.0) && !(iB > 0.0)) continue;
                        int n = icount;
                        LyapunovAnalysis.this.locationCount[n] = LyapunovAnalysis.this.locationCount[n] + 1.0;
                        int n2 = icount;
                        maxPopulation[n2] = maxPopulation[n2] + pop;
                        LyapunovAnalysis.this.trajectoryA[icount].integratePath(sA * pop, iA * pop);
                        LyapunovAnalysis.this.trajectoryB[icount].integratePath(sB * pop, iB * pop);
                    }
                    if (LyapunovAnalysis.this.locationCount[icount] >= 1.0) {
                        LyapunovAnalysis.this.trajectoryA[icount].normalize(maxPopulation[icount]);
                        LyapunovAnalysis.this.trajectoryB[icount].normalize(maxPopulation[icount]);
                    }
                    ++icount;
                }
                retVal.add(LyapunovAnalysis.this.trajectoryA);
                retVal.add(LyapunovAnalysis.this.trajectoryB);
                progress.done();
            }
        };
        try {
            runnableContext.run(true, true, task);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
        return retVal;
    }

    public static List<EList<Double>> getCumulativePhaseSpaceDeviation(List<PhaseSpaceCoordinate[]> trajectoryList) {
        int refSize;
        ArrayList<EList<Double>> deviationList = new ArrayList<EList<Double>>();
        PhaseSpaceCoordinate[] referenceTrajectory = trajectoryList.get(0);
        int showSize = refSize = referenceTrajectory.length;
        if (trajectoryList.size() >= 2) {
            int i = 1;
            while (i < trajectoryList.size()) {
                PhaseSpaceCoordinate[] comparisonTrajectory = trajectoryList.get(i);
                int dataSize = comparisonTrajectory.length;
                if (dataSize < refSize) {
                    showSize = dataSize;
                }
                BasicEList deviation = new BasicEList(showSize);
                int j = 0;
                while (j < showSize) {
                    deviation.add(j, (Object)0.0);
                    PhaseSpaceCoordinate ref = referenceTrajectory[j];
                    PhaseSpaceCoordinate comp = comparisonTrajectory[j];
                    deviation.set(j, (Object)((Double)deviation.get(j) + ref.getDistance(comp)));
                    if (j >= 1) {
                        deviation.set(j, (Object)((Double)deviation.get(j - 1) + (Double)deviation.get(j)));
                    }
                    ++j;
                }
                j = 0;
                while (j < deviation.size()) {
                    if ((Double)deviation.get(j) > 0.0) {
                        deviation.set(j, (Object)Math.log((Double)deviation.get(j)));
                    }
                    ++j;
                }
                deviationList.add((EList<Double>)deviation);
                ++i;
            }
        }
        return deviationList;
    }
}

