/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stem.util.analysis.Parameter;

public class ModelParameters {
    private final HashMap<String, Parameter> parameters = new HashMap();
    private final HashMap<String, List<double[][]>> selectedData = new HashMap();
    private final HashMap<String, List<double[][]>> regressionData = new HashMap();
    private final HashMap<String, List<double[][]>> fittedData = new HashMap();
    public static final double REFERENCE_POPULATION_DENSITY = 100.0;
    HashMap<String, Double> numerators = new HashMap();
    HashMap<String, Double> denominators = new HashMap();

    public ModelParameters average(Map<String, ModelParameters> parameterIdMap) {
        for (Map.Entry<String, ModelParameters> entry : parameterIdMap.entrySet()) {
            ModelParameters parms = entry.getValue();
            this.accumulateNumerator(parms);
            this.accumulateDenominator(parms);
            Iterator<String> iter2 = parms.selectedData.keySet().iterator();
            while (iter2 != null && iter2.hasNext()) {
                String id = iter2.next();
                List<double[][]> data = parms.selectedData.get(id);
                this.selectedData.put(id, data);
            }
            Iterator<String> iter3 = parms.regressionData.keySet().iterator();
            while (iter3 != null && iter3.hasNext()) {
                String id = iter3.next();
                List<double[][]> data = parms.regressionData.get(id);
                this.regressionData.put(id, data);
            }
            Iterator<String> iter4 = parms.fittedData.keySet().iterator();
            while (iter4 != null && iter4.hasNext()) {
                String id = iter4.next();
                List<double[][]> data = parms.fittedData.get(id);
                this.fittedData.put(id, data);
            }
        }
        this.average();
        this.calculateStdAvg();
        return this;
    }

    private void accumulateNumerator(ModelParameters other) {
        for (Parameter parm : other.getParameters().values()) {
            if (this.numerators.containsKey(parm.name)) {
                this.numerators.put(parm.name, this.numerators.get(parm.name) + parm.value / parm.variance);
                continue;
            }
            this.numerators.put(parm.name, parm.value / parm.variance);
        }
    }

    private void accumulateDenominator(ModelParameters other) {
        for (Parameter parm : other.getParameters().values()) {
            if (this.denominators.containsKey(parm.name)) {
                this.denominators.put(parm.name, this.denominators.get(parm.name) + 1.0 / parm.variance);
                continue;
            }
            this.denominators.put(parm.name, 1.0 / parm.variance);
        }
    }

    private void average() {
        for (String parm : this.numerators.keySet()) {
            double num = this.numerators.get(parm);
            double denom = this.denominators.get(parm);
            this.addParameter(parm, new Parameter(parm, num / denom));
        }
    }

    private void calculateStdAvg() {
        for (String parm : this.numerators.keySet()) {
            Parameter p = this.getParameter(parm);
            p.stddev = Math.sqrt(1.0 / this.denominators.get(parm));
        }
    }

    public void addParameter(String name, Parameter parm) {
        this.parameters.put(name, parm);
    }

    public void addSelectedData(String name, List<double[][]> data) {
        this.selectedData.put(name, data);
    }

    public void addRegressionData(String name, List<double[][]> data) {
        this.regressionData.put(name, data);
    }

    public void addFittedData(String name, List<double[][]> data) {
        this.fittedData.put(name, data);
    }

    public double[] getDataValues(String id, int chartIndex, int state) {
        List<double[][]> dataList = this.selectedData.get(id);
        double[][] data = dataList.get(chartIndex);
        return data[state];
    }

    public double[] getRegressionValues(String id, int chartIndex, int state) {
        List<double[][]> dataList = this.regressionData.get(id);
        double[][] data = dataList.get(chartIndex);
        return data[state];
    }

    public double[] getFittedValues(String id, int chartIndex, int state) {
        List<double[][]> dataList = this.fittedData.get(id);
        double[][] data = dataList.get(chartIndex);
        return data[state];
    }

    public boolean validDataID(String id) {
        boolean retVal = false;
        if (id != null && this.selectedData.containsKey(id)) {
            retVal = true;
        }
        return retVal;
    }

    public String[] getDataLocations() {
        Set<String> keys = this.selectedData.keySet();
        Object[] ids = new String[keys.size()];
        Iterator<String> iter = keys.iterator();
        int i = 0;
        while (iter != null && iter.hasNext()) {
            ids[i] = iter.next();
            ++i;
        }
        Arrays.sort(ids);
        return ids;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String p) {
        return this.parameters.get(p);
    }

    public boolean containsParameter(String p) {
        return this.parameters.containsKey(p);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (Parameter parm : this.parameters.values()) {
            buffer.append(parm.name).append("=").append(parm.value).append("\n");
            buffer.append("deviation(").append(parm.name).append(")").append("=").append(parm.stddev).append("\n");
            buffer.append("variance(").append(parm.name).append(")").append("=").append(parm.variance).append("\n");
        }
        return buffer.toString();
    }
}

