/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.impl;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabel;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.PhysicalRelationshipLabelImpl;

public class RoadTransportRelationshipLabelImpl
extends PhysicalRelationshipLabelImpl
implements RoadTransportRelationshipLabel {
    protected RoadTransportRelationshipLabelImpl() {
        this.setCurrentValue(LabelsFactory.eINSTANCE.createRoadTransportRelationshipLabelValue());
    }

    public static Edge createRoadTransportRelationship(Node nodeA, Node nodeB, String roadName, String roadClass, int numCrossings) {
        Edge retValue = EdgeImpl.createEdge((Node)nodeA, (Node)nodeB);
        RoadTransportRelationshipLabel label = LabelsFactory.eINSTANCE.createRoadTransportRelationshipLabel();
        label.setURIOfIdentifiableToBeLabeled(retValue.getURI());
        RoadTransportRelationshipLabelValue labelValue = (RoadTransportRelationshipLabelValue)label.getCurrentValue();
        labelValue.setRoadName(roadName);
        labelValue.setRoadClass(roadClass);
        labelValue.setNumberCrossings(numCrossings);
        retValue.setLabel((EdgeLabel)label);
        return retValue;
    }

    public static void getRoadEdgesFromNode(Node node, List<Edge> result) {
        if (node == null || node.getEdges() == null) {
            return;
        }
        EList edges = node.getEdges();
        int i = 0;
        while (i < node.getEdges().size()) {
            Edge edge = (Edge)edges.get(i);
            EdgeLabel edgeLabel = edge.getLabel();
            if (edgeLabel instanceof RoadTransportRelationshipLabel) {
                result.add(edge);
            }
            ++i;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return LabelsPackage.Literals.ROAD_TRANSPORT_RELATIONSHIP_LABEL;
    }
}

