/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.resource;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.DispatchUtil;
import org.eclipse.xtend.core.resource.DescriptionFlags;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.resource.XbaseResourceDescriptionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendResourceDescriptionStrategy
extends XbaseResourceDescriptionStrategy {
    @Inject
    private DispatchUtil dispatchUtil;
    @Inject
    private DescriptionFlags descriptionFlags;

    protected void createUserData(EObject eObject, ImmutableMap.Builder<String, String> userData) {
        super.createUserData(eObject, userData);
        if (eObject instanceof JvmOperation) {
            this.addFlags(this.getFlags((JvmOperation)eObject), userData);
        } else if (eObject instanceof JvmField) {
            this.addFlags(this.getFlags((JvmField)eObject), userData);
        } else if (eObject instanceof XtendFunction) {
            this.addFlags(this.getFlags((XtendFunction)eObject), userData);
        } else if (eObject instanceof XtendField) {
            this.addFlags(this.getFlags((XtendField)eObject), userData);
        }
    }

    protected void addFlags(int flags, ImmutableMap.Builder<String, String> userData) {
        if (flags != 0) {
            userData.put((Object)"Flags", (Object)Integer.toString(flags));
        }
    }

    protected int getFlags(JvmOperation operation) {
        int flags = 0;
        if (this.dispatchUtil.isDispatcherFunction(operation)) {
            flags = this.descriptionFlags.setDispatcherOperation(flags);
        }
        if (operation.isStatic()) {
            flags = this.descriptionFlags.setStatic(flags);
        }
        return flags;
    }

    protected int getFlags(JvmField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendField field) {
        return field.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }

    protected int getFlags(XtendFunction function) {
        return function.isStatic() ? this.descriptionFlags.setStatic(0) : 0;
    }
}

