/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.SimpleGraphPartitioner;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.graph.impl.EdgeImpl;
import org.eclipse.stem.core.graph.impl.ExchangeImpl;
import org.eclipse.stem.core.graph.impl.GraphImpl;
import org.eclipse.stem.core.graph.impl.NodeImpl;
import org.eclipse.stem.core.graph.impl.SimpleGraphPartitionerImpl;
import org.eclipse.stem.core.graph.impl.URIToEdgeMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToIdentifiableMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeMapEntryImpl;
import org.eclipse.stem.core.graph.impl.UnresolvedIdentifiableImpl;

public class GraphFactoryImpl
extends EFactoryImpl
implements GraphFactory {
    public static GraphFactory init() {
        try {
            GraphFactory theGraphFactory = (GraphFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/stem/core/graph.ecore");
            if (theGraphFactory != null) {
                return theGraphFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new GraphFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createEdge();
            }
            case 3: {
                return this.createGraph();
            }
            case 6: {
                return this.createNode();
            }
            case 9: {
                return this.createUnresolvedIdentifiable();
            }
            case 10: {
                return (EObject)this.createURIToIdentifiableMapEntry();
            }
            case 14: {
                return (EObject)this.createURIToEdgeMapEntry();
            }
            case 15: {
                return (EObject)this.createURIToNodeMapEntry();
            }
            case 16: {
                return (EObject)this.createURIToLabelMapEntry();
            }
            case 17: {
                return (EObject)this.createURIToNodeLabelMapEntry();
            }
            case 20: {
                return this.createSimpleGraphPartitioner();
            }
            case 21: {
                return this.createExchange();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 24: {
                return this.createExchangeTypeFromString(eDataType, initialValue);
            }
            case 25: {
                return this.createIllegalArgumentExceptionFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 24: {
                return this.convertExchangeTypeToString(eDataType, instanceValue);
            }
            case 25: {
                return this.convertIllegalArgumentExceptionToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Edge createEdge() {
        EdgeImpl edge = new EdgeImpl();
        return edge;
    }

    @Override
    public Graph createGraph() {
        GraphImpl graph = new GraphImpl();
        return graph;
    }

    @Override
    public Node createNode() {
        NodeImpl node = new NodeImpl();
        return node;
    }

    @Override
    public UnresolvedIdentifiable createUnresolvedIdentifiable() {
        UnresolvedIdentifiableImpl unresolvedIdentifiable = new UnresolvedIdentifiableImpl();
        return unresolvedIdentifiable;
    }

    public Map.Entry<URI, Identifiable> createURIToIdentifiableMapEntry() {
        URIToIdentifiableMapEntryImpl uriToIdentifiableMapEntry = new URIToIdentifiableMapEntryImpl();
        return uriToIdentifiableMapEntry;
    }

    public Map.Entry<URI, Edge> createURIToEdgeMapEntry() {
        URIToEdgeMapEntryImpl uriToEdgeMapEntry = new URIToEdgeMapEntryImpl();
        return uriToEdgeMapEntry;
    }

    public Map.Entry<URI, Node> createURIToNodeMapEntry() {
        URIToNodeMapEntryImpl uriToNodeMapEntry = new URIToNodeMapEntryImpl();
        return uriToNodeMapEntry;
    }

    public Map.Entry<URI, Label> createURIToLabelMapEntry() {
        URIToLabelMapEntryImpl uriToLabelMapEntry = new URIToLabelMapEntryImpl();
        return uriToLabelMapEntry;
    }

    public Map.Entry<URI, NodeLabel> createURIToNodeLabelMapEntry() {
        URIToNodeLabelMapEntryImpl uriToNodeLabelMapEntry = new URIToNodeLabelMapEntryImpl();
        return uriToNodeLabelMapEntry;
    }

    @Override
    public SimpleGraphPartitioner createSimpleGraphPartitioner() {
        SimpleGraphPartitionerImpl simpleGraphPartitioner = new SimpleGraphPartitionerImpl();
        return simpleGraphPartitioner;
    }

    @Override
    public Exchange createExchange() {
        ExchangeImpl exchange = new ExchangeImpl();
        return exchange;
    }

    public ExchangeType createExchangeTypeFromString(EDataType eDataType, String initialValue) {
        ExchangeType result = ExchangeType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertExchangeTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public URI createURIFromString(EDataType eDataType, String initialValue) {
        return URI.createURI((String)initialValue);
    }

    public String convertURIToString(EDataType eDataType, Object instanceValue) {
        return instanceValue.toString();
    }

    public IllegalArgumentException createIllegalArgumentExceptionFromString(EDataType eDataType, String initialValue) {
        return (IllegalArgumentException)super.createFromString(eDataType, initialValue);
    }

    public String convertIllegalArgumentExceptionToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public GraphPackage getGraphPackage() {
        return (GraphPackage)this.getEPackage();
    }

    @Deprecated
    public static GraphPackage getPackage() {
        return GraphPackage.eINSTANCE;
    }
}

