/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.diseasemodels.standard.AggregatingSIDiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.util.loggers.Activator;
import org.eclipse.stem.util.loggers.htmlgeneration.HtmlScenarioPage;
import org.eclipse.stem.util.loggers.util.Util;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.LoggerControl;
import org.eclipse.stem.util.loggers.views.LoggerControlFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class LoggerViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListenerSync {
    private static final Map<ISimulation, Set<Identifiable>> identifiablesToDisplayMap = new HashMap<ISimulation, Set<Identifiable>>();
    private static final Collection<ISimulation> simulationsToLog = new ArrayList<ISimulation>();
    private static final String DEFAULT_ID = "data";
    protected static final String sep = File.separator;
    SimulationManager simulationManager;
    private ISelection selection = null;
    final Composite composite;
    ScrolledComposite scrolledComposite;
    Composite outerComposite;
    private static final int WIDTH = 400;
    private static final int HEIGHT_MIN = 250;
    private static final int BUTTON_HEIGHT = 25;
    protected Button loggerOnButton = null;
    protected Button loggerOffButton = null;
    protected Button csvSummaryOnButton = null;
    protected Button csvSummaryOffButton = null;
    protected Button htmlSummaryOnButton = null;
    protected Button htmlSummaryOffButton = null;
    protected static Color onColor = null;
    protected static Color offColor = null;
    protected static CLabel loggerStatusLabel = null;
    protected static CLabel htmlStatusLabel = null;
    protected static CLabel csvStatusLabel = null;
    protected static boolean loggingOn = false;
    protected static boolean htmlSummaryOn = false;
    protected static boolean csvParameterSummaryOn = false;
    protected static final String ON_TEXT = "ON";
    protected static final String OFF_TEXT = "OFF";
    protected static final String MONITOR_ON_TEXT = "Log Simulation Data ON";
    protected static final String MONITOR_OFF_TEXT = "Log Simulation Data OFF";
    protected static final String HTML_ON_TEXT = "Scenario Summary (html) ON";
    protected static final String HTML_OFF_TEXT = "Scenario Summary (html) OFF";
    protected static final String CSV_ON_TEXT = "Parameter Summary ON";
    protected static final String CSV_OFF_TEXT = "Parameter Summary OFF";
    private DialogSettings masterSettings = null;
    private final Set monitorSet = new HashSet();
    private static final String ROOT_KEY = "root";
    public static final String REPORTVIEWPREFERENCES_FILENAME = "Preferences.txt";
    public static final String MODIFICATIONS_TEXT = "@ ==  Modifications ==";
    public static final String NODE_NOT_FOUND = "NODENOTFOUND";
    public static final String LOCATION_PREFERENCE_KEY = "location.ids";
    private static final IPath PATH = org.eclipse.stem.diseasemodels.Activator.getDefault().getStateLocation();
    static Label loggerModeHeader;
    static Label loggerScenarioHeader;
    static Label loggerDiseaseHeader;
    private final LoggerControlFactory lcf;

    public LoggerViewer(Composite parent, LoggerControlFactory lcf) {
        this.outerComposite = new Composite(parent, 2048);
        FormData outerFormData = new FormData();
        FormLayout outerLayout = new FormLayout();
        outerLayout.marginHeight = 5;
        outerLayout.marginWidth = 5;
        this.outerComposite.setLayout((Layout)outerLayout);
        this.outerComposite.setLayoutData((Object)outerFormData);
        Composite top = this.addAllActionButtons(this.outerComposite);
        FormData topFormData = new FormData();
        top.setLayoutData((Object)topFormData);
        top.setSize(-1, 25);
        topFormData.left = new FormAttachment(0, 0);
        topFormData.right = new FormAttachment(100, 0);
        Composite bottom = new Composite(this.outerComposite, 0);
        bottom.setLayout((Layout)new FillLayout(512));
        FormData bottomFormData = new FormData();
        bottom.setLayoutData((Object)bottomFormData);
        bottomFormData.left = new FormAttachment(0, 0);
        bottomFormData.right = new FormAttachment(100, 0);
        bottomFormData.top = new FormAttachment((Control)top, 0, 1024);
        bottomFormData.bottom = new FormAttachment(100, 0);
        Color color = parent.getDisplay().getSystemColor(3);
        bottom.setBackground(color);
        this.scrolledComposite = new ScrolledComposite(bottom, 2816);
        FillLayout scrolledLayout = new FillLayout(512);
        this.scrolledComposite.setLayout((Layout)scrolledLayout);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(false);
        this.scrolledComposite.setMinSize(-1, 250);
        this.scrolledComposite.setSize(-1, 250);
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        FillLayout compositeLayout = new FillLayout(512);
        this.composite.setLayout((Layout)compositeLayout);
        this.scrolledComposite.setContent((Control)this.composite);
        this.lcf = lcf;
        this.refresh();
        this.composite.pack();
        LogWriter.reset();
    }

    private Composite addAllActionButtons(Composite parent) {
        Composite top = new Composite(parent, 0);
        FormLayout topLayout = new FormLayout();
        topLayout.marginHeight = 5;
        topLayout.marginWidth = 5;
        top.setLayout((Layout)topLayout);
        top.setSize(-1, 25);
        Color bgColor = new Color((Device)parent.getDisplay(), new RGB(170, 170, 190));
        onColor = parent.getDisplay().getSystemColor(5);
        offColor = parent.getDisplay().getSystemColor(4);
        top.setBackground(bgColor);
        int buttonWidth = 120;
        int titleWidth = 160;
        loggerStatusLabel = new CLabel(top, 2048);
        loggerStatusLabel.setText(MONITOR_OFF_TEXT);
        loggerStatusLabel.setAlignment(0x1000000);
        loggerStatusLabel.setSize(titleWidth, 25);
        loggerStatusLabel.setText(MONITOR_OFF_TEXT);
        loggerStatusLabel.setBackground(offColor);
        this.loggerOnButton = new Button(top, 2);
        this.loggerOffButton = new Button(top, 2);
        this.loggerOnButton.setText(ON_TEXT);
        this.loggerOffButton.setText(OFF_TEXT);
        this.loggerOnButton.setSize(buttonWidth, 25);
        this.loggerOffButton.setSize(buttonWidth, 25);
        this.loggerOnButton.setSelection(false);
        this.loggerOffButton.setSelection(true);
        htmlStatusLabel = new CLabel(top, 2048);
        htmlStatusLabel.setText(HTML_OFF_TEXT);
        htmlStatusLabel.setAlignment(0x1000000);
        htmlStatusLabel.setSize(titleWidth, 25);
        htmlStatusLabel.setText(HTML_OFF_TEXT);
        htmlStatusLabel.setBackground(offColor);
        this.htmlSummaryOnButton = new Button(top, 2);
        this.htmlSummaryOffButton = new Button(top, 2);
        this.htmlSummaryOnButton.setText(ON_TEXT);
        this.htmlSummaryOffButton.setText(OFF_TEXT);
        this.htmlSummaryOnButton.setSize(buttonWidth, 25);
        this.htmlSummaryOffButton.setSize(buttonWidth, 25);
        this.htmlSummaryOnButton.setSelection(false);
        this.htmlSummaryOffButton.setSelection(true);
        csvStatusLabel = new CLabel(top, 2048);
        csvStatusLabel.setText(CSV_OFF_TEXT);
        csvStatusLabel.setAlignment(0x1000000);
        csvStatusLabel.setSize(titleWidth, 25);
        csvStatusLabel.setText(CSV_OFF_TEXT);
        csvStatusLabel.setBackground(offColor);
        this.csvSummaryOnButton = new Button(top, 2);
        this.csvSummaryOffButton = new Button(top, 2);
        this.csvSummaryOnButton.setText(ON_TEXT);
        this.csvSummaryOffButton.setText(OFF_TEXT);
        this.csvSummaryOnButton.setSize(buttonWidth, 25);
        this.csvSummaryOffButton.setSize(buttonWidth, 25);
        this.csvSummaryOnButton.setSelection(false);
        this.csvSummaryOnButton.setEnabled(false);
        this.csvSummaryOffButton.setSelection(true);
        this.loggerOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerViewer.this.disableLogging();
            }
        });
        this.loggerOnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISimulation[] simulations = null;
                List activesims = LoggerViewer.this.simulationManager.getActiveSimulations();
                if (activesims != null) {
                    simulations = new ISimulation[activesims.size()];
                    int i = 0;
                    while (i < activesims.size()) {
                        simulations[i] = (ISimulation)activesims.get(i);
                        ++i;
                    }
                }
                LoggerViewer.this.enableLogging(simulations);
            }
        });
        this.csvSummaryOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerViewer.this.disableCsvSummary();
            }
        });
        this.csvSummaryOnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISimulation[] simulations = null;
                List activesims = LoggerViewer.this.simulationManager.getActiveSimulations();
                if (activesims != null) {
                    simulations = new ISimulation[activesims.size()];
                    int i = 0;
                    while (i < activesims.size()) {
                        simulations[i] = (ISimulation)activesims.get(i);
                        ++i;
                    }
                }
                LoggerViewer.this.enableCsvSummary(simulations);
            }
        });
        this.htmlSummaryOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoggerViewer.this.disableHtmlSummary();
            }
        });
        this.htmlSummaryOnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISimulation[] simulations = null;
                List activesims = LoggerViewer.this.simulationManager.getActiveSimulations();
                if (activesims != null) {
                    simulations = new ISimulation[activesims.size()];
                    int i = 0;
                    while (i < activesims.size()) {
                        simulations[i] = (ISimulation)activesims.get(i);
                        ++i;
                    }
                }
                LoggerViewer.this.enableHtmlSummary(simulations);
            }
        });
        FormData statusLabelFormData = new FormData();
        loggerStatusLabel.setLayoutData((Object)statusLabelFormData);
        statusLabelFormData.left = new FormAttachment(0, 0);
        statusLabelFormData.right = new FormAttachment(40, 0);
        statusLabelFormData.top = new FormAttachment(0, 0);
        statusLabelFormData.bottom = new FormAttachment(0, 25);
        top.setLayoutData((Object)statusLabelFormData);
        FormData loggerOnButtonFormData = new FormData();
        loggerOnButtonFormData.left = new FormAttachment(40, 0);
        loggerOnButtonFormData.right = new FormAttachment(70, 0);
        loggerOnButtonFormData.top = new FormAttachment(0, 0);
        loggerOnButtonFormData.bottom = new FormAttachment(0, 25);
        this.loggerOnButton.setLayoutData((Object)loggerOnButtonFormData);
        FormData loggerOffButtonFormData = new FormData();
        loggerOffButtonFormData.left = new FormAttachment(70, 0);
        loggerOffButtonFormData.right = new FormAttachment(100, 0);
        loggerOffButtonFormData.top = new FormAttachment(0, 0);
        loggerOffButtonFormData.bottom = new FormAttachment(0, 25);
        this.loggerOffButton.setLayoutData((Object)loggerOffButtonFormData);
        FormData csvStatusLabelFormData = new FormData();
        csvStatusLabel.setLayoutData((Object)csvStatusLabelFormData);
        csvStatusLabelFormData.left = new FormAttachment(0, 0);
        csvStatusLabelFormData.right = new FormAttachment(40, 0);
        csvStatusLabelFormData.top = new FormAttachment(0, 25);
        csvStatusLabelFormData.bottom = new FormAttachment(0, 50);
        csvStatusLabel.setLayoutData((Object)csvStatusLabelFormData);
        FormData csvOnButtonFormData = new FormData();
        csvOnButtonFormData.left = new FormAttachment(40, 0);
        csvOnButtonFormData.right = new FormAttachment(70, 0);
        csvOnButtonFormData.top = new FormAttachment(0, 25);
        csvOnButtonFormData.bottom = new FormAttachment(0, 50);
        this.csvSummaryOnButton.setLayoutData((Object)csvOnButtonFormData);
        FormData csvOffButtonFormData = new FormData();
        csvOffButtonFormData.left = new FormAttachment(70, 0);
        csvOffButtonFormData.right = new FormAttachment(100, 0);
        csvOffButtonFormData.top = new FormAttachment(0, 25);
        csvOffButtonFormData.bottom = new FormAttachment(0, 50);
        this.csvSummaryOffButton.setLayoutData((Object)csvOffButtonFormData);
        FormData htmlStatusLabelFormData = new FormData();
        htmlStatusLabel.setLayoutData((Object)htmlStatusLabelFormData);
        htmlStatusLabelFormData.left = new FormAttachment(0, 0);
        htmlStatusLabelFormData.right = new FormAttachment(40, 0);
        htmlStatusLabelFormData.top = new FormAttachment(0, 50);
        htmlStatusLabelFormData.bottom = new FormAttachment(0, 75);
        htmlStatusLabel.setLayoutData((Object)htmlStatusLabelFormData);
        FormData htmlOnButtonFormData = new FormData();
        htmlOnButtonFormData.left = new FormAttachment(40, 0);
        htmlOnButtonFormData.right = new FormAttachment(70, 0);
        htmlOnButtonFormData.top = new FormAttachment(0, 50);
        htmlOnButtonFormData.bottom = new FormAttachment(0, 75);
        this.htmlSummaryOnButton.setLayoutData((Object)htmlOnButtonFormData);
        FormData htmlOffButtonFormData = new FormData();
        htmlOffButtonFormData.left = new FormAttachment(70, 0);
        htmlOffButtonFormData.right = new FormAttachment(100, 0);
        htmlOffButtonFormData.top = new FormAttachment(0, 50);
        htmlOffButtonFormData.bottom = new FormAttachment(0, 75);
        this.htmlSummaryOffButton.setLayoutData((Object)htmlOffButtonFormData);
        if (loggerModeHeader == null) {
            loggerModeHeader = new Label(top, 2048);
            loggerModeHeader.setText("Mode");
            loggerModeHeader.setAlignment(0x1000000);
            loggerScenarioHeader = new Label(top, 2048);
            loggerScenarioHeader.setText("Scenario");
            loggerScenarioHeader.setAlignment(0x1000000);
            loggerDiseaseHeader = new Label(top, 2048);
            loggerDiseaseHeader.setText("Disease");
            loggerDiseaseHeader.setAlignment(0x1000000);
            FormData loggerModeFormData = new FormData();
            loggerModeFormData.top = new FormAttachment(0, 80);
            loggerModeFormData.bottom = new FormAttachment(0, 100);
            loggerModeFormData.left = new FormAttachment(0, 0);
            loggerModeFormData.right = new FormAttachment(25, 0);
            loggerModeHeader.setLayoutData((Object)loggerModeFormData);
            FormData loggerScenarioFormData = new FormData();
            loggerScenarioFormData.top = new FormAttachment(0, 80);
            loggerScenarioFormData.bottom = new FormAttachment(0, 100);
            loggerScenarioFormData.left = new FormAttachment(25, 0);
            loggerScenarioFormData.right = new FormAttachment(50, 0);
            loggerScenarioHeader.setLayoutData((Object)loggerScenarioFormData);
            FormData loggerDiseaseFormData = new FormData();
            loggerDiseaseFormData.top = new FormAttachment(0, 80);
            loggerDiseaseFormData.bottom = new FormAttachment(0, 100);
            loggerDiseaseFormData.left = new FormAttachment(50, 0);
            loggerDiseaseFormData.right = new FormAttachment(90, 0);
            loggerDiseaseHeader.setLayoutData((Object)loggerDiseaseFormData);
        }
        return top;
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            List allSimulations = null;
            this.updatePreferenceState(this.simulationManager.getActiveSimulations());
            if (this.simulationManager != null) {
                allSimulations = this.simulationManager.getActiveSimulations();
                this.addToDisplayedIdentifiableSet(allSimulations);
            }
            identifiablesToDisplayMap.clear();
            this.addAllIdentifiablesBySimulation(this.simulationManager.getActiveSimulations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLogging(ISimulation[] newSimulations) {
        LoggerViewer loggerViewer = this;
        synchronized (loggerViewer) {
            int i = 0;
            while (i < newSimulations.length) {
                ISimulation simulation = newSimulations[i];
                if (!simulationsToLog.contains(simulation)) {
                    simulationsToLog.add(simulation);
                    this.populateView(newSimulations);
                }
                ++i;
            }
            loggerStatusLabel.setText(MONITOR_ON_TEXT);
            loggerStatusLabel.setBackground(onColor);
            loggingOn = true;
            this.loggerOnButton.setSelection(true);
            this.loggerOffButton.setSelection(false);
            this.csvSummaryOnButton.setEnabled(true);
        }
    }

    public void disableLogging() {
        Control[] allControls;
        simulationsToLog.clear();
        Control[] controlArray = allControls = this.composite.getChildren();
        int n = allControls.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (element instanceof LoggerControl) {
                LoggerControl loggerControl = (LoggerControl)element;
                loggerControl.remove();
            } else {
                element.dispose();
            }
            ++n2;
        }
        loggerStatusLabel.setText(MONITOR_OFF_TEXT);
        loggerStatusLabel.setBackground(offColor);
        loggingOn = false;
        this.loggerOnButton.setSelection(false);
        this.loggerOffButton.setSelection(true);
        this.disableCsvSummary();
        this.csvSummaryOnButton.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableHtmlSummary(ISimulation[] newSimulations) {
        LoggerViewer loggerViewer = this;
        synchronized (loggerViewer) {
            int i = 0;
            while (i < newSimulations.length) {
                ISimulation simulation = newSimulations[i];
                if (!simulationsToLog.contains(simulation)) {
                    simulationsToLog.add(simulation);
                    this.populateView(newSimulations);
                }
                ++i;
            }
            htmlStatusLabel.setText(HTML_ON_TEXT);
            htmlStatusLabel.setBackground(onColor);
            htmlSummaryOn = true;
            this.htmlSummaryOnButton.setSelection(true);
            this.htmlSummaryOffButton.setSelection(false);
        }
    }

    public void disableHtmlSummary() {
        htmlStatusLabel.setText(HTML_OFF_TEXT);
        htmlStatusLabel.setBackground(offColor);
        htmlSummaryOn = false;
        this.htmlSummaryOnButton.setSelection(false);
        this.htmlSummaryOffButton.setSelection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableCsvSummary(ISimulation[] newSimulations) {
        LoggerViewer loggerViewer = this;
        synchronized (loggerViewer) {
            if (loggingOn) {
                csvStatusLabel.setText(CSV_ON_TEXT);
                csvStatusLabel.setBackground(onColor);
                csvParameterSummaryOn = true;
                this.csvSummaryOnButton.setSelection(true);
                this.csvSummaryOffButton.setSelection(false);
            }
        }
    }

    public void disableCsvSummary() {
        csvStatusLabel.setText(CSV_OFF_TEXT);
        csvStatusLabel.setBackground(offColor);
        csvParameterSummaryOn = false;
        this.csvSummaryOnButton.setSelection(false);
        this.csvSummaryOffButton.setSelection(true);
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object input) {
        SimulationManager oldInput = this.simulationManager;
        this.simulationManager = (SimulationManager)input;
        this.inputChanged(input, oldInput);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null) {
            ((SimulationManager)oldInput).removeListenerSync((ISimulationManagerListenerSync)this);
        }
        if (input != null) {
            ((SimulationManager)input).addSimulationManagerListenerSync((ISimulationManagerListenerSync)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection = selection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() instanceof LoggerControl) {
            this.selection = event.getSelection();
            this.fireSelectionChanged(event);
        }
    }

    public void simulationsChangedSync(SimulationManagerEvent event) {
        this.updatePreferenceState(Arrays.asList(event.getSimulationsAdded()));
        List<ISimulation> newSimulations = Arrays.asList(event.getSimulationsAdded());
        this.addToDisplayedIdentifiableSet(newSimulations);
        this.removeFromDisplayedSimulationSet(Arrays.asList(event.getSimulationsRemoved()));
        if (loggingOn) {
            this.enableLogging(event.getSimulationsAdded());
        } else {
            this.disableLogging();
        }
        if (htmlSummaryOn) {
            this.enableHtmlSummary(event.getSimulationsAdded());
        } else {
            this.disableHtmlSummary();
        }
    }

    private void addToDisplayedIdentifiableSet(List<ISimulation> simulations) {
        LogWriter.reset();
        if (!simulations.isEmpty()) {
            int i = 0;
            while (i < simulations.size()) {
                ISimulation sim = simulations.get(i);
                Set<Identifiable> identifiablesToDisplay = this.getIdentifiableSet(sim);
                identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(sim));
                identifiablesToDisplayMap.put(sim, identifiablesToDisplay);
                ++i;
            }
        }
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> simulations) {
        if (!simulations.isEmpty()) {
            int i = 0;
            while (i < simulations.size()) {
                ISimulation sim = simulations.get(i);
                Set<Identifiable> identifiablesToRemove = this.getIdentifiableSet(sim);
                this.cleanup(identifiablesToRemove, sim);
                identifiablesToRemove.clear();
                identifiablesToDisplayMap.remove(sim);
                ++i;
            }
        }
    }

    Set<Identifiable> getIdentifiablesInSimulation(ISimulation simulation) {
        LinkedHashSet<Identifiable> retVal = new LinkedHashSet<Identifiable>();
        Graph graph = simulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            Iterator iter = this.monitorSet.iterator();
            while (iter != null && iter.hasNext()) {
                String key = (String)iter.next();
                Node node = null;
                URI locURI = null;
                try {
                    locURI = URI.createURI((String)key);
                    node = graph.getNode(locURI);
                    if (node == null) continue;
                    retVal.add((Identifiable)node);
                }
                catch (Exception e) {
                    Activator.logError("LoggerViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + key + " ", e);
                }
            }
        }
        return retVal;
    }

    private void cleanup(Set defunctIdentifiables, ISimulation removedSimulation) {
        if (defunctIdentifiables != null) {
            Iterator iter = defunctIdentifiables.iterator();
            while (iter != null && iter.hasNext()) {
                Identifiable ident = (Identifiable)iter.next();
                if (!this.noOtherSimulationContains(ident, removedSimulation)) continue;
                this.monitorSet.remove(ident.getURI().toString());
            }
        }
    }

    protected void removeIdentifiable(Identifiable ident) {
        if (ident != null) {
            Iterator<ISimulation> iter = identifiablesToDisplayMap.keySet().iterator();
            while (iter != null && iter.hasNext()) {
                ISimulation sim = iter.next();
                Set<Identifiable> identifiablesToDisplay = identifiablesToDisplayMap.get(sim);
                identifiablesToDisplay.remove(ident);
            }
            this.savePreferenceState();
        }
    }

    protected boolean noOtherSimulationContains(Identifiable ident, ISimulation removedSim) {
        if (ident != null) {
            Iterator<ISimulation> iter = identifiablesToDisplayMap.keySet().iterator();
            while (iter != null && iter.hasNext()) {
                Set<Identifiable> identifiablesToDisplay;
                ISimulation sim = iter.next();
                if (sim.getSequenceNumber() == removedSim.getSequenceNumber() || !(identifiablesToDisplay = identifiablesToDisplayMap.get(sim)).contains(ident)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateView(ISimulation[] newSimulations) {
        try {
            if (this.composite.isDisposed()) {
                return;
            }
            this.selection = null;
            if (newSimulations != null && newSimulations.length >= 1) {
                LoggerViewer loggerViewer = this;
                synchronized (loggerViewer) {
                    int i = 0;
                    while (i < newSimulations.length) {
                        String directoryName;
                        File dir;
                        ISimulation simulation = newSimulations[i];
                        Scenario scenario = simulation.getScenario();
                        String scenarioURL = scenario.getURI().toString();
                        String dirPrefix = Util.getLoggingFolder(scenarioURL);
                        String uniqueID = DEFAULT_ID;
                        if (simulation != null) {
                            uniqueID = simulation.getUniqueIDString();
                            while (uniqueID == null) {
                                uniqueID = simulation.getUniqueIDString();
                            }
                        }
                        if (!(dir = new File(directoryName = String.valueOf(dirPrefix) + sep + uniqueID + sep)).exists()) {
                            dir.mkdirs();
                        }
                        if (htmlSummaryOn) {
                            new HtmlScenarioPage(scenario, directoryName);
                        }
                        if (loggingOn) {
                            EList decorators = simulation.getScenario().getCanonicalGraph().getDecorators();
                            for (Decorator dec : decorators) {
                                if (!(dec instanceof IntegrationDecorator) || dec instanceof AggregatingSIDiseaseModel) continue;
                                IntegrationDecorator dm = (IntegrationDecorator)dec;
                                LoggerControl loggerControl = this.lcf.create(this.composite, directoryName, simulation, dm, csvParameterSummaryOn);
                                loggerControl.addSelectionChangedListener(this);
                                loggerControl.createTopComposite(this.composite);
                            }
                        }
                        ++i;
                    }
                }
            }
            this.composite.layout(true, true);
            this.composite.redraw();
        }
        catch (Exception e) {
            org.eclipse.stem.diseasemodels.Activator.logError((String)"Exception in PopulateView() ", (Throwable)e);
        }
    }

    private void addAllIdentifiablesBySimulation(List<ISimulation> simulationList) {
        int i = 0;
        while (i < simulationList.size()) {
            ISimulation simulation = simulationList.get(i);
            Set<Identifiable> identifiablesToDisplaySet = this.getIdentifiableSet(simulation);
            Graph graph = simulation.getScenario().getCanonicalGraph();
            if (graph != null) {
                Iterator iter = this.monitorSet.iterator();
                while (iter != null && iter.hasNext()) {
                    String key = (String)iter.next();
                    Node node = null;
                    URI locURI = null;
                    try {
                        locURI = URI.createURI((String)key);
                        node = graph.getNode(locURI);
                        if (node == null) continue;
                        identifiablesToDisplaySet.add((Identifiable)node);
                    }
                    catch (Exception e) {
                        Activator.logError("LoggerViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + key + " ", e);
                    }
                }
            }
            ++i;
        }
    }

    protected String getScenarioName(Identifiable ident) {
        String retVal = "NODE_NOT_FOUND";
        List simulationList = this.simulationManager.getActiveSimulations();
        int i = 0;
        while (i < simulationList.size()) {
            Node node;
            ISimulation simulation = (ISimulation)simulationList.get(i);
            Graph graph = simulation.getScenario().getCanonicalGraph();
            if (graph != null && (node = graph.getNode(ident.getURI())) != null) {
                return simulation.getScenario().toString();
            }
            ++i;
        }
        return retVal;
    }

    private void savePreferenceState() {
        List allSimulations = null;
        HashSet<String> nodesInSimulation = new HashSet<String>();
        if (this.simulationManager != null) {
            allSimulations = this.simulationManager.getActiveSimulations();
        }
        if (allSimulations != null && allSimulations.size() >= 1) {
            int i = 0;
            while (i < allSimulations.size()) {
                nodesInSimulation.clear();
                ISimulation sim = (ISimulation)allSimulations.get(i);
                String scenarioName = sim.getScenario().getURI().toString();
                DialogSettings section = new DialogSettings(scenarioName);
                Graph graph = sim.getScenario().getCanonicalGraph();
                Set<Identifiable> identifiablesToDisplay = this.getIdentifiableSet(sim);
                Iterator<Identifiable> iter = identifiablesToDisplay.iterator();
                while (iter != null && iter.hasNext()) {
                    String id;
                    Node node;
                    Identifiable ident = iter.next();
                    if (ident == null || (node = graph.getNode(ident.getURI())) == null || (id = ident.getURI().toString()) == null) continue;
                    nodesInSimulation.add(id);
                }
                String[] newPrefs = new String[nodesInSimulation.size()];
                Iterator iter2 = nodesInSimulation.iterator();
                int icount = 0;
                while (iter2 != null && iter2.hasNext()) {
                    newPrefs[icount] = (String)iter2.next();
                    ++icount;
                }
                section.put(LOCATION_PREFERENCE_KEY, newPrefs);
                if (this.masterSettings == null) {
                    this.masterSettings = new DialogSettings(ROOT_KEY);
                }
                this.masterSettings.addSection((IDialogSettings)section);
                try {
                    this.masterSettings.save(this.getPrefFileName());
                }
                catch (IOException ioe) {
                    Activator.logError("exception writing file [" + ioe.getMessage() + "]", ioe);
                }
                ++i;
            }
        }
    }

    Set<Identifiable> getIdentifiableSet(ISimulation simulation) {
        if (!identifiablesToDisplayMap.containsKey(simulation)) {
            LinkedHashSet identifiablesToDisplaySet = new LinkedHashSet();
            identifiablesToDisplayMap.put(simulation, identifiablesToDisplaySet);
        }
        return identifiablesToDisplayMap.get(simulation);
    }

    public static String nameFilter(String s) {
        String s1 = s.trim();
        s1 = s1.replace('\"', ' ');
        s1 = s1.replaceAll(" ", "");
        s1 = s1.replace(',', '_');
        s1 = s1.replace('.', '_');
        return s1;
    }

    private void updatePreferenceState(List runningSimulations) {
        if (this.masterSettings == null) {
            this.readMasterSettingsFromFile();
        }
        if (runningSimulations != null && runningSimulations.size() >= 1) {
            int i = 0;
            while (i < runningSimulations.size()) {
                String[] allIDs;
                ISimulation sim = (ISimulation)runningSimulations.get(i);
                String scenarioName = sim.getScenario().getURI().toString();
                IDialogSettings section = this.masterSettings.getSection(scenarioName);
                if (section == null) {
                    section = new DialogSettings(scenarioName);
                    this.masterSettings.addSection(section);
                }
                if ((allIDs = section.getArray(LOCATION_PREFERENCE_KEY)) != null) {
                    String[] stringArray = allIDs;
                    int n = allIDs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        this.monitorSet.add(element);
                        ++n2;
                    }
                }
                ++i;
            }
        }
    }

    public void readMasterSettingsFromFile() {
        this.masterSettings = new DialogSettings(ROOT_KEY);
        String filename = this.getPrefFileName();
        File f = new File(filename);
        if (f.exists()) {
            try {
                this.masterSettings.load(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception loading file [" + ioe.getMessage() + "]", ioe);
            }
        } else {
            try {
                this.masterSettings.save(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception creating file [" + ioe.getMessage() + "]", ioe);
            }
        }
    }

    public String getPrefFileName() {
        String controlCategory = this.lcf.getControlType();
        String filename = PATH.append(String.valueOf(controlCategory) + "_" + REPORTVIEWPREFERENCES_FILENAME).toOSString();
        return filename;
    }
}

