/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditor;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditorAdapter;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiseaseModelPropertyComposite
extends Composite {
    private Map<DiseaseModel, DiseaseModelPropertyEditor> modelMap = new HashMap<DiseaseModel, DiseaseModelPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public DiseaseModelPropertyComposite(Composite parent, int style, DiseaseModel[] diseaseModels, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(DiseaseWizardMessages.getString("DMPC1"));
        DiseaseModelPropertyEditor firstOne = null;
        if (diseaseModels != null) {
            DiseaseModel[] diseaseModelArray = diseaseModels;
            int n = diseaseModels.length;
            int n2 = 0;
            while (n2 < n) {
                DiseaseModel model = diseaseModelArray[n2];
                DiseaseModelPropertyEditorAdapter dmpea = (DiseaseModelPropertyEditorAdapter)DiseaseModelPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)model, DiseaseModelPropertyEditorAdapter.class);
                DiseaseModelPropertyEditor dmpe = dmpea.createDiseaseModelPropertyEditor(this, 0, projectValidator, project);
                this.modelMap.put(model, dmpe);
                if (firstOne == null) {
                    firstOne = dmpe;
                }
                ++n2;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    void displayDiseaseModel(DiseaseModel diseaseModel) {
        DiseaseModelPropertyEditor dmpe = this.modelMap.get(diseaseModel);
        if (dmpe != null) {
            this.stackLayout.topControl = dmpe;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(DiseaseWizardMessages.getString("DMPC2")) + diseaseModel.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((DiseaseModelPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((DiseaseModelPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populateDiseaseModel(DiseaseModel diseaseModel) {
        ((DiseaseModelPropertyEditor)this.stackLayout.topControl).populate(diseaseModel);
    }
}

