/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.common.collect.ObjectArrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class XtextSpellingReconcileStrategy
extends SpellingReconcileStrategy {
    private ISpellingProblemCollector spellingProblemCollector;
    private SpellingService spellingService = EditorsUI.getSpellingService();
    private SpellingContext spellingContext = new SpellingContext();
    private NullProgressMonitor progressMonitor = new NullProgressMonitor();

    protected XtextSpellingReconcileStrategy(ISourceViewer viewer) {
        super(viewer, EditorsUI.getSpellingService());
        this.spellingContext.setContentType(this.getContentType());
    }

    public void setDocument(IDocument document) {
        super.setDocument(document);
        this.spellingProblemCollector = this.createSpellingProblemCollector();
    }

    public void reconcile(IRegion region) {
        if (!this.isSpellingEnabled()) {
            return;
        }
        ITypedRegion[] regions = this.computePartitioning(0, this.getDocument().getLength(), "__dftl_partitioning");
        this.spellingService.check(this.getDocument(), (IRegion[])regions, this.spellingContext, this.spellingProblemCollector, (IProgressMonitor)this.progressMonitor);
    }

    protected ITypedRegion[] computePartitioning(int offset, int length, String partitionType) {
        Object[] result = new ITypedRegion[]{};
        ITypedRegion[] allRegions = new ITypedRegion[]{};
        try {
            allRegions = TextUtilities.computePartitioning((IDocument)this.getDocument(), (String)partitionType, (int)offset, (int)length, (boolean)false);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        int i = 0;
        while (i < allRegions.length) {
            if (this.shouldProcess(allRegions[i])) {
                result = (ITypedRegion[])ObjectArrays.concat((Object[])result, (Object)allRegions[i]);
            }
            ++i;
        }
        return result;
    }

    protected boolean shouldProcess(ITypedRegion typedRegion) {
        return "__string".equals(typedRegion.getType()) || "__sl_comment".equals(typedRegion.getType()) || "__comment".equals(typedRegion.getType());
    }

    protected boolean isSpellingEnabled() {
        return this.spellingProblemCollector != null && EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    public static class Factory {
        public XtextSpellingReconcileStrategy create(ISourceViewer sourceViewer) {
            return new XtextSpellingReconcileStrategy(sourceViewer);
        }
    }
}

