/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.io.IOException;

public abstract class AnnotationScanner {
    public boolean containsAnnotations() throws IOException {
        State state = State.NORMAL;
        boolean seenBackslash = false;
        int c = this.getNext();
        while (c != -1) {
            if (seenBackslash) {
                seenBackslash = false;
            } else if (c == 92) {
                seenBackslash = true;
            } else {
                switch (state) {
                    case NORMAL: {
                        if (c == 64) {
                            return true;
                        }
                        if (c == 47) {
                            state = State.SEEN_SLASH;
                            break;
                        }
                        if (c == 39) {
                            state = State.IN_SINGLE_QUOTE;
                            break;
                        }
                        if (c != 34) break;
                        state = State.IN_DOUBLE_QUOTE;
                        break;
                    }
                    case SEEN_SLASH: {
                        if (c == 42) {
                            state = State.IN_COMMENT;
                            break;
                        }
                        if (c == 47) {
                            state = State.IN_SINGLE_LINE_COMMENT;
                            break;
                        }
                        state = State.NORMAL;
                        break;
                    }
                    case IN_COMMENT: {
                        if (c != 42) break;
                        state = State.IN_COMMENT_SEEN_STAR;
                        break;
                    }
                    case IN_COMMENT_SEEN_STAR: {
                        if (c == 47) {
                            state = State.NORMAL;
                            break;
                        }
                        state = State.IN_COMMENT;
                        break;
                    }
                    case IN_SINGLE_LINE_COMMENT: {
                        if (c != 10 && c != 13) break;
                        state = State.NORMAL;
                        break;
                    }
                    case IN_SINGLE_QUOTE: {
                        if (c != 39) break;
                        state = State.NORMAL;
                        break;
                    }
                    case IN_DOUBLE_QUOTE: {
                        if (c != 34) break;
                        state = State.NORMAL;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled state: " + (Object)((Object)state));
                    }
                }
            }
            c = this.getNext();
        }
        return false;
    }

    protected abstract int getNext() throws IOException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NORMAL,
        SEEN_SLASH,
        IN_COMMENT,
        IN_COMMENT_SEEN_STAR,
        IN_SINGLE_LINE_COMMENT,
        IN_SINGLE_QUOTE,
        IN_DOUBLE_QUOTE;

    }
}

