/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractLinkingCandidateWithTypeParameter;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorLinkingCandidate
extends AbstractLinkingCandidateWithTypeParameter<IConstructorLinkingCandidate>
implements IConstructorLinkingCandidate {
    public ConstructorLinkingCandidate(XConstructorCall constructorCall, IEObjectDescription description, AbstractTypeComputationState state) {
        super(constructorCall, description, state);
    }

    @Override
    public XConstructorCall getConstructorCall() {
        return (XConstructorCall)this.getExpression();
    }

    @Override
    public JvmConstructor getConstructor() {
        return (JvmConstructor)this.getFeature();
    }

    @Override
    protected List<XExpression> getSyntacticArguments() {
        return this.getConstructorCall().getArguments();
    }

    @Override
    protected List<JvmTypeReference> getTypeArguments() {
        return this.getConstructorCall().getTypeArguments();
    }

    @Override
    public List<JvmFormalParameter> getDeclaredParameters() {
        return this.getConstructor().getParameters();
    }

    @Override
    public List<JvmTypeParameter> getDeclaredTypeParameters() {
        JvmDeclaredType createdType = this.getConstructor().getDeclaringType();
        if (createdType instanceof JvmTypeParameterDeclarator) {
            return ((JvmTypeParameterDeclarator)createdType).getTypeParameters();
        }
        return Collections.emptyList();
    }

    @Override
    protected Map<JvmTypeParameter, JvmTypeReference> getFeatureTypeParameterMapping() {
        JvmDeclaredType createdType = this.getConstructor().getDeclaringType();
        if (createdType instanceof JvmTypeParameterDeclarator) {
            EList<JvmTypeReference> typeArguments = this.getConstructorCall().getTypeArguments();
            EList typeParameters = ((JvmTypeParameterDeclarator)createdType).getTypeParameters();
            if (!typeArguments.isEmpty()) {
                int max = Math.min(typeArguments.size(), typeParameters.size());
                HashMap result = Maps.newHashMapWithExpectedSize((int)max);
                int i = 0;
                while (i < max) {
                    result.put((JvmTypeParameter)typeParameters.get(i), (JvmTypeReference)typeArguments.get(i));
                    ++i;
                }
                return result;
            }
        }
        return super.getFeatureTypeParameterMapping();
    }
}

