/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.render;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.RotatedRectangle;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWith3DAxes;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.Line3DRenderEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.internal.factory.DateFormatWrapperFactory;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Angle3D;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NumberUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AxesRenderHelper {
    static final ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/render");
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    AxesRenderer renderer;
    OneAxis ax;
    int iWhatToDraw;
    IPrimitiveRenderer ipr;
    private Axis axModel;
    private PlotWithAxes pwa;
    private IChartComputation cComp;
    private Insets insCA;
    private AbstractScriptHandler sh;
    private double dLocation;
    private AutoScale sc;
    private IntersectionValue iv;
    private int iMajorTickStyle;
    private int iMinorTickStyle;
    private int iLabelLocation;
    private int iOrientation;
    private IDisplayServer xs;
    private Label la;
    private double[] daEndPoints;
    private AxisTickCoordinates da;
    private double[] daMinor;
    private String sText;
    private int iDimension;
    private double dSeriesThickness;
    private NumberDataElement nde;
    private boolean bAxisLabelStaggered;
    private DecimalFormat df;
    private LineAttributes lia;
    private LineAttributes liaMajorTick;
    private LineAttributes liaMinorTick;
    private boolean bRenderAxisLabels;
    private boolean bRenderAxisTitle;
    private Location lo;
    private TransformationEvent trae;
    private TextRenderEvent tre;
    private LineRenderEvent lre;
    private boolean bRendering3D;
    private boolean bRenderOrthogonal3DAxis;
    private boolean bRenderBase3DAxis;
    private boolean bRenderAncillary3DAxis;
    private DeferredCache dc;
    private int axisType;
    private Location panningOffset;
    private boolean bTransposed;
    private double[] daEndPoints3D;
    private AxisTickCoordinates da3D;
    private Location3D lo3d;
    private Text3DRenderEvent t3dre;
    private Line3DRenderEvent l3dre;
    private boolean bTickBetweenCategories;
    private boolean bLabelWithinAxes;

    AxesRenderHelper(AxesRenderer renderer, IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) throws ChartException {
        this.init(renderer, ipr, pl, ax, iWhatToDraw);
    }

    private void init(AxesRenderer renderer, IPrimitiveRenderer ipr, Plot pl, OneAxis ax, int iWhatToDraw) throws ChartException {
        this.renderer = renderer;
        this.ax = ax;
        this.iWhatToDraw = iWhatToDraw;
        this.ipr = ipr;
        this.axModel = ax.getModelAxis();
        this.pwa = (PlotWithAxes)renderer.getComputations();
        this.cComp = this.pwa.getChartComputation();
        this.insCA = this.pwa.getAxes().getInsets();
        this.sh = this.getRunTimeContext().getScriptHandler();
        this.dLocation = ax.getAxisCoordinate();
        this.sc = ax.getScale();
        this.iv = ax.getIntersectionValue();
        this.iMajorTickStyle = ax.getGrid().getTickStyle(0);
        this.iMinorTickStyle = ax.getGrid().getTickStyle(1);
        this.iLabelLocation = ax.getLabelPosition();
        this.iOrientation = ax.getOrientation();
        this.xs = renderer.getDevice().getDisplayServer();
        this.la = goFactory.copyOf(ax.getLabel());
        this.daEndPoints = this.sc.getEndPoints();
        this.da = this.sc.getTickCordinates();
        this.daMinor = this.sc.getMinorCoordinates(ax.getGrid().getMinorCountPerMajor());
        this.sText = null;
        this.iDimension = this.pwa.getDimension();
        this.nde = NumberDataElementImpl.create(0.0);
        this.dSeriesThickness = this.pwa.getSeriesThickness();
        this.bAxisLabelStaggered = this.sc.isAxisLabelStaggered();
        this.df = null;
        this.lia = ax.getLineAttributes();
        this.liaMajorTick = ax.getGrid().getTickAttributes(0);
        this.liaMinorTick = ax.getGrid().getTickAttributes(1);
        this.bRenderAxisLabels = ax.isShowLabels() && (iWhatToDraw & 2) == 2 && this.la.isVisible();
        this.bRenderAxisTitle = (iWhatToDraw & 2) == 2;
        this.lo = goFactory.createLocation(0.0, 0.0);
        this.trae = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(this.axModel), TransformationEvent.class);
        this.tre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(this.axModel), TextRenderEvent.class);
        this.lre = ((EventObjectCache)((Object)ipr)).getEventObject(StructureSource.createAxis(this.axModel), LineRenderEvent.class);
        this.bRendering3D = this.iDimension == 2;
        this.bRenderOrthogonal3DAxis = (iWhatToDraw & 9) == 9 && this.bRendering3D;
        this.bRenderBase3DAxis = (iWhatToDraw & 5) == 5 && this.bRendering3D;
        this.bRenderAncillary3DAxis = (iWhatToDraw & 0x11) == 17 && this.bRendering3D;
        this.dc = renderer.getDeferredCache();
        this.axisType = ax.getAxisType();
        this.panningOffset = renderer.getPanningOffset();
        this.bTransposed = renderer.isTransposed();
        this.daEndPoints3D = null;
        this.da3D = null;
        this.lo3d = null;
        this.t3dre = null;
        this.l3dre = null;
        this.bTickBetweenCategories = ax.isTickBwtweenCategories();
        this.bLabelWithinAxes = ax.getModelAxis().isLabelWithinAxes();
    }

    private RunTimeContext getRunTimeContext() {
        return this.renderer.getRunTimeContext();
    }

    private void processTrigger(Trigger tg, StructureSource source) {
        this.renderer.processTrigger(tg, source);
    }

    IAxisTypeComputation createAxisTypeComputation(ComputationContext context) throws ChartException {
        if ((this.sc.getType() & 0x10) == 16 || this.sc.isCategoryScale()) {
            return new TextAxisTypeComputation(context);
        }
        if ((this.sc.getType() & 2) == 2) {
            return new LinearAxisTypeComputation();
        }
        if ((this.sc.getType() & 4) == 4) {
            return new LogAxisTypeComputation();
        }
        if ((this.sc.getType() & 8) == 8) {
            return new DatetimeAxisTypeComputation();
        }
        throw new ChartException("org.eclipse.birt.chart.engine", 11, "exception.undefined.axis.type", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
    }

    private List<TextRenderEvent> renderVerticalAxisTickLabels(ComputationContext context, double dXEnd, double dZEnd, double dZ, double dStaggeredLabelOffset, boolean deferredAxisLabel) throws ChartException {
        ArrayList<TextRenderEvent> deferfedRenderList = new ArrayList<TextRenderEvent>();
        int iDirection = this.sc.getDirection() != 1 ? -1 : 1;
        IAxisTypeComputation computation = this.createAxisTypeComputation(context);
        computation.initialize();
        double dOffset = computation instanceof TextAxisTypeComputation && this.bTickBetweenCategories ? (double)iDirection * this.sc.getUnitSize() / 2.0 : 0.0;
        int length = computation instanceof TextAxisTypeComputation ? this.da.size() - 1 : this.da.size();
        double x = this.iLabelLocation == 1 ? context.dTick1 - 1.0 : context.dTick2 + 1.0;
        int yLast = Integer.MIN_VALUE;
        Location loMinorStart = goFactory.createLocation(0.0, 0.0);
        Location loMinorEnd = goFactory.createLocation(0.0, 0.0);
        int i = 0;
        while (i < length) {
            block28: {
                int y;
                block27: {
                    double dXMinorTick2;
                    boolean bSkipTickLine;
                    computation.handlePreEachTick(i);
                    y = (int)this.da.getCoordinate(i);
                    boolean bl = bSkipTickLine = yLast == y;
                    if (!bSkipTickLine) {
                        yLast = y;
                    }
                    if (this.bRendering3D) {
                        context.y3d = (int)this.da3D.getCoordinate(i);
                    }
                    if ((this.iWhatToDraw & 1) != 1) break block27;
                    double dXMinorTick1 = (this.iMinorTickStyle & 1) == 1 ? context.dX - this.pwa.getTickSize() : context.dX;
                    double d = dXMinorTick2 = (this.iMinorTickStyle & 2) == 2 ? context.dX + this.pwa.getTickSize() : context.dX;
                    if (!(ChartUtil.mathEqual(dXMinorTick1, dXMinorTick2) || i == this.da.size() - 1 || this.bRenderOrthogonal3DAxis || bSkipTickLine || (i <= 0 || i >= length - 1) && this.axModel.isCategoryAxis() && !this.bTickBetweenCategories)) {
                        LineRenderEvent lreMinor = null;
                        int minorStep = (int)(1.0 / this.da.getStep());
                        if (minorStep < 1) {
                            minorStep = 1;
                        }
                        int k = 0;
                        while (k < this.daMinor.length - 1) {
                            if (!(computation instanceof LinearAxisTypeComputation && (iDirection == -1 && (double)y - this.daMinor[k] <= this.da.getCoordinate(i + 1) || iDirection == 1 && (double)y + this.daMinor[k] >= this.da.getCoordinate(i + 1)))) {
                                lreMinor = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), LineRenderEvent.class);
                                lreMinor.setLineAttributes(this.liaMinorTick);
                                loMinorStart.set(dXMinorTick1, (double)y + (double)iDirection * this.daMinor[k]);
                                lreMinor.setStart(loMinorStart);
                                loMinorEnd.set(dXMinorTick2, (double)y + (double)iDirection * this.daMinor[k]);
                                lreMinor.setEnd(loMinorEnd);
                                this.ipr.drawLine(lreMinor);
                            }
                            k += minorStep;
                        }
                    }
                    if (computation instanceof TextAxisTypeComputation && !this.bTickBetweenCategories && i == 0) break block28;
                    if (!bSkipTickLine && !ChartUtil.mathEqual(context.dTick1, context.dTick2)) {
                        if (!this.bRenderOrthogonal3DAxis) {
                            this.lre.setLineAttributes(this.liaMajorTick);
                            this.lre.getStart().set(context.dTick1, y);
                            this.lre.getEnd().set(context.dTick2, y);
                            this.ipr.drawLine(this.lre);
                        }
                        if (this.iv != null && this.iDimension == 1 && this.iv.getType() == 3) {
                            this.lre.setStart(goFactory.createLocation(context.dX, y));
                            this.lre.setEnd(goFactory.createLocation(context.dX + this.dSeriesThickness, (double)y - this.dSeriesThickness));
                            this.ipr.drawLine(this.lre);
                        }
                    }
                }
                if (this.bRenderAxisLabels && this.sc.isTickLabelVisible(i)) {
                    double sx = x;
                    double sx2 = dXEnd;
                    if (this.bAxisLabelStaggered && this.sc.isTickLabelStaggered(i)) {
                        if (this.iLabelLocation == 1) {
                            sx -= dStaggeredLabelOffset;
                            sx2 += dStaggeredLabelOffset;
                        } else {
                            sx += dStaggeredLabelOffset;
                            sx2 -= dStaggeredLabelOffset;
                        }
                    }
                    ScriptHandler.callFunction(this.sh, "beforeDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", this.la);
                    if (this.ax.getLabel().isVisible() && this.la.isVisible()) {
                        if (this.bRendering3D) {
                            this.lo3d.set(sx - this.pwa.getHorizontalSpacingInPixels(), context.y3d + dOffset, dZEnd + this.pwa.getHorizontalSpacingInPixels());
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setTextPosition(1);
                            this.t3dre.setAction(2);
                            this.dc.addLabel(this.t3dre);
                            this.lo3d.set(sx2 + this.pwa.getHorizontalSpacingInPixels(), context.y3d + dOffset, dZ - this.pwa.getHorizontalSpacingInPixels());
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setTextPosition(2);
                            this.t3dre.setAction(2);
                            if (this.renderer.rtc.isRightToLeftText()) {
                                this.t3dre.setRtlCaption();
                            }
                            this.dc.addLabel(this.t3dre);
                        } else {
                            this.lo.set(sx, (double)y + dOffset);
                            this.tre.setAction(2);
                            if (this.bLabelWithinAxes) {
                                if (i == 0) {
                                    this.tre.setTextPosition(this.iLabelLocation | 0x100);
                                } else {
                                    this.tre.setTextPosition(this.iLabelLocation);
                                }
                            }
                            if (this.renderer.rtc.isRightToLeftText()) {
                                this.tre.setRtlCaption();
                            }
                            if (deferredAxisLabel) {
                                deferfedRenderList.add((TextRenderEvent)this.tre.copy());
                            } else {
                                this.ipr.drawText(this.tre);
                            }
                        }
                    }
                    this.addAxisLabelIA(this.lo.getX(), this.lo.getY());
                    ScriptHandler.callFunction(this.sh, "afterDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", this.la);
                }
                computation.handlePostEachTick(i);
            }
            ++i;
        }
        computation.close();
        return deferfedRenderList;
    }

    private void addAxisLabelIA(double x, double y) throws ChartException {
        if (this.renderer.isInteractivityEnabled()) {
            EList<Trigger> elTriggers = this.ax.getModelAxis().getTriggers();
            Location[] loaHotspot = new Location[4];
            RotatedRectangle rr = this.cComp.computePolygon(this.xs, this.iLabelLocation, this.la, x, y, null);
            List<Point> pts = rr.getPoints();
            int k = 0;
            while (k < 4) {
                Point pt = pts.get(k);
                loaHotspot[k] = goFactory.createLocation(pt.getX(), pt.getY());
                ++k;
            }
            StructureSource iSource = WrappedStructureSource.createAxisLabel(this.ax.getModelAxis(), this.la);
            InteractionEvent iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(iSource, InteractionEvent.class);
            iev.setCursor(this.ax.getModelAxis().getCursor());
            int t = 0;
            while (t < elTriggers.size()) {
                Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                this.processTrigger(tg, iSource);
                iev.addTrigger(tg);
                ++t;
            }
            PolygonRenderEvent pre = ((EventObjectCache)((Object)this.ipr)).getEventObject(iSource, PolygonRenderEvent.class);
            pre.setPoints(loaHotspot);
            iev.setHotSpot(pre);
            this.ipr.enableInteraction(iev);
        }
    }

    private List<TextRenderEvent> renderHorizontalAxisTickLabels(ComputationContext context, double dXEnd, double dZEnd, double dZ, double dStaggeredLabelOffset, boolean deferredAxisLabel) throws ChartException {
        int length;
        ArrayList<TextRenderEvent> deferfedRenderList = new ArrayList<TextRenderEvent>();
        int iDirection = this.sc.getDirection() == -1 ? -1 : 1;
        IAxisTypeComputation computation = this.createAxisTypeComputation(context);
        computation.initialize();
        double dOffset = computation instanceof TextAxisTypeComputation && this.bTickBetweenCategories ? (double)iDirection * this.sc.getUnitSize() / 2.0 : 0.0;
        int n = length = computation instanceof TextAxisTypeComputation ? this.da.size() - 1 : this.da.size();
        double y = this.iLabelLocation == 4 ? (this.bRendering3D ? context.dTick1 + 1.0 : context.dTick1 - 1.0) : (this.bRendering3D ? context.dTick2 - 1.0 : context.dTick2 + 1.0);
        int xLast = Integer.MIN_VALUE;
        Location loMinorStart = goFactory.createLocation(0.0, 0.0);
        Location loMinorEnd = goFactory.createLocation(0.0, 0.0);
        int i = 0;
        while (i < length) {
            block28: {
                int x;
                block27: {
                    double dYMinorTick2;
                    double dYMinorTick1;
                    boolean bSkipTickLine;
                    computation.handlePreEachTick(i);
                    x = (int)this.da.getCoordinate(i);
                    boolean bl = bSkipTickLine = x == xLast;
                    if (!bSkipTickLine) {
                        xLast = x;
                    }
                    if (this.bRendering3D) {
                        context.x3d = (int)this.da3D.getCoordinate(i);
                        context.z3d = (int)this.da3D.getCoordinate(i);
                    }
                    if ((this.iWhatToDraw & 1) != 1) break block27;
                    double d = (this.iMinorTickStyle & 1) == 1 ? (this.bRendering3D ? context.dY + this.pwa.getTickSize() : context.dY - this.pwa.getTickSize()) : (dYMinorTick1 = context.dY);
                    double d2 = (this.iMinorTickStyle & 2) == 2 ? (this.bRendering3D ? context.dY - this.pwa.getTickSize() : context.dY + this.pwa.getTickSize()) : (dYMinorTick2 = context.dY);
                    if (!(ChartUtil.mathEqual(dYMinorTick1, -dYMinorTick2) || i == this.da.size() - 1 || this.bRenderBase3DAxis || this.bRenderAncillary3DAxis || bSkipTickLine || (i <= 0 || i >= length - 1) && this.axModel.isCategoryAxis() && !this.bTickBetweenCategories)) {
                        LineRenderEvent lreMinor = null;
                        int minorStep = (int)(1.0 / this.da.getStep());
                        if (minorStep < 1) {
                            minorStep = 1;
                        }
                        int k = 0;
                        while (k < this.daMinor.length - 1) {
                            if (!(computation instanceof LinearAxisTypeComputation && (iDirection == 1 && (double)x + this.daMinor[k] >= this.da.getCoordinate(i + 1) || iDirection == -1 && (double)x - this.daMinor[k] <= this.da.getCoordinate(i + 1)))) {
                                lreMinor = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), LineRenderEvent.class);
                                lreMinor.setLineAttributes(this.liaMinorTick);
                                loMinorStart.set((double)x + (double)iDirection * this.daMinor[k], dYMinorTick1);
                                lreMinor.setStart(loMinorStart);
                                loMinorEnd.set((double)x + (double)iDirection * this.daMinor[k], dYMinorTick2);
                                lreMinor.setEnd(loMinorEnd);
                                this.ipr.drawLine(lreMinor);
                            }
                            k += minorStep;
                        }
                    }
                    if (computation instanceof TextAxisTypeComputation && !this.bTickBetweenCategories && i == 0) break block28;
                    if (!bSkipTickLine && !ChartUtil.mathEqual(context.dTick1, context.dTick2)) {
                        if (!this.bRenderBase3DAxis && !this.bRenderAncillary3DAxis) {
                            this.lre.setLineAttributes(this.liaMajorTick);
                            this.lre.getStart().set(x, context.dTick1);
                            this.lre.getEnd().set(x, context.dTick2);
                            this.ipr.drawLine(this.lre);
                        }
                        if (this.iv != null && this.iDimension == 1 && this.iv.getType() == 3) {
                            this.lre.getStart().set(x, context.dY);
                            this.lre.getEnd().set((double)x + this.dSeriesThickness, context.dY - this.dSeriesThickness);
                            this.ipr.drawLine(this.lre);
                        }
                    }
                }
                if (this.bRenderAxisLabels && this.sc.isTickLabelVisible(i)) {
                    ScriptHandler.callFunction(this.sh, "beforeDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawAxisLabel", this.la);
                    double sy = y;
                    if (this.bAxisLabelStaggered && this.sc.isTickLabelStaggered(i)) {
                        sy = this.iLabelLocation == 4 ? (sy -= dStaggeredLabelOffset) : (sy += dStaggeredLabelOffset);
                    }
                    if (this.ax.getLabel().isVisible() && this.la.isVisible()) {
                        if (this.bRendering3D) {
                            if (this.axisType == 5) {
                                this.lo3d.set(context.x3d + dOffset, sy - this.pwa.getVerticalSpacingInPixels(), dZEnd + this.pwa.getVerticalSpacingInPixels());
                            } else {
                                this.lo3d.set(dXEnd + this.pwa.getVerticalSpacingInPixels(), sy - this.pwa.getVerticalSpacingInPixels(), context.z3d + dOffset);
                            }
                            this.t3dre.setLocation3D(this.lo3d);
                            this.t3dre.setAction(2);
                            if (this.renderer.rtc.isRightToLeftText()) {
                                this.t3dre.setRtlCaption();
                            }
                            this.dc.addLabel(this.t3dre);
                        } else {
                            this.lo.set((double)x + dOffset, sy);
                            this.tre.setAction(2);
                            if (this.bLabelWithinAxes) {
                                if (i == 0) {
                                    this.tre.setTextPosition(this.iLabelLocation | 0x80);
                                } else {
                                    this.tre.setTextPosition(this.iLabelLocation);
                                }
                            }
                            if (this.renderer.rtc.isRightToLeftText()) {
                                this.tre.setRtlCaption();
                            }
                            if (deferredAxisLabel) {
                                deferfedRenderList.add((TextRenderEvent)this.tre.copy());
                            } else {
                                this.ipr.drawText(this.tre);
                            }
                        }
                    }
                    this.addAxisLabelIA(this.lo.getX(), this.lo.getY());
                    ScriptHandler.callFunction(this.sh, "afterDrawAxisLabel", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawAxisLabel", this.la);
                }
                computation.handlePostEachTick(i);
            }
            ++i;
        }
        computation.close();
        return deferfedRenderList;
    }

    public final void renderEachAxis() throws ChartException {
        double dStaggeredLabelOffset = this.sc.computeStaggeredAxisLabelOffset(this.xs, this.la, this.iOrientation);
        this.tre.setLabel(this.la);
        this.tre.setTextPosition(this.iLabelLocation);
        this.tre.setLocation(this.lo);
        this.lre.setLineAttributes(this.lia);
        this.lre.setStart(goFactory.createLocation(0.0, 0.0));
        this.lre.setEnd(goFactory.createLocation(0.0, 0.0));
        double dXStart = 0.0;
        double dXEnd = 0.0;
        double dZStart = 0.0;
        double dZEnd = 0.0;
        if (this.iDimension == 2) {
            AllAxes aax = this.pwa.getAxes();
            dXEnd = aax.getPrimaryBase().getScale().getEnd();
            dZEnd = aax.getAncillaryBase().getScale().getEnd();
            dXStart = aax.getPrimaryBase().getScale().getStart();
            dZStart = aax.getAncillaryBase().getScale().getStart();
            this.daEndPoints3D = this.sc.getEndPoints();
            this.da3D = this.sc.getTickCordinates();
            this.lo3d = goFactory.createLocation3D(0.0, 0.0, 0.0);
            this.t3dre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Text3DRenderEvent.class);
            this.t3dre.setLabel(this.la);
            this.t3dre.setAction(2);
            this.t3dre.setTextPosition(this.iLabelLocation);
            this.t3dre.setLocation3D(this.lo3d);
            this.l3dre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Line3DRenderEvent.class);
            this.l3dre.setLineAttributes(this.lia);
            this.l3dre.setStart3D(goFactory.createLocation3D(0.0, 0.0, 0.0));
            this.l3dre.setEnd3D(goFactory.createLocation3D(0.0, 0.0, 0.0));
        }
        if (this.iOrientation == 1) {
            this.renderVerticalAxis(dXStart, dXEnd, dZStart, dZEnd, dStaggeredLabelOffset);
        } else if (this.iOrientation == 0) {
            this.renderHorizontalAxis(dXEnd, dZEnd, dStaggeredLabelOffset);
        }
    }

    private void renderHorizontalAxis(double dXEnd, double dZEnd, double dStaggeredLabelOffset) throws ChartException {
        ComputationContext context = new ComputationContext(false);
        context.x3d = 0.0;
        context.z3d = 0.0;
        context.dY = this.dLocation;
        double dX = 0.0;
        double dZ = 0.0;
        if (this.bRendering3D) {
            Location3D l3d = this.ax.getAxisCoordinate3D();
            dX = l3d.getX();
            context.dY = l3d.getY();
            dZ = l3d.getZ();
        }
        double d = (this.iMajorTickStyle & 1) == 1 ? (this.bRendering3D ? context.dY + this.pwa.getTickSize() : context.dY - this.pwa.getTickSize()) : (context.dTick1 = context.dY);
        double d2 = (this.iMajorTickStyle & 2) == 2 ? (this.bRendering3D ? context.dY - this.pwa.getTickSize() : context.dY + this.pwa.getTickSize()) : (context.dTick2 = context.dY);
        if (this.iv != null && this.iDimension == 1 && (this.bTransposed && this.renderer.isRightToLeft() && this.iv.getType() == 2 || !this.renderer.isRightToLeft() && this.iv.getType() == 1)) {
            this.trae.setTransform(2);
            this.trae.setTranslation(this.dSeriesThickness, -this.dSeriesThickness);
            this.ipr.applyTransformation(this.trae);
        }
        List<TextRenderEvent> deferredEvents = this.renderHorizontalAxisTickLabels(context, dXEnd, dZEnd, dZ, dStaggeredLabelOffset, true);
        if ((this.iWhatToDraw & 1) == 1 && this.lia.isVisible()) {
            this.renderHorizontalAxisLine(context, dX, dZ);
        }
        if (deferredEvents != null && deferredEvents.size() > 0) {
            for (TextRenderEvent evt : deferredEvents) {
                this.ipr.drawText(evt);
            }
        }
        this.renderHorizontalAxisTitle(context, dXEnd, dZEnd, dZ);
        if (this.iv != null && this.iDimension == 1 && (this.bTransposed && this.renderer.isRightToLeft() && this.iv.getType() == 2 || !this.renderer.isRightToLeft() && this.iv.getType() == 1)) {
            this.trae.setTranslation(-this.dSeriesThickness, this.dSeriesThickness);
            this.ipr.applyTransformation(this.trae);
        }
    }

    private void renderHorizontalAxisTitle(ComputationContext context, double dXEnd, double dZEnd, double dZ) throws ChartException {
        this.la = goFactory.copyOf(this.ax.getTitle());
        if (this.la.isVisible() && this.bRenderAxisTitle) {
            ScriptHandler.callFunction(this.sh, "beforeDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", this.la);
            String sRestoreValue = this.la.getCaption().getValue();
            this.la.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sRestoreValue));
            this.la.getCaption().getFont().setAlignment(this.renderer.switchTextAlignment(this.la.getCaption().getFont().getAlignment()));
            if (this.ax.getTitle().isVisible() && this.la.isVisible()) {
                if (this.bRendering3D) {
                    BoundingBox bb = this.cComp.computeLabelSize(this.xs, this.la, Math.abs(this.daEndPoints[1] - this.daEndPoints[0]), null);
                    Angle3D a3D = (Angle3D)((ChartWithAxes)this.renderer.cm).getRotation().getAngles().get(0);
                    if (this.axisType == 5) {
                        this.t3dre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Text3DRenderEvent.class);
                        IAxisTypeComputation computation = this.createAxisTypeComputation(context);
                        computation.initialize();
                        int length = computation instanceof TextAxisTypeComputation ? this.da.size() - 1 : this.da.size();
                        OneAxis axxPB = this.pwa.getAxes().getPrimaryBase();
                        double xLabelThickness = this.cComp.computeHeight(this.xs, axxPB.getLabel());
                        int xStart = (int)this.da3D.getCoordinate(0);
                        int xEnd = (int)this.da3D.getCoordinate(length - 1);
                        int x = xStart + (xEnd - xStart) / 2;
                        Location3D location = goFactory.createLocation3D(x, context.dY - xLabelThickness - (dZEnd - dZ), dZEnd + this.pwa.getHorizontalSpacingInPixels() + xLabelThickness);
                        this.t3dre.setLocation3D(location);
                        this.t3dre.setLabel(this.la);
                        double yAngle = a3D.getYAngle() % 360.0;
                        if (yAngle > 0.0 && yAngle <= 180.0) {
                            this.t3dre.setTextPosition(1);
                        } else {
                            this.t3dre.setTextPosition(2);
                        }
                        this.t3dre.setAction(2);
                    } else {
                        double yAngle = a3D.getYAngle();
                        Location3D location = goFactory.createLocation3D(dXEnd + (dZEnd - dZ), context.dY - (dZEnd - dZ) / 2.0 - bb.getHeight() * (1.0 + Math.sin(Math.abs(yAngle))), dZ + (dZEnd - dZ) / 2.0);
                        this.t3dre.setLocation3D(location);
                        this.t3dre.setLabel(this.la);
                        double angle = a3D.getZAngle() % 360.0;
                        if (angle >= 0.0 && angle < 180.0) {
                            this.t3dre.setTextPosition(2);
                        } else {
                            this.t3dre.setTextPosition(1);
                        }
                        this.t3dre.setAction(2);
                    }
                    this.renderAxisTitleWith3DTextevent(bb);
                } else {
                    LabelLimiter lbLimit = this.pwa.getLabellLimiter(this.ax.getModelAxis().getTitle());
                    double dWidthWithinAxis = Math.abs(this.daEndPoints[1] - this.daEndPoints[0]);
                    if (lbLimit.getMaxWidth() > dWidthWithinAxis) {
                        lbLimit.setMaxWidth(dWidthWithinAxis);
                    }
                    lbLimit.computeWrapping(this.xs, this.la);
                    lbLimit = lbLimit.limitLabelSize(this.cComp, this.xs, this.la);
                    if (lbLimit.isSuccessed()) {
                        BoundingBox bb = lbLimit.getBounding(null);
                        Bounds bo = goFactory.createBounds(this.daEndPoints[0], this.ax.getTitleCoordinate(), this.daEndPoints[1] - this.daEndPoints[0], bb.getHeight());
                        this.tre.setBlockBounds(bo);
                        this.tre.setLabel(this.la);
                        TextAlignment ta = goFactory.copyOf(this.la.getCaption().getFont().getAlignment());
                        if (this.ax.getModelAxis().getAssociatedAxes().size() != 0) {
                            this.tre.setBlockAlignment(ta);
                        } else {
                            this.tre.setBlockAlignment(ChartUtil.transposeAlignment(ta));
                        }
                        this.la.getCaption().getFont().getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                        this.tre.setAction(3);
                        if (this.renderer.rtc.isRightToLeftText()) {
                            this.tre.setRtlCaption();
                        }
                        this.ipr.drawText(this.tre);
                    }
                }
            }
            ScriptHandler.callFunction(this.sh, "afterDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", this.la);
        }
        this.la = goFactory.copyOf(this.ax.getLabel());
    }

    private void renderHorizontalAxisLine(ComputationContext context, double dX, double dZ) throws ChartException {
        if (this.bRenderBase3DAxis) {
            EList<Trigger> elTriggers;
            double dStart = this.daEndPoints3D[0];
            double dEnd = this.daEndPoints3D[1];
            this.l3dre.setLineAttributes(this.lia);
            this.l3dre.setStart3D(dStart, context.dY, dZ);
            this.l3dre.setEnd3D(dEnd, context.dY, dZ);
            AxesRenderHelper.addLine3DEvent(this.l3dre, this.renderer.getRightWallEvent(), this.dc);
            if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                Polygon3DRenderEvent pre3d = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Polygon3DRenderEvent.class);
                Location3D[] loaHotspot = new Location3D[]{goFactory.createLocation3D(dStart, context.dY - 4.0, dZ), goFactory.createLocation3D(dStart, context.dY + 4.0, dZ), goFactory.createLocation3D(dEnd, context.dY + 4.0, dZ), goFactory.createLocation3D(dEnd, context.dY - 4.0, dZ)};
                pre3d.setPoints3D(loaHotspot);
                pre3d.setDoubleSided(true);
                if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                    InteractionEvent iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                    iev.setCursor(this.axModel.getCursor());
                    int t = 0;
                    while (t < elTriggers.size()) {
                        Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                        this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                        iev.addTrigger(tg);
                        ++t;
                    }
                    iev.setHotSpot(pre3d);
                    this.ipr.enableInteraction(iev);
                }
            }
        } else if (this.bRenderAncillary3DAxis) {
            EList<Trigger> elTriggers;
            double dStart = this.daEndPoints3D[0];
            double dEnd = this.daEndPoints3D[1];
            this.l3dre.setLineAttributes(this.lia);
            this.l3dre.setStart3D(dX, context.dY, dStart);
            this.l3dre.setEnd3D(dX, context.dY, dEnd);
            AxesRenderHelper.addLine3DEvent(this.l3dre, this.renderer.getLeftWallEvent(), this.dc);
            if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                Polygon3DRenderEvent pre3d = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Polygon3DRenderEvent.class);
                Location3D[] loaHotspot = new Location3D[]{goFactory.createLocation3D(dX, context.dY - 4.0, dStart), goFactory.createLocation3D(dX, context.dY + 4.0, dStart), goFactory.createLocation3D(dX, context.dY + 4.0, dEnd), goFactory.createLocation3D(dX, context.dY - 4.0, dEnd)};
                pre3d.setPoints3D(loaHotspot);
                pre3d.setDoubleSided(true);
                if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                    InteractionEvent iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                    iev.setCursor(this.axModel.getCursor());
                    int t = 0;
                    while (t < elTriggers.size()) {
                        Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                        this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                        iev.addTrigger(tg);
                        ++t;
                    }
                    iev.setHotSpot(pre3d);
                    this.ipr.enableInteraction(iev);
                }
            }
        } else {
            EList<Trigger> elTriggers;
            double dStart = this.daEndPoints[0] - this.insCA.getLeft();
            double dEnd = this.daEndPoints[1] + this.insCA.getRight();
            if (this.sc.getDirection() == -1) {
                dStart = this.daEndPoints[1] - this.insCA.getLeft();
                dEnd = this.daEndPoints[0] + this.insCA.getRight();
            }
            if (this.iv != null && this.iv.getType() == 3 && this.iDimension == 1) {
                Location[] loa = new Location[]{goFactory.createLocation(dStart, context.dY), goFactory.createLocation(dStart + this.dSeriesThickness, context.dY - this.dSeriesThickness), goFactory.createLocation(dEnd + this.dSeriesThickness, context.dY - this.dSeriesThickness), goFactory.createLocation(dEnd, context.dY)};
                PolygonRenderEvent pre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(goFactory.createColorDefinition(255, 255, 255, 127));
                pre.setOutline(this.lia);
                this.ipr.fillPolygon(pre);
            }
            this.lre.setLineAttributes(this.lia);
            this.lre.getStart().set(dStart, context.dY);
            this.lre.getEnd().set(dEnd, context.dY);
            this.ipr.drawLine(this.lre);
            if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                InteractionEvent iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                iev.setCursor(this.axModel.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                    iev.addTrigger(tg);
                    ++t;
                }
                Location[] loaHotspot = new Location[]{goFactory.createLocation(dStart, context.dY - 2.0), goFactory.createLocation(dEnd, context.dY - 2.0), goFactory.createLocation(dEnd, context.dY + 2.0), goFactory.createLocation(dStart, context.dY + 2.0)};
                PolygonRenderEvent pre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), PolygonRenderEvent.class);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                this.ipr.enableInteraction(iev);
            }
        }
    }

    private void renderVerticalAxis(double dXStart, double dXEnd, double dZStart, double dZEnd, double dStaggeredLabelOffset) throws ChartException {
        ComputationContext context = new ComputationContext(true);
        context.y3d = 0.0;
        context.dX = this.dLocation;
        double dZ = 0.0;
        if (this.bRendering3D) {
            Location3D l3d = this.ax.getAxisCoordinate3D();
            context.dX = l3d.getX();
            dZ = l3d.getZ();
        }
        if (this.iv != null && this.iv.getType() == 1 && this.iDimension == 1) {
            this.trae.setTransform(2);
            this.trae.setTranslation(this.dSeriesThickness, -this.dSeriesThickness);
            this.ipr.applyTransformation(this.trae);
        }
        context.dTick1 = (this.iMajorTickStyle & 1) == 1 ? context.dX - this.pwa.getTickSize() : context.dX;
        context.dTick2 = (this.iMajorTickStyle & 2) == 2 ? context.dX + this.pwa.getTickSize() : context.dX;
        List<TextRenderEvent> deferredEvents = this.renderVerticalAxisTickLabels(context, dXEnd, dZEnd, dZ, dStaggeredLabelOffset, true);
        if ((this.iWhatToDraw & 1) == 1 && this.lia.isVisible()) {
            this.renderVerticalAxisLine(context, dXStart, dXEnd, dZStart, dZEnd, dZ);
        }
        if (deferredEvents != null && deferredEvents.size() > 0) {
            for (TextRenderEvent evt : deferredEvents) {
                this.ipr.drawText(evt);
            }
        }
        this.renderVerticalAxisTitle(context, dXEnd, dZEnd, dZ, dStaggeredLabelOffset);
        if (this.iv != null && this.iv.getType() == 1 && this.iDimension == 1) {
            this.trae.setTranslation(-this.dSeriesThickness, this.dSeriesThickness);
            this.ipr.applyTransformation(this.trae);
        }
    }

    private void renderVerticalAxisTitle(ComputationContext context, double dXEnd, double dZEnd, double dZ, double dStaggeredLabelOffset) throws ChartException {
        this.la = goFactory.copyOf(this.ax.getTitle());
        if (this.la.isVisible() && this.bRenderAxisTitle) {
            ScriptHandler.callFunction(this.sh, "beforeDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("beforeDrawAxisTitle", this.la);
            String sRestoreValue = this.la.getCaption().getValue();
            this.la.getCaption().setValue(this.getRunTimeContext().externalizedMessage(sRestoreValue));
            if (this.ax.getTitle().isVisible() && this.la.isVisible()) {
                if (this.bRendering3D) {
                    BoundingBox bbWoWrap;
                    BoundingBox bb = null;
                    boolean bWithinAxis = false;
                    boolean bTitleHorizontal = Math.abs(this.la.getCaption().getFont().getRotation()) <= 30.0;
                    double dYAxisHeightPC = ChartUtil.computeHeightOfOrthogonalAxisTitle((ChartWithAxes)this.renderer.cm, this.xs);
                    bWithinAxis = bTitleHorizontal ? true : (bbWoWrap = this.cComp.computeLabelSize(this.xs, this.la, dYAxisHeightPC, null)).getHeight() < this.daEndPoints[0] - this.daEndPoints[1];
                    bb = this.cComp.computeLabelSize(this.xs, this.la, bWithinAxis && !bTitleHorizontal ? this.daEndPoints[0] - this.daEndPoints[1] : dYAxisHeightPC, null);
                    Angle3D a3D = (Angle3D)((ChartWithAxes)this.renderer.cm).getRotation().getAngles().get(0);
                    double yAxisAngle = a3D.getYAngle() * Math.PI / 180.0;
                    double yCenter = this.daEndPoints3D[0] + (this.daEndPoints3D[1] - this.daEndPoints3D[0]) / 2.0;
                    double leftYAxisTitlePosition = context.dX;
                    double rightYAxisTitlePosition = dXEnd;
                    if (this.bAxisLabelStaggered) {
                        if (this.iLabelLocation == 1) {
                            leftYAxisTitlePosition -= dStaggeredLabelOffset;
                            rightYAxisTitlePosition += dStaggeredLabelOffset;
                        } else {
                            leftYAxisTitlePosition += dStaggeredLabelOffset;
                            rightYAxisTitlePosition -= dStaggeredLabelOffset;
                        }
                    }
                    OneAxis axxPV = this.pwa.getAxes().getPrimaryOrthogonal();
                    double yLabelThickness = axxPV.getScale().computeAxisLabelThickness(this.xs, axxPV.getLabel(), 1);
                    double offset = this.pwa.getVerticalSpacingInPixels();
                    double minAngle = 0.6108652381980153;
                    double angle = yAxisAngle;
                    if (Math.abs(yAxisAngle) < minAngle) {
                        angle = minAngle;
                    }
                    double leftTitleYDelta = (this.pwa.getVerticalSpacingInPixels() + yLabelThickness + bb.getWidth() + offset) * (1.0 + Math.abs(Math.sin(angle)));
                    double leftTitleZDelta = (this.pwa.getVerticalSpacingInPixels() + bb.getWidth() + offset) * (1.0 + Math.sin(Math.abs(yAxisAngle)));
                    double zPosition = dZ;
                    zPosition = yAxisAngle >= 0.0 ? dZEnd + leftTitleZDelta + (dZEnd - dZ) * (1.0 + Math.sin(Math.abs(yAxisAngle))) : dZ - leftTitleZDelta;
                    this.t3dre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Text3DRenderEvent.class);
                    this.t3dre.setLocation3D(goFactory.createLocation3D(leftYAxisTitlePosition - leftTitleYDelta, yCenter, zPosition));
                    this.t3dre.setLabel(this.la);
                    this.t3dre.setTextPosition(1);
                    this.t3dre.setAction(2);
                    this.renderAxisTitleWith3DTextevent(bb);
                    this.t3dre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Text3DRenderEvent.class);
                    angle = yAxisAngle;
                    if (Math.abs(yAxisAngle) < minAngle) {
                        angle = minAngle;
                    }
                    double rightTitleYDelta = (this.pwa.getVerticalSpacingInPixels() + yLabelThickness + offset) * (1.0 + Math.abs(Math.sin(angle)));
                    double rightTitleZDelta = (this.pwa.getVerticalSpacingInPixels() + yLabelThickness + offset) * Math.abs(Math.sin(angle));
                    zPosition = dZ;
                    zPosition = yAxisAngle <= 0.0 ? dZEnd + rightTitleZDelta : dZ - rightTitleZDelta;
                    this.t3dre.setLocation3D(goFactory.createLocation3D(rightYAxisTitlePosition + rightTitleYDelta, yCenter, zPosition));
                    this.t3dre.setLabel(this.la);
                    this.t3dre.setTextPosition(2);
                    this.t3dre.setAction(2);
                    this.renderAxisTitleWith3DTextevent(bb);
                } else {
                    LabelLimiter lbLimit = this.pwa.getLabellLimiter(this.ax.getModelAxis().getTitle());
                    lbLimit.computeWrapping(this.xs, this.la);
                    lbLimit = lbLimit.limitLabelSize(this.cComp, this.xs, this.la);
                    if (lbLimit.isSuccessed()) {
                        BoundingBox bb = lbLimit.getBounding(null);
                        boolean bWithinAxis = false;
                        boolean bTitleHorizontal = Math.abs(this.la.getCaption().getFont().getRotation()) <= 30.0;
                        double dYAxisHeightPC = ChartUtil.computeHeightOfOrthogonalAxisTitle((ChartWithAxes)this.renderer.cm, this.xs);
                        double dHeightWithinAxis = this.daEndPoints[0] - this.daEndPoints[1];
                        if (ChartUtil.isStudyLayout(this.renderer.cm)) {
                            dYAxisHeightPC = dHeightWithinAxis;
                        }
                        bWithinAxis = bTitleHorizontal || lbLimit.getMaxHeight() < dHeightWithinAxis;
                        double dTop = this.computeTopOfOrthogonalAxisTitle();
                        if (ChartUtil.isStudyLayout(this.renderer.cm)) {
                            dTop = this.daEndPoints[1];
                        }
                        Bounds bo = goFactory.createBounds(this.ax.getTitleCoordinate(), bWithinAxis ? this.daEndPoints[1] : dTop, bb.getWidth(), bWithinAxis ? dHeightWithinAxis : dYAxisHeightPC);
                        this.tre.setBlockBounds(bo);
                        this.tre.setLabel(this.la);
                        TextAlignment ta = goFactory.copyOf(this.la.getCaption().getFont().getAlignment());
                        if (this.ax.getModelAxis().getAssociatedAxes().size() != 0) {
                            this.tre.setBlockAlignment(ChartUtil.transposeAlignment(ta));
                        } else {
                            this.tre.setBlockAlignment(ta);
                        }
                        this.la.getCaption().getFont().getAlignment().setHorizontalAlignment(HorizontalAlignment.LEFT_LITERAL);
                        this.tre.setAction(3);
                        if (this.ax.getTitle().isVisible()) {
                            if (this.renderer.rtc.isRightToLeftText()) {
                                this.tre.setRtlCaption();
                            }
                            this.ipr.drawText(this.tre);
                        }
                    }
                }
            }
            this.la.getCaption().setValue(sRestoreValue);
            ScriptHandler.callFunction(this.sh, "afterDrawAxisTitle", this.axModel, this.la, this.getRunTimeContext().getScriptContext());
            this.getRunTimeContext().notifyStructureChange("afterDrawAxisTitle", this.la);
        }
        this.la = goFactory.copyOf(this.ax.getLabel());
    }

    private void renderVerticalAxisLine(ComputationContext context, double dXStart, double dXEnd, double dZStart, double dZEnd, double dZ) throws ChartException {
        if (this.bRenderOrthogonal3DAxis) {
            EList<Trigger> elTriggers;
            double dStart = this.daEndPoints3D[0];
            double dEnd = this.daEndPoints3D[1];
            this.l3dre.setLineAttributes(this.lia);
            this.l3dre.setStart3D(context.dX, dStart, dZ);
            this.l3dre.setEnd3D(context.dX, dEnd, dZ);
            AxesRenderHelper.addLine3DEvent(this.l3dre, this.renderer.getRightWallEvent(), this.dc);
            this.l3dre.setStart3D(context.dX, dStart, dZEnd);
            this.l3dre.setEnd3D(context.dX, dEnd, dZEnd);
            AxesRenderHelper.addLine3DEvent(this.l3dre, this.renderer.getLeftWallEvent(), this.dc);
            this.l3dre.setStart3D(dXEnd, dStart, dZ);
            this.l3dre.setEnd3D(dXEnd, dEnd, dZ);
            AxesRenderHelper.addLine3DEvent(this.l3dre, this.renderer.getRightWallEvent(), this.dc);
            if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                Trigger tg;
                int t;
                InteractionEvent iev;
                ArrayList<Trigger> cachedTriggers = null;
                Location3D[] loaHotspot = new Location3D[4];
                Polygon3DRenderEvent pre3d = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Polygon3DRenderEvent.class);
                loaHotspot[0] = goFactory.createLocation3D(context.dX - 4.0, dStart, dZ + 4.0);
                loaHotspot[1] = goFactory.createLocation3D(context.dX + 4.0, dStart, dZ - 4.0);
                loaHotspot[2] = goFactory.createLocation3D(context.dX + 4.0, dEnd, dZ - 4.0);
                loaHotspot[3] = goFactory.createLocation3D(context.dX - 4.0, dEnd, dZ + 4.0);
                pre3d.setPoints3D(loaHotspot);
                pre3d.setDoubleSided(true);
                if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                    iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                    iev.setCursor(this.axModel.getCursor());
                    cachedTriggers = new ArrayList<Trigger>();
                    t = 0;
                    while (t < elTriggers.size()) {
                        tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                        this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                        cachedTriggers.add(tg);
                        iev.addTrigger(goFactory.copyOf(tg));
                        ++t;
                    }
                    iev.setHotSpot(pre3d);
                    this.ipr.enableInteraction(iev);
                }
                pre3d = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Polygon3DRenderEvent.class);
                loaHotspot = new Location3D[]{goFactory.createLocation3D(dXStart - 4.0, dStart, dZEnd + 4.0), goFactory.createLocation3D(dXStart + 4.0, dStart, dZEnd - 4.0), goFactory.createLocation3D(dXStart + 4.0, dEnd, dZEnd - 4.0), goFactory.createLocation3D(dXStart - 4.0, dEnd, dZEnd + 4.0)};
                pre3d.setPoints3D(loaHotspot);
                pre3d.setDoubleSided(true);
                if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                    iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                    iev.setCursor(this.axModel.getCursor());
                    if (cachedTriggers == null) {
                        cachedTriggers = new ArrayList();
                        t = 0;
                        while (t < elTriggers.size()) {
                            tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                            cachedTriggers.add(tg);
                            iev.addTrigger(goFactory.copyOf(tg));
                            ++t;
                        }
                    } else {
                        t = 0;
                        while (t < cachedTriggers.size()) {
                            iev.addTrigger(goFactory.copyOf((Trigger)cachedTriggers.get(t)));
                            ++t;
                        }
                    }
                    iev.setHotSpot(pre3d);
                    this.ipr.enableInteraction(iev);
                }
                pre3d = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), Polygon3DRenderEvent.class);
                loaHotspot = new Location3D[]{goFactory.createLocation3D(dXEnd - 4.0, dStart, dZStart + 4.0), goFactory.createLocation3D(dXEnd + 4.0, dStart, dZStart - 4.0), goFactory.createLocation3D(dXEnd + 4.0, dEnd, dZStart - 4.0), goFactory.createLocation3D(dXEnd - 4.0, dEnd, dZStart + 4.0)};
                pre3d.setPoints3D(loaHotspot);
                pre3d.setDoubleSided(true);
                if (this.renderer.get3DEngine().processEvent(pre3d, this.panningOffset.getX(), this.panningOffset.getY()) != null) {
                    iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                    iev.setCursor(this.axModel.getCursor());
                    if (cachedTriggers == null) {
                        t = 0;
                        while (t < elTriggers.size()) {
                            tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                            this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                            iev.addTrigger(tg);
                            ++t;
                        }
                    } else {
                        t = 0;
                        while (t < cachedTriggers.size()) {
                            iev.addTrigger((Trigger)cachedTriggers.get(t));
                            ++t;
                        }
                    }
                    iev.setHotSpot(pre3d);
                    this.ipr.enableInteraction(iev);
                }
            }
        } else {
            EList<Trigger> elTriggers;
            double dStart = this.daEndPoints[0] + this.insCA.getBottom();
            double dEnd = this.daEndPoints[1] - this.insCA.getTop();
            if (this.sc.getDirection() == 1) {
                dStart = this.daEndPoints[1] + this.insCA.getBottom();
                dEnd = this.daEndPoints[0] - this.insCA.getTop();
            }
            if (this.iv != null && this.iv.getType() == 3 && this.iDimension == 1) {
                Location[] loa = new Location[]{goFactory.createLocation(context.dX, dStart), goFactory.createLocation(context.dX + this.dSeriesThickness, dStart - this.dSeriesThickness), goFactory.createLocation(context.dX + this.dSeriesThickness, dEnd - this.dSeriesThickness), goFactory.createLocation(context.dX, dEnd)};
                PolygonRenderEvent pre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), PolygonRenderEvent.class);
                pre.setPoints(loa);
                pre.setBackground(goFactory.createColorDefinition(255, 255, 255, 127));
                pre.setOutline(this.lia);
                this.ipr.fillPolygon(pre);
            }
            this.lre.setLineAttributes(this.lia);
            this.lre.getStart().set(context.dX, dStart);
            this.lre.getEnd().set(context.dX, dEnd);
            this.ipr.drawLine(this.lre);
            if (this.renderer.isInteractivityEnabled() && !(elTriggers = this.axModel.getTriggers()).isEmpty()) {
                InteractionEvent iev = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), InteractionEvent.class);
                iev.setCursor(this.axModel.getCursor());
                int t = 0;
                while (t < elTriggers.size()) {
                    Trigger tg = goFactory.copyOf((Trigger)elTriggers.get(t));
                    this.processTrigger(tg, StructureSource.createAxis(this.axModel));
                    iev.addTrigger(tg);
                    ++t;
                }
                Location[] loaHotspot = new Location[]{goFactory.createLocation(context.dX - 2.0, dStart), goFactory.createLocation(context.dX + 2.0, dStart), goFactory.createLocation(context.dX + 2.0, dEnd), goFactory.createLocation(context.dX - 2.0, dEnd)};
                PolygonRenderEvent pre = ((EventObjectCache)((Object)this.ipr)).getEventObject(StructureSource.createAxis(this.axModel), PolygonRenderEvent.class);
                pre.setPoints(loaHotspot);
                iev.setHotSpot(pre);
                this.ipr.enableInteraction(iev);
            }
        }
    }

    private void renderAxisTitleWith3DTextevent(BoundingBox bb) throws ChartException {
        Location lo = this.get3DTextLocation(this.t3dre);
        this.tre.setLocation(lo);
        this.tre.setTextPosition(this.t3dre.getTextPosition());
        this.tre.setLabel(this.la);
        this.limitAxisTitleLocation(this.tre, bb);
        this.tre.setAction(2);
        if (this.renderer.rtc.isRightToLeftText()) {
            this.tre.setRtlCaption();
        }
        this.ipr.drawText(this.tre);
    }

    private Location get3DTextLocation(Text3DRenderEvent t3dre) throws ChartException {
        PlotWith3DAxes pwa3D = (PlotWith3DAxes)this.pwa;
        Engine3D engine = pwa3D.get3DEngine();
        Location lo_off = pwa3D.getPanningOffset();
        engine.processEvent_noclip(t3dre, lo_off.getX(), lo_off.getY());
        return t3dre.getLocation();
    }

    private void limitAxisTitleLocation(TextRenderEvent tre, BoundingBox bb) {
        Location lo = tre.getLocation();
        Bounds cbo = this.renderer.getPlotBounds();
        double xmin = cbo.getLeft();
        double ymin = cbo.getTop();
        double xmax = xmin + cbo.getWidth();
        double ymax = ymin + cbo.getHeight();
        int pos = tre.getTextPosition();
        if (pos == 2) {
            xmax -= bb.getWidth();
            ymin += bb.getHeight() / 2.0;
            ymax -= bb.getHeight() / 2.0;
        } else if (pos == 1) {
            xmin += bb.getWidth();
            ymin += bb.getHeight() / 2.0;
            ymax -= bb.getHeight() / 2.0;
        } else if (pos == 4) {
            ymin += bb.getHeight();
        } else {
            ymax -= bb.getHeight();
        }
        if (lo.getX() < xmin) {
            lo.setX(xmin);
        } else if (lo.getX() > xmax) {
            lo.setX(xmax);
        }
        if (lo.getY() < ymin) {
            lo.setY(ymin);
        } else if (lo.getY() > ymax) {
            lo.setY(ymax);
        }
    }

    private double computeTopOfOrthogonalAxisTitle() {
        Bounds titleBounds = this.renderer.cm.getTitle().getBounds();
        Bounds legendBounds = this.renderer.cm.getLegend().getBounds();
        if (this.renderer.cm.getTitle().getAnchor().getValue() == 0) {
            if (this.renderer.cm.getLegend().getPosition().getValue() == 0) {
                return (legendBounds.getTop() + legendBounds.getHeight()) / 72.0 * (double)this.xs.getDpiResolution();
            }
            return (titleBounds.getTop() + titleBounds.getHeight()) / 72.0 * (double)this.xs.getDpiResolution();
        }
        if (this.renderer.cm.getLegend().getPosition().getValue() == 0) {
            return (legendBounds.getTop() + legendBounds.getHeight()) / 72.0 * (double)this.xs.getDpiResolution();
        }
        return this.renderer.cm.getBlock().getBounds().getTop() / 72.0 * (double)this.xs.getDpiResolution();
    }

    public static void addLine3DEvent(Line3DRenderEvent lre3d, Object parentEvent, DeferredCache dc) {
        if (parentEvent != null && parentEvent instanceof WrappedInstruction) {
            if (((WrappedInstruction)parentEvent).getSubDeferredCache() == null) {
                ((WrappedInstruction)parentEvent).setSubDeferredCache(dc.deriveNewDeferredCache());
            }
            ((WrappedInstruction)parentEvent).getSubDeferredCache().addLine(lre3d);
        } else {
            if (parentEvent != null) {
                lre3d.setObject3DParent(Engine3D.getObjectFromEvent(parentEvent));
            }
            dc.addLine(lre3d);
        }
    }

    private static final class ComputationContext {
        boolean isVertical;
        double dTick1;
        double dTick2;
        double dX;
        double y3d;
        double dY;
        double x3d;
        double z3d;

        public ComputationContext(boolean isVertical) {
            this.isVertical = isVertical;
        }
    }

    private final class DatetimeAxisTypeComputation
    implements IAxisTypeComputation {
        CDateTime cdt;
        CDateTime cdtAxisValue;
        int iUnit;
        int iStep;
        IDateFormatWrapper sdf;

        private DatetimeAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            this.cdt = i == AxesRenderHelper.this.da.size() - 2 && !AxesRenderHelper.this.sc.isSetFactor() ? Methods.asDateTime(AxesRenderHelper.this.sc.getMaximum()) : this.cdtAxisValue.forward(this.iUnit, this.iStep * (i + 1));
        }

        public void handlePreEachTick(int i) throws ChartException {
            try {
                AxesRenderHelper.this.sText = ValueFormatter.format((Object)this.cdt, AxesRenderHelper.this.axModel.getFormatSpecifier(), AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), this.sdf);
            }
            catch (ChartException dfex) {
                logger.log((Exception)((Object)dfex));
                AxesRenderHelper.this.sText = IConstants.NULL_STRING;
            }
            AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
        }

        public void initialize() throws ChartException {
            this.cdtAxisValue = Methods.asDateTime(AxesRenderHelper.this.sc.getMinimum());
            this.iUnit = Methods.asInteger(AxesRenderHelper.this.sc.getUnit());
            this.iStep = Methods.asInteger(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.axModel.getFormatSpecifier() == null) {
                this.sdf = DateFormatWrapperFactory.getPreferredDateFormat(this.iUnit, AxesRenderHelper.this.getRunTimeContext().getULocale());
            }
            this.cdt = this.cdtAxisValue;
        }
    }

    static interface IAxisTypeComputation {
        public void initialize() throws ChartException;

        public void close() throws ChartException;

        public void handlePreEachTick(int var1) throws ChartException;

        public void handlePostEachTick(int var1) throws ChartException;
    }

    private final class LinearAxisTypeComputation
    implements IAxisTypeComputation {
        double dAxisValue;
        double dAxisStep;
        BigDecimal bdAxisValue;
        BigDecimal bdAxisStep;

        private LinearAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            this.dAxisValue = i == AxesRenderHelper.this.da.size() - 2 && !AxesRenderHelper.this.sc.isSetFactor() ? Methods.asDouble(AxesRenderHelper.this.sc.getMaximum()) : (this.dAxisValue += this.dAxisStep);
            if (AxesRenderHelper.this.sc.isBigNumber()) {
                this.bdAxisValue = BigDecimal.valueOf((double)this.dAxisValue).multiply(AxesRenderHelper.this.sc.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT);
            }
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels && AxesRenderHelper.this.sc.isTickLabelVisible(i)) {
                try {
                    if (AxesRenderHelper.this.sc.isBigNumber()) {
                        AxesRenderHelper.this.sText = ValueFormatter.format(this.bdAxisValue, AxesRenderHelper.this.axModel.getFormatSpecifier(), AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                    } else {
                        AxesRenderHelper.this.nde.setValue(this.dAxisValue);
                        AxesRenderHelper.this.sText = ValueFormatter.format(AxesRenderHelper.this.nde, AxesRenderHelper.this.axModel.getFormatSpecifier(), AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                    }
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    AxesRenderHelper.this.sText = IConstants.NULL_STRING;
                }
                AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
            }
        }

        public void initialize() throws ChartException {
            this.dAxisValue = Methods.asDouble(AxesRenderHelper.this.sc.getMinimum());
            this.dAxisStep = Methods.asDouble(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.sc.isBigNumber()) {
                this.bdAxisValue = BigDecimal.valueOf((double)this.dAxisValue).multiply(AxesRenderHelper.this.sc.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT);
                this.bdAxisStep = BigDecimal.valueOf((double)this.dAxisStep);
                if (AxesRenderHelper.this.axModel.getFormatSpecifier() == null) {
                    AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.bdAxisValue, this.bdAxisStep.multiply(AxesRenderHelper.this.sc.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT));
                }
            } else if (AxesRenderHelper.this.axModel.getFormatSpecifier() == null) {
                AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.dAxisValue, this.dAxisStep);
            }
        }
    }

    private final class LogAxisTypeComputation
    implements IAxisTypeComputation {
        double dAxisValue;
        double dAxisStep;
        BigDecimal bdAxisValue;
        BigDecimal bdAxisStep;

        private LogAxisTypeComputation() {
        }

        public void close() throws ChartException {
        }

        public void handlePostEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.sc.isBigNumber()) {
                this.bdAxisValue = this.bdAxisValue.multiply(this.bdAxisStep, NumberUtil.DEFAULT_MATHCONTEXT);
            } else {
                this.dAxisValue *= this.dAxisStep;
            }
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels) {
                try {
                    if (AxesRenderHelper.this.sc.isBigNumber()) {
                        AxesRenderHelper.this.sText = ValueFormatter.format(this.bdAxisValue, AxesRenderHelper.this.axModel.getFormatSpecifier(), AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                    } else {
                        AxesRenderHelper.this.nde.setValue(this.dAxisValue);
                        AxesRenderHelper.this.sText = ValueFormatter.format(AxesRenderHelper.this.nde, AxesRenderHelper.this.axModel.getFormatSpecifier(), AxesRenderHelper.this.ax.getRunTimeContext().getULocale(), AxesRenderHelper.this.df);
                    }
                }
                catch (ChartException dfex) {
                    logger.log((Exception)((Object)dfex));
                    AxesRenderHelper.this.sText = IConstants.NULL_STRING;
                }
                AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sText);
            }
        }

        public void initialize() throws ChartException {
            this.dAxisValue = Methods.asDouble(AxesRenderHelper.this.sc.getMinimum());
            this.dAxisStep = Methods.asDouble(AxesRenderHelper.this.sc.getStep());
            if (AxesRenderHelper.this.sc.isBigNumber()) {
                this.bdAxisValue = BigDecimal.valueOf((double)this.dAxisValue).multiply(AxesRenderHelper.this.sc.getBigNumberDivisor(), NumberUtil.DEFAULT_MATHCONTEXT);
                this.bdAxisStep = BigDecimal.valueOf((double)this.dAxisStep);
                if (AxesRenderHelper.this.axModel.getFormatSpecifier() == null) {
                    AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.bdAxisValue, this.bdAxisStep);
                }
            } else if (AxesRenderHelper.this.axModel.getFormatSpecifier() == null) {
                AxesRenderHelper.this.df = AxesRenderHelper.this.sc.computeDecimalFormat(this.dAxisValue, this.dAxisStep);
            }
        }
    }

    private final class TextAxisTypeComputation
    implements IAxisTypeComputation {
        ComputationContext context;

        TextAxisTypeComputation(ComputationContext context) {
            this.context = context;
        }

        public void initialize() throws ChartException {
            AxesRenderHelper.this.sc.getData().reset();
        }

        public void close() throws ChartException {
            if (AxesRenderHelper.this.bTickBetweenCategories) {
                if (this.context.isVertical) {
                    int y = (int)AxesRenderHelper.this.da.getEnd();
                    if (AxesRenderHelper.this.bRendering3D) {
                        this.context.y3d = (int)AxesRenderHelper.this.da3D.getEnd();
                    }
                    if (!ChartUtil.mathEqual(this.context.dTick1, this.context.dTick2)) {
                        if (!AxesRenderHelper.this.bRenderOrthogonal3DAxis) {
                            AxesRenderHelper.this.lre.setLineAttributes(AxesRenderHelper.this.liaMajorTick);
                            AxesRenderHelper.this.lre.getStart().set(this.context.dTick1, y);
                            AxesRenderHelper.this.lre.getEnd().set(this.context.dTick2, y);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                        if (AxesRenderHelper.this.iv != null && AxesRenderHelper.this.iDimension == 1 && AxesRenderHelper.this.iv.getType() == 3) {
                            AxesRenderHelper.this.lre.setStart(goFactory.createLocation(this.context.dX, y));
                            AxesRenderHelper.this.lre.setEnd(goFactory.createLocation(this.context.dX + AxesRenderHelper.this.dSeriesThickness, (double)y - AxesRenderHelper.this.dSeriesThickness));
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                    }
                } else {
                    int x = (int)AxesRenderHelper.this.da.getEnd();
                    if ((AxesRenderHelper.this.iWhatToDraw & 1) == 1 && !ChartUtil.mathEqual(this.context.dTick1, this.context.dTick2)) {
                        if (!AxesRenderHelper.this.bRenderBase3DAxis && !AxesRenderHelper.this.bRenderAncillary3DAxis) {
                            AxesRenderHelper.this.lre.setLineAttributes(AxesRenderHelper.this.liaMajorTick);
                            AxesRenderHelper.this.lre.getStart().set(x, this.context.dTick1);
                            AxesRenderHelper.this.lre.getEnd().set(x, this.context.dTick2);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                        if (AxesRenderHelper.this.iv != null && AxesRenderHelper.this.iDimension == 1 && AxesRenderHelper.this.iv.getType() == 3) {
                            AxesRenderHelper.this.lre.getStart().set(x, this.context.dY);
                            AxesRenderHelper.this.lre.getEnd().set((double)x + AxesRenderHelper.this.dSeriesThickness, this.context.dY - AxesRenderHelper.this.dSeriesThickness);
                            AxesRenderHelper.this.ipr.drawLine(AxesRenderHelper.this.lre);
                        }
                    }
                }
            }
        }

        public void handlePostEachTick(int i) throws ChartException {
        }

        public void handlePreEachTick(int i) throws ChartException {
            if (AxesRenderHelper.this.bRenderAxisLabels) {
                if (!AxesRenderHelper.this.bTickBetweenCategories && i == 0) {
                    AxesRenderHelper.this.la.getCaption().setValue("");
                } else {
                    AxesRenderHelper.this.la.getCaption().setValue(AxesRenderHelper.this.sc.getComputedLabelText(i));
                }
            }
        }
    }
}

