/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.refactoring;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XbasePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionUtil {
    @Inject
    protected ILocationInFileProvider locationInFileProvider;

    public XExpression findSelectedExpression(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            ICompositeNode rootNode = parseResult.getRootNode();
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)selection.getOffset());
            if (node == null) {
                return null;
            }
            if (this.isHidden((INode)node)) {
                node = selection.getLength() > node.getLength() ? NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)node.getEndOffset()) : NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selection.getOffset() - 1));
            } else if (node.getOffset() == selection.getOffset() && !this.isBeginOfExpression((INode)node)) {
                node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(selection.getOffset() - 1));
            }
            if (node != null) {
                EObject currentSemanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                while (!this.contains(currentSemanticElement, (INode)node, selection) || !(currentSemanticElement instanceof XExpression)) {
                    if ((node = this.nextNodeForFindSelectedExpression(currentSemanticElement, (INode)node, selection)) == null) {
                        return null;
                    }
                    currentSemanticElement = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                }
                return (XExpression)currentSemanticElement;
            }
        }
        return null;
    }

    protected INode nextNodeForFindSelectedExpression(EObject element, INode node, ITextSelection selection) {
        return node.getParent();
    }

    private boolean isHidden(INode node) {
        return node instanceof ILeafNode && ((ILeafNode)node).isHidden();
    }

    public List<XExpression> findSelectedSiblingExpressions(XtextResource resource, ITextSelection selection) {
        ITextSelection trimmedSelection = this.trimSelection(resource, selection);
        XExpression selectedExpression = this.findSelectedExpression(resource, trimmedSelection);
        if (selectedExpression instanceof XBlockExpression) {
            ArrayList selectedExpressions = Lists.newArrayList();
            for (XExpression subExpression : ((XBlockExpression)selectedExpression).getExpressions()) {
                ITextRegion textRegion = this.getTextRegion((EObject)subExpression);
                if (!this.intersects(textRegion, trimmedSelection)) continue;
                selectedExpressions.add(subExpression);
            }
            return selectedExpressions;
        }
        if (selectedExpression == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(selectedExpression);
    }

    protected ITextSelection trimSelection(XtextResource resource, ITextSelection selection) {
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            String model = parseResult.getRootNode().getText();
            String selectedText = model.substring(selection.getOffset(), selection.getOffset() + selection.getLength());
            String trimmedSelection = selectedText.trim();
            return new TextSelection(selection.getOffset() + selectedText.indexOf(trimmedSelection), trimmedSelection.length());
        }
        return null;
    }

    protected boolean isBeginOfExpression(INode node) {
        ITextRegion textRegion = node.getTextRegion();
        if (textRegion.getLength() == 0) {
            return false;
        }
        char firstChar = node.getText().charAt(0);
        return Character.isLetterOrDigit(firstChar) || firstChar == '\'' || firstChar == '\"' || firstChar == '[' || firstChar == '(' || firstChar == '{' || firstChar == '#' || firstChar == '@';
    }

    protected boolean contains(EObject element, INode node, ITextSelection selection) {
        if (element == null) {
            return false;
        }
        ITextRegion textRegion = this.getTotalTextRegion(element, node);
        return this.contains(textRegion, selection);
    }

    protected boolean contains(ITextRegion textRegion, ITextSelection selection) {
        return textRegion.getOffset() <= selection.getOffset() && textRegion.getOffset() + textRegion.getLength() >= selection.getOffset() + selection.getLength();
    }

    protected boolean intersects(ITextRegion textRegion, ITextSelection trimmedSelection) {
        if (textRegion.getOffset() == trimmedSelection.getOffset() + trimmedSelection.getLength()) {
            return false;
        }
        if (textRegion.getOffset() + textRegion.getLength() == trimmedSelection.getOffset()) {
            return false;
        }
        return textRegion.getOffset() <= trimmedSelection.getOffset() + trimmedSelection.getLength() && textRegion.getOffset() + textRegion.getLength() >= trimmedSelection.getOffset();
    }

    protected ITextRegion getTotalTextRegion(EObject element, INode node) {
        return node.getTotalTextRegion();
    }

    public ITextRegion getTextRegion(EObject element) {
        return this.locationInFileProvider.getFullTextRegion(element);
    }

    public XExpression findSuccessorExpressionForVariableDeclaration(EObject expression) {
        EObject eContainer = expression.eContainer();
        if (eContainer == null) {
            return null;
        }
        if (expression instanceof XExpression) {
            if (eContainer instanceof XBlockExpression) {
                return (XExpression)expression;
            }
            if (this.isBlockInsertable(eContainer, expression)) {
                return (XExpression)expression;
            }
        }
        return this.findSuccessorExpressionForVariableDeclaration(eContainer);
    }

    protected boolean isBlockInsertable(EObject eContainer, EObject expression) {
        EReference ref = expression.eContainmentFeature();
        return ref == XbasePackage.Literals.XCLOSURE__EXPRESSION || ref == XbasePackage.Literals.XIF_EXPRESSION__THEN || ref == XbasePackage.Literals.XIF_EXPRESSION__ELSE || ref == XbasePackage.Literals.XCASE_PART__THEN || ref == XbasePackage.Literals.XSWITCH_EXPRESSION__DEFAULT || ref == XbasePackage.Literals.XFOR_LOOP_EXPRESSION__EACH_EXPRESSION || ref == XbasePackage.Literals.XABSTRACT_WHILE_EXPRESSION__BODY || ref == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__EXPRESSION || ref == XbasePackage.Literals.XTRY_CATCH_FINALLY_EXPRESSION__FINALLY_EXPRESSION || ref == XbasePackage.Literals.XCATCH_CLAUSE__EXPRESSION;
    }
}

