/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.ImplementedBy;
import java.util.Comparator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.quickfix.QuickAssistCompletionProposal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ImplementedBy(value=NaturalOrder.class)
public interface ICompletionProposalComparator
extends Comparator<ICompletionProposal> {

    public static class NaturalOrder
    implements ICompletionProposalComparator {
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int res;
            Integer relevance1 = this.getRelevance(o1);
            Integer relevance2 = this.getRelevance(o2);
            if (relevance1 != null && relevance2 != null && (res = relevance2.compareTo(relevance1)) != 0) {
                return res;
            }
            return o1.getDisplayString().compareToIgnoreCase(o2.getDisplayString());
        }

        protected Integer getRelevance(ICompletionProposal proposal) {
            if (proposal instanceof ConfigurableCompletionProposal) {
                return ((ConfigurableCompletionProposal)proposal).getPriority();
            }
            if (proposal instanceof TemplateProposal) {
                return ((TemplateProposal)proposal).getRelevance();
            }
            if (proposal instanceof QuickAssistCompletionProposal) {
                return ((QuickAssistCompletionProposal)proposal).getRelevance();
            }
            return null;
        }
    }
}

