/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.impl.GraphPartitionerImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.geography.names.GeographicMapper;
import org.eclipse.stem.graphsynchronizer.Activator;
import org.eclipse.stem.graphsynchronizer.GraphsynchronizerPackage;
import org.eclipse.stem.graphsynchronizer.SynchGraphPartitioner;
import org.eclipse.stem.graphsynchronizer.util.GlobalTileGenerator;
import org.eclipse.stem.jobs.simulation.ISimulation;

public class SynchGraphPartitionerImpl
extends GraphPartitionerImpl
implements SynchGraphPartitioner {
    protected Map<Decorator, Map<Integer, EList<DynamicLabel>>> decoratorProcessorNumberLabelMap = new HashMap<Decorator, Map<Integer, EList<DynamicLabel>>>();
    protected static final int NUM_NODES_EDEFAULT = 1;
    protected int numNodes = 1;
    protected static final int NODE_RANK_EDEFAULT = 0;
    protected int nodeRank = 0;
    private ISimulation currentSimulation;
    private HashMap<String, Integer> rankCache = new HashMap();

    protected SynchGraphPartitionerImpl() {
    }

    protected EClass eStaticClass() {
        return GraphsynchronizerPackage.Literals.SYNCH_GRAPH_PARTITIONER;
    }

    @Override
    public int getNumNodes() {
        return this.numNodes;
    }

    @Override
    public void setNumNodes(int newNumNodes) {
        int oldNumNodes = this.numNodes;
        this.numNodes = newNumNodes;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldNumNodes, this.numNodes));
        }
    }

    @Override
    public int getNodeRank() {
        return this.nodeRank;
    }

    @Override
    public void setNodeRank(int newNodeRank) {
        int oldNodeRank = this.nodeRank;
        this.nodeRank = newNodeRank;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldNodeRank, this.nodeRank));
        }
    }

    public void setNumProcesses(int newNumProcesses) {
        if (this.getNumProcesses() != newNumProcesses) {
            this.decoratorProcessorNumberLabelMap.clear();
        }
        super.setNumProcesses(newNumProcesses);
    }

    @Override
    public void initialize(ISimulation s) {
        if (s.equals(this.currentSimulation)) {
            return;
        }
        HashMap<String, Set<String>> nodeIdMap = new HashMap<String, Set<String>>();
        Graph g = s.getScenario().getCanonicalGraph();
        EMap nodes = g.getNodes();
        for (Map.Entry entry : nodes.entrySet()) {
            Iterator n = (Node)entry.getValue();
            String id = n.getURI().lastSegment();
            String ctry = this.getCountry(id);
            if (ctry != null && nodeIdMap.containsKey(ctry)) {
                nodeIdMap.get(ctry).add(id);
                continue;
            }
            if (ctry == null || nodeIdMap.containsKey(ctry)) continue;
            HashSet<String> ids = new HashSet<String>();
            ids.add(id);
            nodeIdMap.put(ctry, ids);
        }
        HashSet<String[]> commonBorderIdPairsSet = new HashSet<String[]>();
        for (Map.Entry entry : g.getEdges()) {
            Edge e = (Edge)entry.getValue();
            if (e.getLabel() instanceof RelativePhysicalRelationshipLabel) continue;
            String[] st = new String[2];
            if (e.getA() == null || e.getB() == null) continue;
            st[0] = e.getA().getURI().lastSegment();
            st[1] = e.getB().getURI().lastSegment();
            commonBorderIdPairsSet.add(st);
        }
        GlobalTileGenerator gtg = new GlobalTileGenerator(this.getNumNodes(), nodeIdMap, commonBorderIdPairsSet);
        List<Set<String>> partitionedNodes = gtg.getParitionedNodes();
        int rank = 0;
        for (Set<String> allIds : partitionedNodes) {
            for (String id : allIds) {
                this.rankCache.put(id, rank);
            }
            ++rank;
        }
        this.currentSimulation = s;
    }

    private String getCountry(String id) {
        if (Utility.keyLevel((String)id) == 0) {
            return id;
        }
        if (Utility.keyLevel((String)id) == -1) {
            return id;
        }
        String ctrcode = GeographicMapper.getAlpha3((String)id.substring(0, 2));
        return ctrcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<DynamicLabel> partitionDecoratorLabels(Decorator decorator, int processRank) {
        Map<Decorator, Map<Integer, EList<DynamicLabel>>> map = this.decoratorProcessorNumberLabelMap;
        synchronized (map) {
            if (this.decoratorProcessorNumberLabelMap != null && this.decoratorProcessorNumberLabelMap.containsKey(decorator) && this.decoratorProcessorNumberLabelMap.get(decorator).containsKey(processRank)) {
                EList<DynamicLabel> res = this.decoratorProcessorNumberLabelMap.get(decorator).get(processRank);
                return res;
            }
            SynchGraphPartitionerImpl synchGraphPartitionerImpl = this;
            synchronized (synchGraphPartitionerImpl) {
                BasicEList temp = new BasicEList();
                TreeSet<String> nodeURIs = new TreeSet<String>();
                for (DynamicLabel lab : decorator.getLabelsToUpdate()) {
                    String uri = lab.getIdentifiable().getURI().toString();
                    if (nodeURIs.contains(uri) || this.getNodeRank() != this.getIdentifiableRank(lab.getIdentifiable())) continue;
                    nodeURIs.add(uri);
                }
                TreeSet<String> myURIs = new TreeSet<String>();
                for (String uri : nodeURIs) {
                    if (Math.abs(uri.hashCode() % this.getNumProcesses()) != processRank) continue;
                    myURIs.add(uri);
                }
                for (DynamicLabel dl : decorator.getLabelsToUpdate()) {
                    if (!myURIs.contains(dl.getIdentifiable().getURI().toString())) continue;
                    temp.add((Object)dl);
                }
                Map<Object, Object> partitionMap = null;
                if (this.decoratorProcessorNumberLabelMap.containsKey(decorator)) {
                    partitionMap = this.decoratorProcessorNumberLabelMap.get(decorator);
                } else {
                    partitionMap = new HashMap();
                    this.decoratorProcessorNumberLabelMap.put(decorator, partitionMap);
                }
                partitionMap.put(processRank, temp);
                Activator.logInformation("Decorator decorator updates " + temp.size() + " labels");
                return temp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList<DynamicLabel> partitionDecoratorLabels(Decorator decorator) {
        if (this.decoratorProcessorNumberLabelMap != null && this.decoratorProcessorNumberLabelMap.containsKey(decorator) && this.decoratorProcessorNumberLabelMap.get(decorator).containsKey(-1)) {
            EList<DynamicLabel> res = this.decoratorProcessorNumberLabelMap.get(decorator).get(-1);
            return res;
        }
        SynchGraphPartitionerImpl synchGraphPartitionerImpl = this;
        synchronized (synchGraphPartitionerImpl) {
            BasicEList temp = new BasicEList();
            ArrayList nodeURIs = new ArrayList();
            for (DynamicLabel lab : decorator.getLabelsToUpdate()) {
                String uri = lab.getIdentifiable().getURI().toString();
                if (nodeURIs.contains(uri) || this.getNodeRank() != this.getIdentifiableRank(lab.getIdentifiable())) continue;
                temp.add((Object)lab);
            }
            Map<Object, Object> partitionMap = null;
            if (this.decoratorProcessorNumberLabelMap.containsKey(decorator)) {
                partitionMap = this.decoratorProcessorNumberLabelMap.get(decorator);
            } else {
                partitionMap = new HashMap();
                this.decoratorProcessorNumberLabelMap.put(decorator, partitionMap);
            }
            partitionMap.put(-1, temp);
            return temp;
        }
    }

    @Override
    public int getIdentifiableRank(Identifiable identifiable) {
        String key = identifiable.getURI().lastSegment();
        if (this.rankCache.containsKey(key)) {
            return this.rankCache.get(key);
        }
        Activator.logError("Unable to find server rank for node " + key + ". Assigning to first server", new Exception());
        return 0;
    }

    public boolean isManaged(Identifiable identifiable) {
        return this.getNodeRank() == this.getIdentifiableRank(identifiable);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getNumNodes();
            }
            case 2: {
                return this.getNodeRank();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setNumNodes((Integer)newValue);
                return;
            }
            case 2: {
                this.setNodeRank((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setNumNodes(1);
                return;
            }
            case 2: {
                this.setNodeRank(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.numNodes != 1;
            }
            case 2: {
                return this.nodeRank != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (numNodes: ");
        result.append(this.numNodes);
        result.append(", nodeRank: ");
        result.append(this.nodeRank);
        result.append(')');
        return result.toString();
    }
}

