/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.experiment.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.IdentifiableItemProvider;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.experiment.ExperimentPackage;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.scenario.Scenario;

public class ExperimentItemProvider
extends IdentifiableItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ExperimentItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addCompletePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addCompletePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Experiment_complete_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Experiment_complete_feature", "_UI_Experiment_type"), (EStructuralFeature)ExperimentPackage.Literals.EXPERIMENT__COMPLETE, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ExperimentPackage.Literals.EXPERIMENT__MODIFIERS);
            this.childrenFeatures.add(ExperimentPackage.Literals.EXPERIMENT__SCENARIO);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Experiment"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String getTextGen(Object object) {
        URI labelValue = ((Experiment)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_Experiment_type") : String.valueOf(this.getString("_UI_Experiment_type")) + " " + label;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Experiment.class)) {
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        ArrayList<Identifiable> identifiableCollection = new ArrayList<Identifiable>();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifiable identifable;
            URI uri;
            Object value;
            Object temp = value = iterator.next();
            if (value instanceof IFile) {
                IFile iFile = (IFile)value;
                uri = URI.createFileURI((String)iFile.getLocation().toString());
                identifable = Utility.getIdentifiable(uri);
                identifiableCollection.add(identifable);
                temp = identifable;
            } else if (value instanceof String) {
                String uriString = (String)value;
                try {
                    uri = URI.createURI((String)uriString);
                    identifable = Utility.getIdentifiable(uri);
                    temp = identifable;
                }
                catch (Exception exception) {}
            }
            if (!(temp instanceof Identifiable)) continue;
            identifiableCollection.add((Identifiable)temp);
        }
        return super.createAddCommand(domain, owner, feature, identifiableCollection, index);
    }

    protected Command createSetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        Object temp = value;
        if (value instanceof IFile) {
            IFile iFile = (IFile)value;
            URI uri = URI.createFileURI((String)iFile.getLocation().toString());
            Identifiable identifable = Utility.getIdentifiable(uri);
            temp = identifable;
        } else if (value instanceof String) {
            String uriString = (String)value;
            try {
                URI uri = URI.createURI((String)uriString);
                Identifiable identifable = Utility.getIdentifiable(uri);
                temp = identifable;
            }
            catch (Exception exception) {}
        }
        if (temp instanceof Scenario) {
            return super.createSetCommand(domain, owner, (EStructuralFeature)ExperimentPackage.eINSTANCE.getExperiment_Scenario(), temp, index);
        }
        if (temp instanceof Modifier) {
            return super.createAddCommand(domain, owner, ExperimentPackage.eINSTANCE.getExperiment().getEStructuralFeature(3), Arrays.asList(temp), index);
        }
        return super.createSetCommand(domain, owner, feature, value, index);
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return super.createDragAndDropCommand(domain, owner, location, operations | 4, operation, collection);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }
}

