/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.util.GenModelUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.importer.util.ImporterUtil;
import org.eclipse.stem.model.codegen.CodeGenConstants;
import org.eclipse.stem.model.common.ModelProjectNature;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.util.MetamodelSwitch;
import org.eclipse.stem.model.transform.Activator;
import org.eclipse.stem.model.transform.EPackageManager;
import org.eclipse.stem.model.transform.EcoreTransformSwitch;
import org.eclipse.stem.model.transform.GenModelTransformSwitch;
import org.eclipse.stem.model.transform.MetamodelResourceFactory;

public class ModelGenerator {
    private ResourceSet resourceSet;
    private GenModelTransformSwitch genModelTransformer = new GenModelTransformSwitch();
    private MetamodelSwitch<Object> ecoreTransformer = new EcoreTransformSwitch();
    private EPackage ecore;
    private GenModel genModel;
    private Package metamodel;
    Set<EPackage> containedPackages;
    Map<String, Object> loadOptions = new HashMap<String, Object>();
    private static final String JET_PROJECT_NAME = ".JETEmitters";
    private static final String TMP_PROJECT_NAME = ".stemgenerator";
    private static final String DEFAULT_ECORE_PATH = "model";
    private boolean splitModelAndEditorPlugins = false;
    private boolean generateCode = true;

    public ModelGenerator(URI modelUri) {
    }

    public ModelGenerator(Package model) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new MetamodelResourceFactory());
        this.metamodel = model;
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("genmodel", new MetamodelResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new MetamodelResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("metamodel", new MetamodelResourceFactory());
        this.resourceSet.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", new MetamodelResourceFactory());
        this.loadOptions.put("URI_HANDLER", (Object)new MetamodelResourceFactory.MetamodelURIHandler());
    }

    public static void run(Package metamodel, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("Running Model Generator", 100);
        try {
            ModelGenerator generator = new ModelGenerator(metamodel);
            generator.transform((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            generator.generate((IProgressMonitor)new SubProgressMonitor(monitor, 90));
        }
        finally {
            monitor.done();
        }
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public GenModel getGenModel() {
        return this.genModel;
    }

    public EPackage getEcore() {
        return this.ecore;
    }

    public Package getMetaModel() {
        return this.metamodel;
    }

    public void setGenModelTransformer(GenModelTransformSwitch transformer) {
        this.genModelTransformer = transformer;
    }

    public void setEcoreTransformer(MetamodelSwitch<Object> transformer) {
        this.ecoreTransformer = transformer;
    }

    public String getGeneratedModelPluginID() {
        if (this.genModel != null) {
            return this.genModel.getModelPluginID();
        }
        return null;
    }

    private void applyGenModelSettings() {
        String project = this.ecore.getNsPrefix();
        String projectSource = "/" + project + "/src";
        this.genModel.setModelPluginID(project);
        this.genModel.setModelDirectory(projectSource);
        this.genModel.setModelName(this.metamodel.getName());
        this.genModel.setEditPluginID(project);
        this.genModel.setEditDirectory(projectSource);
        this.genModel.setEditorPluginID(project);
        this.genModel.setEditorDirectory(projectSource);
        this.genModel.setImporterID("http:///org/eclipse/stem/modelgen/1.0");
        this.genModel.setTemplateDirectory("platform:/plugin/org.eclipse.stem.model.codegen/templates");
        this.genModel.getTemplatePluginVariables().add((Object)"STEM_CODEGEN=org.eclipse.stem.model.codegen");
        this.genModel.getTemplatePluginVariables().add((Object)"STEM_METAMODEL=org.eclipse.stem.model");
        this.genModel.setDynamicTemplates(true);
        this.genModel.setForceOverwrite(true);
        this.genModel.setPublicConstructors(true);
        this.genModel.setSuppressNotification(true);
        this.genModel.setComplianceLevel(CodeGenConstants.JVM_SUPPORT_LEVEL);
    }

    private void resolveEPackageCrossReferences(EObject eObject, Set<EPackage> containedEPackages) {
        if (eObject == null) {
            return;
        }
        if (eObject instanceof EPackage) {
            containedEPackages.add((EPackage)eObject);
            this.resolveEPackageCrossReferences((EObject)((EPackage)eObject).getESuperPackage(), containedEPackages);
        }
        for (EObject obj : eObject.eCrossReferences()) {
            if (!(obj.eContainer() instanceof EPackage)) continue;
            this.resolveEPackageCrossReferences(obj.eContainer(), containedEPackages);
        }
    }

    private void resolveReferencedEPackages() {
        this.containedPackages = new HashSet<EPackage>();
        this.ecore.eContainer();
        this.resolveEPackageCrossReferences((EObject)this.ecore, this.containedPackages);
        TreeIterator i = this.ecore.eAllContents();
        while (i.hasNext()) {
            EObject childEObject = (EObject)i.next();
            this.resolveEPackageCrossReferences(childEObject, this.containedPackages);
        }
    }

    private void addReferencedEPackagesToGenModel() {
        for (EPackage pkgRef : this.containedPackages) {
            URI packageGenmodelUri = (URI)EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true).get(pkgRef.getNsURI());
            GenModel gmToInclude = null;
            if (packageGenmodelUri != null) {
                try {
                    if (packageGenmodelUri.isPlatformResource()) {
                        packageGenmodelUri = URI.createPlatformPluginURI((String)packageGenmodelUri.toPlatformString(true), (boolean)true);
                    }
                    gmToInclude = this.loadGenModel(packageGenmodelUri, this.resourceSet);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (gmToInclude == null) {
                gmToInclude = EPackageManager.getInstance().findGenModelForPackage(pkgRef);
            }
            if (gmToInclude == null && pkgRef.eResource() != null) {
                EPackageManager.getInstance().loadGenModelsForResource(pkgRef.eResource(), (IProgressMonitor)new NullProgressMonitor());
                gmToInclude = EPackageManager.getInstance().findGenModelForPackage(pkgRef);
            }
            if (gmToInclude == null) continue;
            ImporterUtil.addUniqueGenPackages((List)this.genModel.getUsedGenPackages(), (List)gmToInclude.getGenPackages());
        }
        ECollections.sort((EList)this.genModel.getUsedGenPackages(), (Comparator)new Comparator<GenPackage>(){

            @Override
            public int compare(GenPackage arg0, GenPackage arg1) {
                return arg0.getNSURI().compareTo(arg1.getNSURI());
            }
        });
    }

    private void findAndReplaceSuperType(EClass eClass, String packageUri, String className) {
        EClass foundSuperType = null;
        for (EClass superType : eClass.getEAllSuperTypes()) {
            if (superType.eIsProxy()) {
                superType = (EClass)EcoreUtil.resolve((EObject)superType, (ResourceSet)this.resourceSet);
            }
            if (superType.getEPackage() == null || !packageUri.equals(superType.getEPackage().getNsURI()) || !className.equals(superType.getName())) continue;
            foundSuperType = superType;
        }
        if (foundSuperType != null) {
            eClass.getESuperTypes().clear();
            eClass.getESuperTypes().add(foundSuperType);
        }
    }

    private void doSTEMSpecificECoreAdjustments() {
        TreeIterator iter = EcoreUtil.getAllContents(Collections.singletonList(this.ecore));
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EClass)) continue;
            EClass ecls = (EClass)obj;
            this.findAndReplaceSuperType(ecls, "http:///org/eclipse/stem/diseasemodels/standard.ecore", "StandardDiseaseModelLabel");
            this.findAndReplaceSuperType(ecls, "http:///org/eclipse/stem/populationmodels/standard", "StandardPopulationModelLabel");
        }
    }

    private GenModel loadGenModel(URI uri, ResourceSet resourceSet) throws IOException {
        return (GenModel)this.load(uri, resourceSet);
    }

    private EObject load(URI uri, ResourceSet resourceSet) throws IOException {
        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
        Resource genModelResource = resourceSet.createResource(uri);
        genModelResource.load(this.loadOptions);
        return (EObject)genModelResource.getContents().get(0);
    }

    public void generateEcoreAndGenmodel(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Generating Ecore and Metamodel Metamodel", 2);
            monitor.subTask("Generating ECore");
            this.ecore = this.createEPackage(this.metamodel);
            this.resolveReferencedEPackages();
            this.doSTEMSpecificECoreAdjustments();
            monitor.worked(1);
            monitor.subTask("Generating GenModel");
            this.genModel = this.createGenModel(this.ecore);
            this.applyGenModelSettings();
            this.addReferencedEPackagesToGenModel();
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    public void transform(IProgressMonitor monitor) throws CoreException, IOException {
        try {
            monitor.beginTask("Transforming Metamodel", 4);
            this.setupWorkspace((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.generateEcoreAndGenmodel((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            monitor.subTask("Serializing ECore and GenModel");
            this.serializeModels(TMP_PROJECT_NAME);
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    private void serializeModels(String projectName) throws IOException {
        String modelName = this.ecore.getName();
        this.saveResource((EObject)this.ecore, this.getEcoreUri(projectName, modelName), this.resourceSet);
        this.saveResource((EObject)this.genModel, this.getGenModelUri(projectName, modelName), this.resourceSet);
        this.saveResource((EObject)this.metamodel, this.getMetamodelUri(projectName, modelName), this.resourceSet);
        EAnnotation metamodelPath = EcoreFactory.eINSTANCE.createEAnnotation();
        metamodelPath.setSource("http:///org/eclipse/stem/modelgen/metamodel");
        metamodelPath.getDetails().put((Object)"uri", (Object)this.metamodel.eResource().getURI().toString());
        this.ecore.getEAnnotations().add((Object)metamodelPath);
        this.saveResource((EObject)this.ecore, this.getEcoreUri(projectName, modelName), this.resourceSet);
    }

    protected void setupWorkspace(IProgressMonitor monitor) throws CoreException {
        IProject tmpProject;
        monitor.beginTask("Workspace Setup", 4);
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        IProject jetProject = wsr.getProject(JET_PROJECT_NAME);
        if (jetProject.exists()) {
            jetProject.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if ((tmpProject = wsr.getProject(TMP_PROJECT_NAME)).exists()) {
            tmpProject.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        tmpProject.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        tmpProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected URI getModelUri(String projectName, String modelName, String extension) {
        return URI.createPlatformResourceURI((String)("/" + projectName + "/" + DEFAULT_ECORE_PATH + "/" + modelName.toLowerCase() + "." + extension), (boolean)true);
    }

    protected URI getMetamodelUri(String projectName, String modelName) {
        return this.getModelUri(projectName, modelName, "metamodel");
    }

    protected URI getEcoreUri(String projectName, String modelName) {
        return this.getModelUri(projectName, modelName, "ecore");
    }

    protected URI getGenModelUri(String projectName, String modelName) {
        return this.getModelUri(projectName, modelName, "genmodel");
    }

    public Diagnostic generate(IProgressMonitor monitor) throws CoreException, IOException {
        BasicDiagnostic diagnosticResponse = new BasicDiagnostic();
        try {
            monitor.beginTask("Generation", 6);
            monitor.subTask("Configuring Code Generator");
            Generator g = ModelGenerator.createGenerator(this.genModel);
            this.genModel.setCanGenerate(true);
            g.setInput((Object)this.genModel);
            monitor.worked(1);
            monitor.subTask("Generating Model Code");
            Diagnostic modelResult = g.generate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", "model project", BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, 1)));
            diagnosticResponse.merge(modelResult);
            monitor.subTask("Generating Edit Code");
            Diagnostic editResult = g.generate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", "edit project", BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, 1)));
            diagnosticResponse.merge(editResult);
            monitor.subTask("Generating Editor Code");
            Diagnostic editorResult = g.generate((Object)this.genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", "editor project", BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, 1)));
            diagnosticResponse.merge(editorResult);
            monitor.subTask("Saving Models and Cleanup");
            this.serializeModels(this.genModel.getModelPluginID());
            try {
                this.addModelNature(this.genModel.getModelPluginID());
            }
            catch (CoreException ce) {
                Activator.log((IStatus)new Status(2, "org.eclipse.stem.model.transform", "Unable to add model project nature to generated project.", (Throwable)ce));
            }
            monitor.worked(1);
            monitor.subTask("Cleaning up workspace");
            this.cleanupWorkspace((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return diagnosticResponse;
    }

    private void addModelNature(String projectId) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
        ModelProjectNature.addNature((IProject)project);
        ModelProjectNature.updateBuilders((IProject)project);
    }

    private void cleanupWorkspace(IProgressMonitor monitor) throws CoreException {
        IProject jetProject;
        monitor.beginTask("Cleaning up workspace", 2);
        IWorkspaceRoot wsr = ResourcesPlugin.getWorkspace().getRoot();
        IProject tmpProject = wsr.getProject(TMP_PROJECT_NAME);
        if (tmpProject.exists()) {
            tmpProject.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        if ((jetProject = wsr.getProject(JET_PROJECT_NAME)).exists()) {
            jetProject.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }

    private EPackage createEPackage(Package modelPackage) {
        return (EPackage)this.ecoreTransformer.doSwitch((EObject)modelPackage);
    }

    private GenModel createGenModel(EPackage ePkg) {
        return this.genModelTransformer.transform(ePkg);
    }

    private void printReferencedPackages() {
        System.out.println("Referenced EPackages\n-----------");
        if (this.containedPackages != null) {
            for (EPackage pkgRef : this.containedPackages) {
                System.out.println(pkgRef.getNsURI());
            }
        }
        System.out.println("\n-----------\n");
    }

    public void saveResource(EObject model, URI locationUri, ResourceSet resourceSet) throws IOException {
        Resource r = resourceSet.createResource(locationUri);
        r.getContents().add((Object)model);
        r.save(null);
    }

    public boolean isGenerateCode() {
        return this.generateCode;
    }

    public void setGenerateCode(boolean generate) {
        this.generateCode = generate;
    }

    public void setSplitModelAndEditorPlugins(boolean split) {
        this.splitModelAndEditorPlugins = split;
    }

    public boolean isSplitModelAndEditorPlugins() {
        return this.splitModelAndEditorPlugins;
    }

    public static Generator createGenerator(GenModel genModel) {
        return GenModelUtil.createGenerator((GenModel)genModel);
    }
}

