/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.ILicenseInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class LicenseSection
extends PDESection {
    private FormEntry fURLEntry;
    private FormEntry fLicenseEntry;

    public LicenseSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.LicenseSection_title);
        section.setDescription(PDEUIMessages.LicenseSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 2));
        client.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fURLEntry = new FormEntry(client, toolkit, PDEUIMessages.LicenseSection_url, 0);
        this.fURLEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                LicenseSection.this.getLicenseInfo().setURL(entry.getValue());
            }
        });
        this.fURLEntry.setEditable(this.isEditable());
        this.fLicenseEntry = new FormEntry(client, toolkit, PDEUIMessages.LicenseSection_text, 578);
        this.fLicenseEntry.setFormEntryListener(new FormEntryAdapter(this, actionBars){

            @Override
            public void textValueChanged(FormEntry entry) {
                LicenseSection.this.getLicenseInfo().setLicense(entry.getValue());
            }
        });
        this.fLicenseEntry.setEditable(this.isEditable());
        GridDataFactory.fillDefaults().grab(true, true).indent(3, 0).applyTo((Control)this.fLicenseEntry.getText());
        GridDataFactory.fillDefaults().align(1, 1).grab(false, false).applyTo(this.fLicenseEntry.getLabel());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void refresh() {
        ILicenseInfo info = this.getLicenseInfo();
        this.fURLEntry.setValue(info.getURL(), true);
        this.fLicenseEntry.setValue(info.getLicense(), true);
        super.refresh();
    }

    public void commit(boolean onSave) {
        this.fURLEntry.commit();
        this.fLicenseEntry.commit();
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        this.fURLEntry.cancelEdit();
        this.fLicenseEntry.cancelEdit();
        super.cancelEdit();
    }

    private ILicenseInfo getLicenseInfo() {
        ILicenseInfo info = this.getProduct().getLicenseInfo();
        if (info == null) {
            info = this.getModel().getFactory().createLicenseInfo();
            this.getProduct().setLicenseInfo(info);
        }
        return info;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

