/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginConfigurationSection
extends TableSection {
    private TableViewer fConfigurationsTable;
    private TableEditor fLevelColumnEditor;
    private TableEditor fAutoColumnEditor;
    private static final char VERSION_SEPARATOR = '*';

    public PluginConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, PluginConfigurationSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_recommended, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll};
        return labels;
    }

    private static String getBundlesWithStartLevels() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("org.eclipse.core.runtime@start,");
        buffer.append("org.eclipse.equinox.common@2:start,");
        buffer.append("org.eclipse.equinox.ds@2:start,");
        buffer.append("org.eclipse.equinox.event@2:start,");
        buffer.append("org.eclipse.equinox.simpleconfigurator@1:start,");
        buffer.append("org.eclipse.equinox.p2.reconciler.dropins@start");
        return buffer.toString();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ConfigurationPageMock_sectionTitle);
        section.setDescription(PDEUIMessages.ConfigurationPageMock_sectionDesc);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 3, toolkit);
        this.createViewerPartControl(container, 65540, 3, toolkit);
        this.fConfigurationsTable = this.getTablePart().getTableViewer();
        final Table table = this.fConfigurationsTable.getTable();
        final TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(PDEUIMessages.PluginConfigurationSection_tablePluginTitle);
        column1.setWidth(300);
        final TableColumn levelColumnEditor = new TableColumn(table, 16384);
        levelColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        final TableColumn autoColumnEditor = new TableColumn(table, 16384);
        autoColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int size = table.getSize().x;
                column1.setWidth(size / 7 * 4);
                levelColumnEditor.setWidth(size / 7 * 2);
                autoColumnEditor.setWidth(size / 7 * 1);
            }
        });
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        this.fConfigurationsTable.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fConfigurationsTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.createEditors();
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(true, true);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddDefaults();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    private void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        ArrayList<Object> plugins = new ArrayList<Object>();
        if (this.getProduct().useFeatures()) {
            IProductFeature[] features = this.getProduct().getFeatures();
            int i = 0;
            while (i < features.length) {
                IProductFeature feature = features[i];
                FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
                IFeatureModel fModel = manager.findFeatureModelRelaxed(feature.getId(), feature.getVersion());
                if (fModel == null) {
                    fModel = manager.findFeatureModel(feature.getId());
                }
                if (fModel != null) {
                    IFeaturePlugin[] fPlugins = fModel.getFeature().getPlugins();
                    int j = 0;
                    while (j < fPlugins.length) {
                        IFeaturePlugin fPlugin = fPlugins[j];
                        if (!fPlugin.isFragment()) {
                            plugins.add(fPlugin);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            dialog.setElements((Object[])plugins.toArray(new IFeaturePlugin[plugins.size()]));
        } else {
            IProductPlugin[] allPlugins = this.getProduct().getPlugins();
            IPluginConfiguration[] configs = this.getProduct().getPluginConfigurations();
            int i = 0;
            while (i < allPlugins.length) {
                boolean match = false;
                int j = 0;
                while (j < configs.length) {
                    String id = allPlugins[i].getId();
                    if (id.equals(configs[j].getId())) {
                        match = true;
                        break;
                    }
                    ++j;
                }
                if (!match && !(PluginRegistry.findModel((String)allPlugins[i].getId()) instanceof IFragmentModel)) {
                    plugins.add(allPlugins[i]);
                }
                ++i;
            }
            dialog.setElements((Object[])plugins.toArray(new IProductPlugin[plugins.size()]));
        }
        dialog.setTitle(PDEUIMessages.PluginSelectionDialog_title);
        dialog.setMessage(PDEUIMessages.PluginSelectionDialog_message);
        dialog.setMultipleSelection(true);
        if (dialog.open() == 0) {
            Object[] results = dialog.getResult();
            int i = 0;
            while (i < results.length) {
                Object result = results[i];
                if (result instanceof IProductPlugin) {
                    this.addPlugin(((IProductPlugin)result).getId());
                } else if (result instanceof IFeaturePlugin) {
                    this.addPlugin(((IFeaturePlugin)result).getId());
                }
                ++i;
            }
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fConfigurationsTable.getSelection();
        if (ssel.size() > 0) {
            Object[] objects = ssel.toArray();
            IPluginConfiguration[] configurations = new IPluginConfiguration[objects.length];
            System.arraycopy(objects, 0, configurations, 0, objects.length);
            this.getProduct().removePluginConfigurations(configurations);
        }
        this.clearEditors();
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePluginConfigurations(product.getPluginConfigurations());
        this.clearEditors();
    }

    private void handleAddDefaults() {
        StringTokenizer tok = new StringTokenizer(PluginConfigurationSection.getBundlesWithStartLevels(), ",");
        ArrayList<String[]> plugins = new ArrayList<String[]>();
        IProduct product = this.getProduct();
        while (tok.hasMoreTokens()) {
            String autostart;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) continue;
            String idVersion = token.substring(0, index);
            int versionIndex = idVersion.indexOf(42);
            String id = versionIndex > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            int endStartLevelIndex = token.indexOf(58, index);
            String startLevel = "";
            if (endStartLevelIndex > 0) {
                startLevel = token.substring(index + 1, endStartLevelIndex);
                autostart = token.substring(endStartLevelIndex + 1);
            } else {
                autostart = token.substring(index + 1);
            }
            if (product.findPluginConfiguration(id) != null) continue;
            plugins.add(new String[]{id, startLevel, autostart});
        }
        if (plugins.size() > 0) {
            StringBuffer bundlesList = new StringBuffer();
            bundlesList.append('\n');
            bundlesList.append('\n');
            int i = 0;
            while (i < plugins.size()) {
                String[] config = (String[])plugins.get(i);
                bundlesList.append('\t');
                bundlesList.append(config[0]);
                bundlesList.append(", ");
                String startLevel = config[1];
                if (startLevel.length() > 0) {
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_levelColumn);
                    bundlesList.append(' ');
                    bundlesList.append(startLevel);
                } else {
                    String defaultLevelColumn = NLS.bind((String)PDEUIMessages.EquinoxPluginBlock_defaultLevelColumn, (Object)"Default");
                    bundlesList.append(defaultLevelColumn);
                }
                if ("start".equals(config[2])) {
                    bundlesList.append(", ");
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_autoColumn);
                }
                bundlesList.append('\n');
                ++i;
            }
            bundlesList.append('\n');
            if (MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)NLS.bind((String)PDEUIMessages.Product_PluginSection_RecommendedBundles_message, (Object)bundlesList.toString()))) {
                IPluginConfiguration[] pluginConfigs = new IPluginConfiguration[plugins.size()];
                int i2 = 0;
                while (i2 < plugins.size()) {
                    IProductModelFactory factory = product.getModel().getFactory();
                    IPluginConfiguration configuration = factory.createPluginConfiguration();
                    configuration.setId(((String[])plugins.get(i2))[0]);
                    String startString = ((String[])plugins.get(i2))[1];
                    if (startString.length() > 0) {
                        configuration.setStartLevel(Integer.parseInt(startString));
                    }
                    configuration.setAutoStart("start".equals(((String[])plugins.get(i2))[2]));
                    pluginConfigs[i2] = configuration;
                    ++i2;
                }
                product.addPluginConfigurations(pluginConfigs);
                this.showControls();
            }
        } else {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)PDEUIMessages.Product_PluginSection_NoRecommendedBundles_message);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.updateRemoveButtons(true, false);
    }

    private void addPlugin(String id) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IPluginConfiguration configuration = factory.createPluginConfiguration();
        configuration.setId(id);
        product.addPluginConfigurations(new IPluginConfiguration[]{configuration});
        this.fConfigurationsTable.setSelection((ISelection)new StructuredSelection((Object)configuration));
        this.showControls();
    }

    private ILabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    private void clearEditors() {
        Control oldEditor = this.fLevelColumnEditor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
        if ((oldEditor = this.fAutoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void createEditors() {
        Table table = this.fConfigurationsTable.getTable();
        this.fLevelColumnEditor = new TableEditor(table);
        this.fLevelColumnEditor.horizontalAlignment = 0x1000000;
        this.fLevelColumnEditor.minimumWidth = 40;
        this.fLevelColumnEditor.grabHorizontal = true;
        if (Util.isMac()) {
            this.fLevelColumnEditor.minimumHeight = 27;
        }
        this.fAutoColumnEditor = new TableEditor(table);
        this.fAutoColumnEditor.horizontalAlignment = 0x1000000;
        this.fAutoColumnEditor.grabHorizontal = true;
        this.fAutoColumnEditor.minimumWidth = 50;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PluginConfigurationSection.this.showControls();
            }
        });
    }

    private void showControls() {
        this.clearEditors();
        Table table = this.fConfigurationsTable.getTable();
        IStructuredSelection selection = (IStructuredSelection)this.fConfigurationsTable.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final TableItem item = table.getSelection()[0];
        if (item != null && !this.isEditable()) {
            return;
        }
        if (item != null) {
            final IPluginConfiguration ppc = (IPluginConfiguration)selection.getFirstElement();
            final Spinner spinner = new Spinner((Composite)table, 2048);
            spinner.setMinimum(0);
            String level = item.getText(1);
            int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
            spinner.setSelection(defaultLevel);
            spinner.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    int selection = spinner.getSelection();
                    item.setText(1, selection == 0 ? "default" : Integer.toString(selection));
                    ppc.setStartLevel(selection);
                }
            });
            this.fLevelColumnEditor.setEditor((Control)spinner, item, 1);
            final CCombo combo = new CCombo((Composite)table, 2056);
            combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
            combo.setText(item.getText(2));
            combo.pack();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    item.setText(2, combo.getText());
                    ppc.setAutoStart(Boolean.valueOf(combo.getText()).booleanValue());
                }
            });
            this.fAutoColumnEditor.setEditor((Control)combo, item, 2);
        }
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleGlobalRefresh();
            return;
        }
        Table table = this.fConfigurationsTable.getTable();
        int count = table.getItemCount();
        Object[] objects = e.getChangedObjects();
        boolean refreshRemove = false;
        boolean refreshRemoveAll = false;
        if (e.getChangeType() == 1) {
            if (count == 0) {
                refreshRemoveAll = true;
            }
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.add(objects[i]);
                }
                ++i;
            }
        } else if (e.getChangeType() == 2) {
            refreshRemoveAll = true;
            refreshRemove = true;
            int index = table.getSelectionIndex();
            boolean global = false;
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.remove(objects[i]);
                } else if (objects[i] instanceof IProductPlugin) {
                    global = true;
                    break;
                }
                ++i;
            }
            if (global) {
                this.handleGlobalRefresh();
            }
            if (count == 0) {
                table.deselectAll();
                this.clearEditors();
            } else if (index < count) {
                table.setSelection(index);
            } else {
                table.setSelection(count - 1);
            }
        }
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(refreshRemove, refreshRemoveAll);
    }

    private void handleGlobalRefresh() {
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.fConfigurationsTable.refresh();
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        if (updateRemove) {
            ISelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(2, this.isEditable() && !selection.isEmpty());
        }
        int count = this.fConfigurationsTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(3, this.isEditable() && count > 0);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private IProduct fProduct;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fProduct.getPluginConfigurations();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput == newInput) {
                return;
            }
            this.fProduct = (IProduct)newInput;
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return super.getColumnImage(PluginRegistry.findModel((String)((IPluginConfiguration)obj).getId()), index);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IPluginConfiguration configuration = (IPluginConfiguration)obj;
            switch (index) {
                case 0: {
                    return configuration.getId();
                }
                case 1: {
                    return configuration.getStartLevel() == 0 ? "default" : Integer.toString(configuration.getStartLevel());
                }
                case 2: {
                    return Boolean.toString(configuration.isAutoStart());
                }
            }
            return null;
        }
    }
}

