/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.evolving.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.evolving.provider.EvolvingItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.evolving.util.EvolvingAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.provider.StandardRelativeValueProviderAdapterFactory;
import org.eclipse.ui.IStartup;

public class EvolvingRelativeValueProviderAdapterFactory
extends EvolvingAdapterFactory
implements IStartup,
RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static EvolvingItemProviderAdapterFactory itemProviderFactory;

    public EvolvingRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public void earlyStartup() {
        new EvolvingRelativeValueProviderAdapterFactory();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public void dispose() {
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return super.isFactoryForType(type) || type == RelativeValueProvider.class;
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static EvolvingItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new EvolvingItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    @Override
    public Adapter createEvolvingSIDiseaseModelLabelAdapter() {
        return new EvolvingSIDiseaseModelLabelRelativeValueProviderAdapter();
    }

    @Override
    public Adapter createEvolvingSIRDiseaseModelLabelAdapter() {
        return new EvolvingSIRDiseaseModelLabelRelativeValueProviderAdapter();
    }

    @Override
    public Adapter createEvolvingSEIRDiseaseModelLabelAdapter() {
        return new EvolvingSEIRDiseaseModelLabelRelativeValueProviderAdapter();
    }

    @Override
    public Adapter createEvolvingSIDiseaseModelLabelValueAdapter() {
        return new EvolvingSIDiseaseModelLabelValueRelativeValueProviderAdapter();
    }

    @Override
    public Adapter createEvolvingSIRDiseaseModelLabelValueAdapter() {
        return new EvolvingSIRDiseaseModelLabelValueRelativeValueProviderAdapter();
    }

    @Override
    public Adapter createEvolvingSEIRDiseaseModelLabelValueAdapter() {
        return new EvolvingSEIRDiseaseModelLabelValueRelativeValueProviderAdapter();
    }

    public static class EvolvingSEIRDiseaseModelLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)EvolvingRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class EvolvingSEIRDiseaseModelLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)EvolvingRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), (Object)PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }

    public static class EvolvingSIDiseaseModelLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)EvolvingRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class EvolvingSIDiseaseModelLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)EvolvingRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), (Object)PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }

    public static class EvolvingSIRDiseaseModelLabelRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelRelativeValueProvider {
        private IntegrationLabelValue getCurrentLabelValue() {
            return (IntegrationLabelValue)((IntegrationLabel)this.getTarget()).getCurrentValue();
        }

        private RelativeValueProvider getCurrentLabelValueRelativeValueProvider() {
            return (RelativeValueProvider)EvolvingRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)this.getCurrentLabelValue(), RelativeValueProvider.class);
        }

        public List<IItemPropertyDescriptor> getProperties() {
            return this.getCurrentLabelValueRelativeValueProvider().getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            return this.getCurrentLabelValueRelativeValueProvider().getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getCurrentLabelValue()).getPopulationCount();
        }
    }

    public static class EvolvingSIRDiseaseModelLabelValueRelativeValueProviderAdapter
    extends StandardRelativeValueProviderAdapterFactory.DiseaseModelLabelValueRelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            IItemPropertySource propertySource = (IItemPropertySource)EvolvingRelativeValueProviderAdapterFactory.getItemProviderFactory().adapt(this.getTarget(), (Object)PropertySource.class);
            ArrayList<IItemPropertyDescriptor> properties = new ArrayList<IItemPropertyDescriptor>();
            for (IItemPropertyDescriptor descriptor : propertySource.getPropertyDescriptors(null)) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                properties.add(descriptor);
            }
            return properties;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            IntegrationLabelValue labelValue = (IntegrationLabelValue)this.getTarget();
            double stateCount = labelValue.eGetDouble(feature.getFeatureID());
            double denominator = this.getDenominator(feature);
            if (denominator <= 0.0) {
                return 0.0;
            }
            return stateCount / denominator;
        }

        public double getDenominator(EStructuralFeature feature) {
            return ((DiseaseModelLabelValue)this.getTarget()).getPopulationCount();
        }
    }
}

